/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import spoon.Launcher;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

public class V5315
extends PvsStudioRule {
    private static final Set<String> WEAK_ALGORITHMS = Set.of("DES", "DESede", "RC2", "RC4", "PBEWithMD5AndDES", "Blowfish", "RC5");
    private static final Launcher launcher = new Launcher();
    private static final CtInvocation<?> cipherInvocation = (CtInvocation)launcher.getFactory().createCodeSnippetExpression("javax.crypto.Cipher.getInstance(\"\")").compile();
    private static final CtInvocation<?> keyGeneratorInvocation = (CtInvocation)launcher.getFactory().createCodeSnippetExpression("javax.crypto.KeyGenerator.getInstance(\"\")").compile();
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setCwe(327).setSastId("CERT-MSC61-J, OWASP-6.2.5").setSecId("SEC-SECURITY").setMessage("Use of the '%s' cryptographic algorithm is not recommended. Such code may cause the exposure of sensitive data.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern ecbRule = new PvsStudioRule.PatternBuilder().setCwe(327).setSastId("CERT-MSC61-J, OWASP-6.2.5").setSecId("SEC-SECURITY").setMessage("Use of the '%s' encryption mode for cryptographic purposes is not recommended. The resulting ciphertext may expose the plaintext data patterns.").setLevel(WarningLevel.LEVEL_2).build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.isInsideTestClass((CtElement)inv)) {
            return;
        }
        CtExecutableReference executable = inv.getExecutable();
        CtExecutableReference cipherExecutable = cipherInvocation.getExecutable();
        CtExecutableReference keyGeneratorExecutable = keyGeneratorInvocation.getExecutable();
        if (!executable.equals((Object)cipherExecutable) && !executable.equals((Object)keyGeneratorExecutable)) {
            return;
        }
        CtExpression argument = (CtExpression)inv.getArguments().get(0);
        this.checkArgument((CtAbstractInvocation<?>)inv, (CtExpression<?>)argument);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        String keySpec = "javax.crypto.spec.SecretKeySpec";
        String constructorType = inv.getExecutable().getType().getQualifiedName();
        if (!keySpec.equals(constructorType)) {
            return;
        }
        List arguments = inv.getArguments();
        CtExpression argument = (CtExpression)arguments.get(arguments.size() - 1);
        this.checkArgument((CtAbstractInvocation<?>)inv, (CtExpression<?>)argument);
    }

    private void checkArgument(CtAbstractInvocation<?> inv, CtExpression<?> argument) {
        if (argument == null) {
            return;
        }
        VirtualValue virtualValue = this.getValue((CtElement)argument).getVirtualValue();
        if (virtualValue == null) {
            return;
        }
        OptionalStringView stringValue = virtualValue.getSingletonString();
        if (!stringValue.isPresent()) {
            return;
        }
        String stringArgument = stringValue.get();
        String[] algorithmArguments = stringArgument.split("/");
        String algorithm = algorithmArguments[0];
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)algorithm, (CharSequence[])WEAK_ALGORITHMS.toArray(new String[0]))) {
            this.rule.add((CtElement)inv, algorithm);
            return;
        }
        if (algorithmArguments.length == 1) {
            return;
        }
        String encryptionMode = algorithmArguments[1];
        if (encryptionMode.equalsIgnoreCase("ECB")) {
            this.ecbRule.add((CtElement)inv, encryptionMode);
        }
    }
}

