/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.utility.ArrayValueWrapper;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import spoon.Launcher;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtExecutableReference;

public class V5314
extends PvsStudioRule {
    private static final Set<String> WEAK_ALGORITHMS = Set.of("MD2", "MD5", "SHA", "SHA1", "SHA-1");
    private static final Set<String> SECURITY_SENSITIVE_CONTEXT_KEYWORDS = Set.of("token", "auth", "password", "security", "secure", "encrypt", "decrypt", "credential", "key", "cipher", "signature", "salt", "privacy", "access", "ssl", "tls", "jwt", "identity", "fingerprint", "socket", "request", "session");
    private static final Launcher launcher = new Launcher();
    private static final CtInvocation<?> digestInvocation = (CtInvocation)launcher.getFactory().createCodeSnippetExpression("java.security.MessageDigest.getInstance(\"\")").compile();
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setLevel(WarningLevel.LEVEL_3).setCwe(1240).setSastId("OWASP-6.2.5, CERT-MSC61-J").setSecId("SEC-SECURITY").setMessage("Use of the '%s' hash algorithm is not recommended.").build();
    private final PvsStudioRule.Pattern securityRule = new PvsStudioRule.PatternBuilder().setLevel(WarningLevel.LEVEL_2).setCwe(1240).setSastId("OWASP-6.2.5, CERT-MSC61-J").setSecId("SEC-SECURITY").setMessage("Use of the '%s' hash algorithm is not recommended. Such code may cause the exposure of sensitive data.").build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        CtExecutableReference digestExecutable;
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        CtExecutableReference executable = inv.getExecutable();
        if (!executable.equals((Object)(digestExecutable = digestInvocation.getExecutable()))) {
            return;
        }
        CtExpression argument = (CtExpression)inv.getArguments().get(0);
        if (argument == null) {
            return;
        }
        VirtualValue virtualValue = argument instanceof CtArrayRead ? new ArrayValueWrapper(this.getDataFlow()).getValue((CtArrayRead)argument).getVirtualValue() : this.getValue((CtElement)argument).getVirtualValue();
        if (virtualValue == null) {
            return;
        }
        OptionalStringView stringValue = virtualValue.getSingletonString();
        if (!stringValue.isPresent()) {
            return;
        }
        String stringArgument = stringValue.get();
        if (WEAK_ALGORITHMS.contains(stringArgument)) {
            CtClass parentClass = (CtClass)inv.getParent(CtClass.class);
            if (parentClass != null && this.isSecuritySensitive(parentClass.getQualifiedName())) {
                this.securityRule.add((CtElement)inv, stringArgument);
                return;
            }
            CtExecutable parentExecutable = (CtExecutable)inv.getParent(CtExecutable.class);
            if (parentExecutable != null) {
                String parentExecutableName = parentExecutable.getSimpleName();
                if (this.isSecuritySensitive(parentExecutableName)) {
                    this.securityRule.add((CtElement)inv, stringArgument);
                    return;
                }
                if (StringUtils.containsIgnoreCase((CharSequence)parentExecutableName, (CharSequence)stringArgument.replace("-", ""))) {
                    return;
                }
            }
            this.rule.add((CtElement)inv, stringArgument);
        }
    }

    private boolean isSecuritySensitive(String str) {
        return StringUtils.containsAnyIgnoreCase((CharSequence)str, (CharSequence[])SECURITY_SENSITIVE_CONTEXT_KEYWORDS.toArray(new String[0]));
    }
}

