/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import spoon.Launcher;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

public class V5313
extends PvsStudioRule {
    private static final Set<String> WEAK_PROTOCOLS = Set.of("SSLv2", "SSLv3", "TLSv1", "TLSv1.1");
    private static final Launcher launcher = new Launcher();
    private static final CtInvocation<?> sslInvocation = (CtInvocation)launcher.getFactory().createCodeSnippetExpression("javax.net.ssl.SSLContext.getInstance(\"TLS\")").compile();
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setCwe(327).setSastId("OWASP-9.1.3, CERT-MSC61-J").setSecId("SEC-SECURITY").setMessage("Do not use old versions of SSL/TLS protocols as it may cause security issues. Insecure protocols: %s.").setLevel(WarningLevel.LEVEL_1).build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        CtExecutableReference sslExecutable;
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        CtExecutableReference executable = inv.getExecutable();
        if (!executable.equals((Object)(sslExecutable = sslInvocation.getExecutable()))) {
            return;
        }
        CtExpression argument = (CtExpression)inv.getArguments().get(0);
        if (argument == null) {
            return;
        }
        VirtualValue virtualValue = this.getValue((CtElement)argument).getVirtualValue();
        if (virtualValue == null) {
            return;
        }
        OptionalStringView stringValue = virtualValue.getSingletonString();
        if (!stringValue.isPresent()) {
            return;
        }
        String stringArgument = stringValue.get();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)stringArgument, (CharSequence[])WEAK_PROTOCOLS.toArray(new String[0]))) {
            this.rule.add((CtElement)inv, stringArgument);
        }
    }
}

