/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.TaintFlag;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import com.pvsstudio.rules.V5311;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class V5310
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(77).setSastId("OWASP-5.3.8").setSecId("SEC-TAINT").setMessage("Possible command injection. Potentially tainted data is used to create OS command.");
    private final PvsStudioRule.LinkedRule<V5311> linkedRule = new PvsStudioRule.LinkedRule<V5311>(V5311.class);

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible command injection. Potentially tainted data " + prefix + " '%s' " + type + " is used to create OS command.";
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.OS_COMMAND_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.OS_COMMAND_SINK;
    }

    @Override
    protected Collection<CtExpression<?>> findSinks(@NotNull CtAbstractInvocation<?> inv) {
        ArrayList sinks = new ArrayList();
        List args = inv.getArguments();
        for (CtExpression arg : args) {
            CtTypeReference reference = arg.getType();
            String[] stringTypes = new String[]{"java.lang.String", "java.lang.CharSequence"};
            if (reference.isArray()) {
                reference = ((CtArrayTypeReference)reference).getArrayType();
            }
            CtTypeReference finalReference = reference;
            if (!Arrays.stream(stringTypes).anyMatch(typeName -> finalReference.getQualifiedName().equals(typeName))) continue;
            sinks.add(arg);
        }
        return sinks;
    }

    @Override
    protected PvsStudioRule.Pattern buildRule(TaintResult res, String prefix, String type, CtElement sink) {
        CtStatement statement = (CtStatement)sink.getParent(CtStatement.class);
        if (statement instanceof CtAbstractInvocation) {
            CtAbstractInvocation invocation = (CtAbstractInvocation)statement;
            if (this.annotationService.getAnnotations((CtElement)invocation).contains((Annotation)FlagAnnotation.OS_ARGUMENT_SINK)) {
                return this.linkedRule.get().buildRule(res, prefix, type, sink);
            }
            List args = invocation.getArguments();
            if (args.indexOf(sink) > 0) {
                return this.linkedRule.get().buildRule(res, prefix, type, sink);
            }
        }
        PvsStudioRule.Pattern rule = res.hasFlag(TaintFlag.RIGHT_PART_OF_CONCAT) || this.isPartOfArray(sink) ? this.linkedRule.get().buildRule(res, prefix, type, sink) : super.buildRule(res, prefix, type, sink);
        return rule;
    }

    private boolean isPartOfArray(CtElement sink) {
        if (sink instanceof CtArrayAccess || sink.getParent() instanceof CtNewArray) {
            return true;
        }
        return Optional.of(sink).filter(x -> x instanceof CtVariableAccess).map(x -> ((CtVariableAccess)x).getVariable()).map(CtVariableReference::getType).filter(CtTypeInformation::isArray).isPresent() && !(sink.getParent() instanceof CtArrayAccess);
    }
}

