/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import com.pvsstudio.visitors.StringConcatenationVisitor;
import java.util.Objects;
import java.util.Optional;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtParameterReference;

public class V5309
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(89).setSastId("OWASP-5.3.4, OWASP-5.3.5").setSecId("SEC-TAINT").setMessage("Possible SQL injection. Potentially tainted data is used to create SQL command.");

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible SQL injection. Potentially tainted data " + prefix + " '%s' " + type + " is used to create SQL command.";
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.SQL_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.SQL_INJECTION_SINK;
    }

    @Override
    protected boolean useAsPublicConsideredSource(CtParameterReference<?> parameter, CtExecutable<?> executable) {
        Optional<CtParameter> parameterOptional = executable.getParameters().stream().filter(p -> p.getReference().equals((Object)parameter)).findFirst();
        return parameterOptional.isPresent() && Objects.requireNonNull(this.getJavaDataFlow()).getVariableUsages((CtVariable)parameterOptional.get()).anyMatch(StringConcatenationVisitor::hasConcatenation);
    }
}

