/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class V5305
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder().setMessage("Storing credentials inside source code can lead to security issues.").setCwe(798).setSastId("OWASP-2.10.4").setSecId("SEC-SECURITY").setLevel(WarningLevel.LEVEL_3).build();
    private static final Set<String> suspiciousWords = new HashSet<String>(Arrays.asList("Password", "Pass", "Paswd", "Pswrd", "Pswd", "Pwrd", "Pwd", "Passwordhash"));

    private boolean isSuspiciousMethodName(String methodName) {
        return suspiciousWords.stream().anyMatch(methodName::contains);
    }

    private boolean isSuspiciousName(String name) {
        return suspiciousWords.stream().anyMatch(word -> name.toLowerCase().contains(word.toLowerCase()));
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        if (this.isInsideTestSources((CtElement)localVariable) || !this.isStringType(localVariable.getType())) {
            return;
        }
        if (!this.isSuspiciousName(localVariable.getSimpleName())) {
            return;
        }
        String literal = this.getStringLiteral(localVariable.getDefaultExpression());
        if (literal == null) {
            return;
        }
        this.checkTextAndWriteError(localVariable.getDefaultExpression(), literal);
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        if (this.isInsideTestSources((CtElement)assignment)) {
            return;
        }
        CtExpression assignedExp = assignment.getAssigned();
        if (!(assignedExp instanceof CtVariableWrite) || !this.isStringType(assignedExp.getType())) {
            return;
        }
        if (!this.isSuspiciousName(((CtVariableWrite)assignedExp).getVariable().getSimpleName())) {
            return;
        }
        String literal = this.getStringLiteral(assignment.getAssignment());
        if (literal == null) {
            return;
        }
        this.checkTextAndWriteError(assignment.getAssignment(), literal);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        List arguments = inv.getArguments();
        if (arguments.isEmpty()) {
            return;
        }
        CtExecutable executable = inv.getExecutable().getExecutableDeclaration();
        if (executable == null) {
            return;
        }
        List declaringParameters = executable.getParameters();
        if (declaringParameters.size() != arguments.size()) {
            return;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            String literal = this.getStringLiteral((CtExpression)arguments.get(i));
            if (literal == null || !this.isSuspiciousName(((CtParameter)declaringParameters.get(i)).getSimpleName())) continue;
            this.checkTextAndWriteError((CtExpression)arguments.get(i), literal);
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        if (inv.getParent(CtLocalVariable.class) != null || inv.getParent(CtAssignment.class) != null || inv.getParent(CtReturn.class) != null) {
            return;
        }
        CtExecutableReference executable = inv.getExecutable();
        if (executable == null) {
            return;
        }
        String executableName = executable.getSimpleName();
        if (Objects.equals(executableName, "equals") && inv.getTarget() != null) {
            this.checkEqualsOperator(inv);
        }
        if (!this.isSuspiciousMethodName(executableName)) {
            return;
        }
        List arguments = inv.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        for (CtExpression argument : arguments) {
            String literal = this.getStringLiteral(argument);
            if (literal == null) continue;
            this.checkTextAndWriteError(argument, literal);
        }
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        if (this.isInsideTestSources((CtElement)switchStatement)) {
            return;
        }
        CtExpression selector = switchStatement.getSelector();
        if (!(selector instanceof CtVariableAccess)) {
            return;
        }
        if (!this.isStringType(selector.getType())) {
            return;
        }
        String selectorName = ((CtVariableAccess)selector).getVariable().getSimpleName();
        if (!this.isSuspiciousName(selectorName)) {
            return;
        }
        List cases = switchStatement.getCases();
        for (CtCase c : cases) {
            String literal = this.getStringLiteral(c.getCaseExpression());
            if (literal == null) continue;
            this.checkTextAndWriteError(c.getCaseExpression(), literal);
        }
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (this.isInsideTestSources((CtElement)operator)) {
            return;
        }
        BinaryOperatorKind kind = operator.getKind();
        if (kind != BinaryOperatorKind.EQ && kind != BinaryOperatorKind.NE) {
            return;
        }
        CtExpression leftHandOperand = operator.getLeftHandOperand();
        CtExpression rightHandOperand = operator.getRightHandOperand();
        if (leftHandOperand instanceof CtVariableAccess) {
            this.checkOperand((CtVariableAccess)leftHandOperand, rightHandOperand);
        }
        if (rightHandOperand instanceof CtVariableAccess) {
            this.checkOperand((CtVariableAccess)rightHandOperand, leftHandOperand);
        }
    }

    private void checkOperand(CtVariableAccess<?> variable, CtExpression<?> comparisonExp) {
        String literal;
        CtTypeReference varType = variable.getVariable().getType();
        String varName = variable.getVariable().getSimpleName();
        if (this.isSuspiciousName(varName) && this.isStringType(comparisonExp.getType()) && this.isStringType(varType) && (literal = this.getStringLiteral(comparisonExp)) != null) {
            this.checkTextAndWriteError(comparisonExp, literal);
        }
    }

    private void checkEqualsOperator(CtInvocation<?> inv) {
        List arguments;
        CtExpression target = inv.getTarget();
        if (target instanceof CtVariableAccess) {
            if (!this.isSuspiciousName(((CtVariableAccess)target).getVariable().getSimpleName())) {
                return;
            }
        } else if (target instanceof CtTypeAccess) {
            if (!Objects.equals(((CtTypeAccess)inv.getTarget()).getAccessedType().getQualifiedName(), "java.util.Objects")) {
                return;
            }
        } else {
            return;
        }
        if ((arguments = inv.getArguments()).size() == 1) {
            String literal = this.getStringLiteral((CtExpression)arguments.get(0));
            if (literal != null) {
                this.checkTextAndWriteError((CtExpression)arguments.get(0), literal);
            }
            return;
        }
        if (arguments.size() != 2) {
            return;
        }
        CtVariableAccess variable = null;
        String literal = null;
        if (arguments.get(0) instanceof CtVariableAccess) {
            variable = (CtVariableAccess)arguments.get(0);
            literal = this.getStringLiteral((CtExpression)arguments.get(1));
        } else if (arguments.get(1) instanceof CtVariableAccess) {
            variable = (CtVariableAccess)arguments.get(1);
            literal = this.getStringLiteral((CtExpression)arguments.get(0));
        }
        if (variable == null || literal == null) {
            return;
        }
        if (this.isSuspiciousName(variable.getVariable().getSimpleName())) {
            if (arguments.get(0) instanceof CtVariableAccess) {
                this.checkTextAndWriteError((CtExpression)arguments.get(1), literal);
            } else {
                this.checkTextAndWriteError((CtExpression)arguments.get(0), literal);
            }
        }
    }

    private boolean isStringType(CtTypeReference<?> type) {
        return type != null && "java.lang.String".equals(type.getQualifiedName());
    }

    @Nullable
    private String getStringLiteral(CtExpression<?> expression) {
        if (!(expression instanceof CtLiteral)) {
            return null;
        }
        if (((CtLiteral)expression).getValue() == null || !(((CtLiteral)expression).getValue() instanceof String)) {
            return null;
        }
        return (String)((CtLiteral)expression).getValue();
    }

    private void checkTextAndWriteError(CtExpression<?> literal, String stringLiteral) {
        if (stringLiteral.length() <= 1 || StringUtils.isBlank((CharSequence)stringLiteral)) {
            return;
        }
        this.pattern.add((CtElement)literal, new Object[0]);
    }
}

