/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.V6082;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.rules.annotation.DuplicateRule;
import com.pvsstudio.rules.annotation.SecondaryRule;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;

@SecondaryRule
@DuplicateRule(primary=V6082.class)
public class V5304
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder patternBuilder = new PvsStudioRule.PatternBuilder().setCwe(609).setSastId("OWASP-1.11.3, CERT-LCK10-J").setSecId("SEC-SYNCHRONIZATION");
    private final PvsStudioRule.Pattern nonVolatileFieldPattern = this.patternBuilder.setMessage("Unsafe double-checked locking. The field should be declared as volatile.").setLevel(WarningLevel.LEVEL_1).build();
    private final PvsStudioRule.Pattern nonAtomicPattern = this.patternBuilder.setMessage("Unsafe double-checked locking. Object was assigned to the field before it was initialized.").build();
    private final PvsStudioRule.Pattern reassignNonNullPattern = this.patternBuilder.setMessage("Unsafe double-checked locking. A previously assigned object may be replaced by another object.").setLevel(WarningLevel.LEVEL_2).build();

    public void applyNonVolatileField(CtElement dcl, CtField<?> field) {
        this.nonVolatileFieldPattern.add((CtElement)field, new Object[0]).addSourcePosition(dcl, this.getModule());
    }

    public void applyNonAtomicInitialization(CtElement dcl, CtStatement assignment, WarningLevel level) {
        WarningAdapter warning = this.nonAtomicPattern.add((CtElement)assignment, new Object[0]).setLevel(level);
        if (!assignment.hasParent(dcl)) {
            warning.addSourcePosition(dcl, this.getModule());
        }
    }

    public void applyFieldReassign(CtStatement initialAssignment, CtStatement reassignment) {
        this.reassignNonNullPattern.add((CtElement)reassignment, new Object[0]).addSourcePosition((CtElement)initialAssignment, this.getModule());
    }
}

