/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;

public class V5302
extends PvsStudioRule {
    private final PvsStudioRule.Pattern pattern = new PvsStudioRule.PatternBuilder(this).setMessage("Exception classes should be publicly accessible.").setLevel(WarningLevel.LEVEL_3).setCwe(544).setSastId("OWASP-7.4.2").build();

    public <T> void visitCtClass(CtClass<T> ctClass) {
        CtElement parentClass;
        if (ctClass.getSuperclass() == null) {
            return;
        }
        if (ctClass.isAnonymous()) {
            return;
        }
        CtType declaringType = ctClass.getDeclaringType();
        if (declaringType != null && declaringType.isInterface()) {
            return;
        }
        if (ctClass.isPublic() && ctClass.isTopLevel()) {
            return;
        }
        if (this.isInsideTestSources((CtElement)ctClass) || this.isAnnotated("VisibleForTesting")) {
            return;
        }
        if (!this.superClassIsThrowable(ctClass)) {
            return;
        }
        WarningAdapter warningAdapter = null;
        CtType superClassDeclaration = ctClass.getSuperclass().getTypeDeclaration();
        if (superClassDeclaration != null && superClassDeclaration.isPublic() && !ctClass.isPublic() || ctClass.isLocalType()) {
            warningAdapter = this.pattern.add((CtElement)ctClass, new Object[0]);
        }
        if ((parentClass = ctClass.getParent()) instanceof CtClass && !((CtClass)parentClass).isPublic()) {
            if (warningAdapter == null) {
                warningAdapter = this.pattern.add((CtElement)ctClass, new Object[0]);
            }
            warningAdapter.addSourcePosition(parentClass, this.getModule());
        }
    }

    private boolean superClassIsThrowable(@NotNull CtClass<?> ctClass) {
        CtTypeReference superClass = ctClass.getSuperclass();
        while (superClass.getSuperclass() != null) {
            superClass = superClass.getSuperclass();
        }
        return Objects.equals(superClass.getQualifiedName(), "java.lang.Throwable");
    }
}

