/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtTypeInformation;

public class V5301
extends PvsStudioRule {
    private static final Set<String> EXCLUDED_EXCEPTION_TYPES = Set.of("java.lang.NumberFormatException", "java.time.format.DateTimeParseException", "java.text.ParseException", "java.net.MalformedURLException");
    private static final Set<String> EXCLUDED_EXCEPTION_NAMES = Set.of("ignor", "skip", "suppress", "discard", "silenc", "expect", "benign");
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(1069).setSastId("OWASP-7.4.2, CERT-ERR00-J").setLevel(WarningLevel.LEVEL_3);
    private final PvsStudioRule.Pattern emptyCatch = this.ruleBuilder.setMessage("An empty exception handler. Silent suppression of exceptions may hide the presence of bugs or vulnerabilities.").build();
    private final PvsStudioRule.Pattern emptyFinally = this.ruleBuilder.setMessage("An empty 'finally' block. The block is excessive or incomplete.").build();

    public void visitCtTry(CtTry tryBlock) {
        this.apply(tryBlock);
    }

    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.apply((CtTry)tryWithResource);
    }

    private void apply(@NotNull CtTry ctTry) {
        if (this.isInsideTestSources((CtElement)ctTry)) {
            return;
        }
        List catchers = ctTry.getCatchers();
        for (CtCatch catcher : catchers) {
            if (this.isInterrupted(catcher) || this.typeOfExceptionIsExcluded(catcher) || this.nameOfExceptionIsExcluded(catcher) || !catcher.getBody().getStatements().isEmpty()) continue;
            this.emptyCatch.add((CtElement)catcher, new Object[0]);
        }
        CtBlock finalizer = ctTry.getFinalizer();
        if (finalizer != null && finalizer.getStatements().isEmpty()) {
            this.emptyFinally.add((CtElement)finalizer, new Object[0]);
        }
    }

    private boolean typeOfExceptionIsExcluded(@NotNull CtCatch ctCatch) {
        return ctCatch.getParameter().getMultiTypes().stream().map(CtTypeInformation::getQualifiedName).allMatch(EXCLUDED_EXCEPTION_TYPES::contains);
    }

    private boolean nameOfExceptionIsExcluded(@NotNull CtCatch ctCatch) {
        return EXCLUDED_EXCEPTION_NAMES.stream().anyMatch(name -> ctCatch.getParameter().getSimpleName().startsWith((String)name));
    }

    private boolean isInterrupted(@NotNull CtCatch ctCatch) {
        return ctCatch.getParameter().getMultiTypes().stream().allMatch(type -> type.getQualifiedName().equals("java.lang.InterruptedException"));
    }
}

