/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.TaintSource;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

public abstract class TaintRule
extends PvsStudioRule {
    private static final Set<String> GET_PROPERTY_SOURCE_KEYS_BLACKLIST = Set.of("file.encoding", "file.separator", "java.class.path", "java.class.version", "java.home", "java.io.tmpdir", "java.library.path", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url", "java.vendor.url.bug", "java.vendor.version", "java.version", "java.version.date", "java.vm.compressedOopsMode", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "jdk.debug", "line.separator", "native.encoding", "os.arch", "os.name", "os.version", "path.separator", "stderr.encoding", "stdout.encoding", "sun.arch.data.model", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.command", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level", "user.country", "user.dir", "user.home", "user.language", "user.name", "user.script", "user.variant");

    protected abstract PvsStudioRule.PatternBuilder getPatternBuilder();

    protected abstract FlagAnnotation getSanitizationAnnotation();

    protected abstract FlagAnnotation getSinkAnnotation();

    protected abstract String getExtendedMessage(String var1, String var2);

    protected boolean isOnlyWebSource() {
        return false;
    }

    protected boolean isPublicConsideredSource() {
        return true;
    }

    protected boolean useAsPublicConsideredSource(CtParameterReference<?> parameter, CtExecutable<?> executable) {
        return true;
    }

    protected boolean isMainConsideredSource() {
        return true;
    }

    protected boolean isInvocationCorrectHook(CtAbstractInvocation<?> inv) {
        return true;
    }

    protected Collection<CtExpression<?>> findSinks(@NotNull CtAbstractInvocation<?> el) {
        int lastIndex;
        CtTypeReference last;
        List parameters;
        boolean first;
        Annotations methodAnnotation = this.annotationService.getAnnotations(el);
        boolean target = methodAnnotation.contains((Annotation)FlagAnnotation.TARGET_SINK);
        boolean second = methodAnnotation.contains((Annotation)FlagAnnotation.SECOND_ARGUMENT_SINK);
        boolean varArgs = methodAnnotation.contains((Annotation)FlagAnnotation.VARARGS_SINK);
        List actualArguments = el.getArguments();
        if (!(target || second || varArgs)) {
            return actualArguments.isEmpty() ? List.of() : List.of((CtExpression)actualArguments.get(0));
        }
        ArrayList<Object> result = new ArrayList<Object>(3);
        if (target && el instanceof CtInvocation) {
            result.add(((CtInvocation)el).getTarget());
        }
        if ((first = methodAnnotation.contains((Annotation)FlagAnnotation.FIRST_ARGUMENT_SINK)) && !actualArguments.isEmpty()) {
            result.add((CtExpression)actualArguments.get(0));
        }
        if (second && actualArguments.size() >= 2) {
            result.add((CtExpression)actualArguments.get(1));
        }
        if (varArgs && !actualArguments.isEmpty() && !(parameters = el.getExecutable().getParameters()).isEmpty() && (last = (CtTypeReference)parameters.get(lastIndex = parameters.size() - 1)).isArray() && lastIndex < actualArguments.size()) {
            List variableArguments = actualArguments.subList(lastIndex, actualArguments.size());
            result.addAll(variableArguments);
        }
        return Collections.unmodifiableCollection(result);
    }

    protected TaintRuleStrategy getStrategy() {
        return new DefaultStrategy();
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        this.apply((CtAbstractInvocation<?>)inv);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        this.apply((CtAbstractInvocation<?>)inv);
    }

    private void apply(CtAbstractInvocation<?> inv) {
        if (!this.isInvocationCorrect(inv) || !this.isInvocationCorrectHook(inv)) {
            return;
        }
        this.findSinks(inv).forEach(this::visitTaintedElement);
    }

    protected boolean isInvocationCorrect(CtAbstractInvocation<?> inv) {
        if (!this.isSink((CtElement)inv) || this.isInsideTestSources((CtElement)inv) || this.getJavaDataFlow() == null) {
            return false;
        }
        CtExecutable exe = (CtExecutable)inv.getParent(CtExecutable.class);
        return exe == null || !this.isSink((CtElement)exe);
    }

    protected boolean isSink(CtElement element) {
        return this.annotationService.getAnnotations(element).contains((Annotation)this.getSinkAnnotation());
    }

    private WarningLevel getDefaultLevel() {
        return WarningLevel.LEVEL_1;
    }

    protected WarningLevel getLevel(TaintResult res) {
        if (res.getSources().stream().filter(x -> x.getElement() instanceof CtParameter).filter(x -> x.getElement().getParent() instanceof CtMethod).map(par -> (CtMethod)par.getElement().getParent()).filter(method -> !this.hasAnnotation((CtElement)method, (Annotation)FlagAnnotation.MAIN_METHOD)).filter(method -> !this.hasAnnotation((CtElement)method, (Annotation)FlagAnnotation.CONTROLLER_METHOD)).anyMatch(CtModifiable::isPublic)) {
            return WarningLevel.LEVEL_3;
        }
        return this.getDefaultLevel();
    }

    protected void visitTaintedElement(CtElement tainted) {
        List<TaintResult> result = this.getJavaDataFlow().scanTaint(tainted, this.getStrategy(), ((Object)((Object)this)).getClass());
        if (result == null || result.isEmpty()) {
            return;
        }
        Module module = this.getModule();
        for (TaintResult taintResult : result) {
            if (!taintResult.isTainted()) continue;
            CtElement sink = taintResult.getSinkElement();
            String type = this.getTypeForMessage(sink);
            String prefix = this.getPrefixForMessage(sink);
            PvsStudioRule.Pattern rule = this.buildRule(taintResult, prefix, type, sink);
            if (rule == null) {
                return;
            }
            List<TaintSource> sources = taintResult.getSources();
            WarningAdapter adapter = rule.add(tainted, sink, sources);
            sources.stream().sorted(Comparator.comparing(x -> x.getElement().getPosition().getLine()).thenComparing(x -> x.getElement().getPosition().getColumn())).forEach(x -> adapter.addSourcePosition(x.getElement(), module));
        }
    }

    public final String getTypeForMessage(CtElement element) {
        return element instanceof CtVariableRead ? "variable" : (element instanceof CtInvocation ? "call" : "");
    }

    public final String getPrefixForMessage(CtElement element) {
        return element instanceof CtVariableRead ? "in the" : (element instanceof CtInvocation ? "from the" : "");
    }

    @Nullable
    protected PvsStudioRule.Pattern buildRule(TaintResult res, String prefix, String type, CtElement sink) {
        return this.getPatternBuilder().setLevel(this.getLevel(res)).setExtendedMessage(this.getExtendedMessage(prefix, type)).build();
    }

    protected class DefaultStrategy
    extends TaintRuleStrategy {
        private final Predicate<CtTypeReference<?>> ignorePrimitives = type -> "byte".equals(type.getQualifiedName()) || "java.lang.Byte".equals(type.getQualifiedName()) || "short".equals(type.getQualifiedName()) || "java.lang.Short".equals(type.getQualifiedName()) || "int".equals(type.getQualifiedName()) || "java.lang.Integer".equals(type.getQualifiedName()) || "long".equals(type.getQualifiedName()) || "java.lang.Long".equals(type.getQualifiedName()) || "boolean".equals(type.getQualifiedName()) || "java.lang.Boolean".equals(type.getQualifiedName()) || "float".equals(type.getQualifiedName()) || "java.lang.Float".equals(type.getQualifiedName()) || "double".equals(type.getQualifiedName()) || "java.lang.Double".equals(type.getQualifiedName()) || "char".equals(type.getQualifiedName()) || "java.lang.Char".equals(type.getQualifiedName());

        protected DefaultStrategy() {
        }

        protected Predicate<CtTypeReference<?>> ignorePrimitives() {
            return this.ignorePrimitives;
        }

        @Override
        public boolean isSource(CtElement el, CtExecutable<?> currentExecutable) {
            if (el instanceof CtParameterReference) {
                if (currentExecutable instanceof CtMethod) {
                    if (TaintRule.this.hasAnnotation((CtElement)currentExecutable, (Annotation)FlagAnnotation.CONTROLLER_METHOD)) {
                        return true;
                    }
                    if (TaintRule.this.isOnlyWebSource()) {
                        return false;
                    }
                    if (TaintRule.this.isMainConsideredSource() && TaintRule.this.hasAnnotation((CtElement)currentExecutable, (Annotation)FlagAnnotation.MAIN_METHOD)) {
                        return true;
                    }
                    return TaintRule.this.isPublicConsideredSource() && TaintRule.this.useAsPublicConsideredSource((CtParameterReference)el, currentExecutable) && ((CtMethod)currentExecutable).isPublic();
                }
            } else if (el instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)el;
                FlagAnnotation sourceAnnotation = TaintRule.this.isOnlyWebSource() ? FlagAnnotation.WEB_SOURCE : FlagAnnotation.COMMON_SOURCE;
                return !this.isIgnoredSourceInvocation(invocation) && TaintRule.this.annotationService.getAnnotations(el).contains((Annotation)sourceAnnotation);
            }
            return false;
        }

        @Override
        public boolean isSink(CtElement chainElement) {
            return TaintRule.this.hasAnnotation(chainElement, (Annotation)TaintRule.this.getSinkAnnotation());
        }

        protected boolean isIgnoredSourceInvocation(CtInvocation<?> invocation) {
            Optional<String> stringValue;
            CtExecutableReference executable = invocation.getExecutable();
            List arguments = invocation.getArguments();
            if (arguments.isEmpty()) {
                return false;
            }
            CtExpression firstArgument = (CtExpression)arguments.get(0);
            if (executable.getDeclaringType() != null && "java.lang.System".equals(executable.getDeclaringType().getQualifiedName()) && "getProperty".equals(executable.getSimpleName()) && "java.lang.String".equals(firstArgument.getType().getQualifiedName()) && (stringValue = RulesUtils.lookupStringValue(TaintRule.this.getDataFlow(), firstArgument)).isPresent()) {
                return GET_PROPERTY_SOURCE_KEYS_BLACKLIST.contains(stringValue.get());
            }
            return false;
        }

        @Override
        public boolean isSanitized(CtElement el, Context context) {
            if (context.getCurrentVariable() instanceof CtFieldReference && el instanceof CtInvocation && TaintRule.this.hasMethodFieldAnnotation((CtInvocation)el, (CtFieldReference)context.getCurrentVariable(), TaintRule.this.getSanitizationAnnotation())) {
                return true;
            }
            if (TaintRule.this.hasAnnotation(el, (Annotation)TaintRule.this.getSanitizationAnnotation()) || TaintRule.this.hasAnnotation(el, (Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION)) {
                return this.hasRealSanitization(el, context);
            }
            if (el instanceof CtTargetedExpression) {
                CtExpression target = ((CtTargetedExpression)el).getTarget();
                if (target == null) {
                    return false;
                }
                return this.isSanitized((CtElement)target, context);
            }
            if (el.getParent() instanceof CtBinaryOperator) {
                CtBinaryOperator binary = (CtBinaryOperator)el.getParent();
                return this.isSanitized((CtElement)binary, context);
            }
            return false;
        }

        private boolean hasRealSanitization(CtElement el, Context context) {
            if (!(el instanceof CtInvocation)) {
                return true;
            }
            CtInvocation invocation = (CtInvocation)el;
            if (TaintRule.this.hasAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.MODIFIES_STATE) && invocation.getTarget() instanceof CtVariableAccess && context.getCurrentVariable() != null && context.getCurrentVariable().equals((Object)((CtVariableAccess)invocation.getTarget()).getVariable())) {
                return true;
            }
            return context.isAccessedBranchCondition() || context.isStartOfVariableTraverse();
        }

        @Override
        public boolean isBranchDirectionReversed(CtElement chainElement) {
            return TaintRule.this.hasAnnotation(chainElement, (Annotation)FlagAnnotation.INVERSE_BRANCH_DIRECTION);
        }

        @Override
        public boolean isStringConcatenationMethod(CtInvocation<?> invocation) {
            return TaintRule.this.hasAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.STRING_CONCAT);
        }

        @Override
        public boolean isStringsOnly() {
            return true;
        }

        @Override
        public boolean isTypeIgnored(CtTypeReference<?> type) {
            return false;
        }

        @Override
        public boolean isBlackListCommonSanitization(CtElement element) {
            return false;
        }

        @Override
        public boolean isCommonSanitization(CtElement inv) {
            return TaintRule.this.annotationService.getAnnotations(inv).contains((Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION);
        }

        @Override
        public boolean isPushingCollectionMethod(CtInvocation<?> invocation) {
            return TaintRule.this.hasAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.PUSHING_METHOD);
        }

        @Override
        public boolean isSourceFirstElementsOnly() {
            return true;
        }
    }
}

