/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.base.Strings;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.core.OptionalStringVirtualValue;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.VariablesCache;
import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.Equality;
import com.pvsstudio.utility.TypeArchitectureScanner;
import com.pvsstudio.visitors.PvsStudioEqualsVisitor;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public final class RulesUtils {
    private static final Logger logger = LoggerFactory.getLogger(RulesUtils.class);

    private RulesUtils() {
        throw new IllegalStateException("utility class");
    }

    public static String astToString(String codeElement) {
        while (codeElement.length() > 2 && codeElement.startsWith("(") && codeElement.endsWith(")")) {
            int depth = 0;
            for (int i = 1; i < codeElement.length() - 1; ++i) {
                char c = codeElement.charAt(i);
                if (c == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                if (depth == 0) {
                    return codeElement;
                }
                --depth;
            }
            codeElement = codeElement.substring(1, codeElement.length() - 1);
        }
        codeElement = codeElement.replace("\n", " ").replace("\r", "");
        return codeElement;
    }

    public static boolean isSubtypeOf(CtExpression<?> argument, String ... types) {
        CtTypeReference argumentType;
        if (argument == null || types == null) {
            return false;
        }
        if (argument.getType() == null || argument.getType() instanceof CtTypeParameterReference) {
            return false;
        }
        CtTypeReference ctTypeReference = argumentType = argument.getTypeCasts().isEmpty() ? argument.getType() : (CtTypeReference)argument.getTypeCasts().get(0);
        if (argumentType == null) {
            return false;
        }
        return Stream.of(types).anyMatch(type -> argumentType.box().isSubtypeOf(argument.getFactory().Type().createReference(type).box()));
    }

    public static boolean implementsType(@NotNull CtTypeReference<?> ctType, final @NotNull String typeQualifiedNameToFind, boolean checkSuperTypes) {
        TypeArchitectureScanner.Config config = new TypeArchitectureScanner.Config().setInterfaceScanningEnableFlag(true).setParentClassesScanningEnableFlag(checkSuperTypes).setParentInterfacesScanningEnableFlag(checkSuperTypes);
        TypeArchitectureScanner<Boolean> scanner = new TypeArchitectureScanner<Boolean>(config){

            void visitTypeReference(CtTypeReference<?> typeReference) {
                if (typeReference.getQualifiedName().equals(typeQualifiedNameToFind)) {
                    this.setResult(true);
                    this.terminate();
                }
            }

            @Override
            protected void visitInterface(CtTypeReference<?> ctInterface) {
                this.visitTypeReference(ctInterface);
            }

            @Override
            protected void visitClass(CtTypeReference<?> ctClass) {
                this.visitTypeReference(ctClass);
            }

            @Override
            protected void visitEnum(CtTypeReference<?> ctEnum) {
                this.visitTypeReference(ctEnum);
            }
        };
        scanner.scan(ctType);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    public static boolean isDefault(CtCase<?> caseStatement) {
        return caseStatement.getCaseExpression() == null;
    }

    public static boolean isConstantExpression(VariablesCache vars, CtExpression<?> e) {
        if (e instanceof CtLiteral) {
            return true;
        }
        if (e instanceof CtBinaryOperator) {
            CtBinaryOperator op = (CtBinaryOperator)e;
            return RulesUtils.isConstantExpression(vars, op.getLeftHandOperand()) && RulesUtils.isConstantExpression(vars, op.getRightHandOperand());
        }
        if (e instanceof CtUnaryOperator) {
            return RulesUtils.isConstantExpression(vars, ((CtUnaryOperator)e).getOperand());
        }
        if (e instanceof CtVariableAccess) {
            CtVariable<?> var = vars.resolve(((CtVariableAccess)e).getVariable());
            return var instanceof CtEnumValue || var != null && var.isStatic() && var.isFinal();
        }
        if (e instanceof CtNewArray) {
            return ((CtNewArray)e).getElements().isEmpty() && ((CtNewArray)e).getDimensionExpressions().stream().allMatch(el -> RulesUtils.isConstantExpression(vars, el));
        }
        return false;
    }

    public static Object getConstantExpression(VariablesCache vars, CtExpression<?> e) {
        CtVariable<?> val;
        if (e instanceof CtLiteral) {
            return ((CtLiteral)e).getValue();
        }
        if (e instanceof CtVariableAccess && (val = vars.resolve(((CtVariableAccess)e).getVariable())) != null && val.isStatic() && val.isFinal() && val.getDefaultExpression() != null && val.getDefaultExpression() instanceof CtLiteral) {
            return ((CtLiteral)val.getDefaultExpression()).getValue();
        }
        return null;
    }

    public static boolean isNullLiteral(CtElement e) {
        return e instanceof CtLiteral && ((CtLiteral)e).getValue() == null;
    }

    public static boolean isFalseLiteral(CtExpression<?> e) {
        if (e instanceof CtLiteral) {
            Object value = ((CtLiteral)e).getValue();
            return value instanceof Boolean && (Boolean)value == false;
        }
        return false;
    }

    public static boolean isFileNameContains(@NotNull CtElement element, String ... names) {
        File file = element.getPosition().getFile();
        return Stream.of(names).anyMatch(arg -> file.getName().contains((CharSequence)arg));
    }

    public static boolean isTrueLiteral(CtExpression<?> e) {
        if (e instanceof CtLiteral) {
            Object value = ((CtLiteral)e).getValue();
            return value instanceof Boolean && (Boolean)value != false;
        }
        return false;
    }

    public static String getOperatorText(UnaryOperatorKind o) {
        switch (o) {
            case POS: {
                return "+";
            }
            case NEG: {
                return "-";
            }
            case NOT: {
                return "!";
            }
            case COMPL: {
                return "~";
            }
            case PREINC: 
            case POSTINC: {
                return "++";
            }
            case PREDEC: 
            case POSTDEC: {
                return "--";
            }
        }
        throw new PvsStudioException("Unsupported operator " + o.name());
    }

    public static String getOperatorText(BinaryOperatorKind o) {
        switch (o) {
            case OR: {
                return "||";
            }
            case AND: {
                return "&&";
            }
            case BITOR: {
                return "|";
            }
            case BITXOR: {
                return "^";
            }
            case BITAND: {
                return "&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case SL: {
                return "<<";
            }
            case SR: {
                return ">>";
            }
            case USR: {
                return ">>>";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case INSTANCEOF: {
                return "instanceof";
            }
        }
        throw new PvsStudioException("Unsupported operator " + o.name());
    }

    public static boolean equals(CtElement a, CtElement b) {
        return PvsStudioEqualsVisitor.equals(a, b);
    }

    public static boolean equals(CtElement a, CtElement b, Equality first, Equality ... flags) {
        return PvsStudioEqualsVisitor.equals(a, b, first, flags);
    }

    public static String getFunctionName(CtAbstractInvocation<?> invocation) {
        if (invocation instanceof CtConstructorCall) {
            return "new " + ((CtConstructorCall)invocation).getType().getSimpleName();
        }
        return invocation.getExecutable().getSimpleName();
    }

    public static void getSubExpressions(BinaryOperatorKind operator, @NotNull CtExpression<?> e, List<CtExpression<?>> expressions) {
        CtBinaryOperator sub;
        if (e instanceof CtBinaryOperator && (sub = (CtBinaryOperator)e).getKind() == operator) {
            RulesUtils.getSubExpressions(operator, sub.getLeftHandOperand(), expressions);
            RulesUtils.getSubExpressions(operator, sub.getRightHandOperand(), expressions);
            return;
        }
        expressions.add(e);
    }

    public static List<CtExpression<?>> getSubExpressions(BinaryOperatorKind operator, @NotNull CtExpression<?> e) {
        ArrayList expressions = new ArrayList();
        RulesUtils.getSubExpressions(operator, e, expressions);
        return expressions;
    }

    public static void getAssignmentSubExpressions(@NotNull CtExpression<?> e, List<CtExpression<?>> expressions) {
        if (e instanceof CtAssignment) {
            CtAssignment sub = (CtAssignment)e;
            RulesUtils.getAssignmentSubExpressions(sub.getAssigned(), expressions);
            RulesUtils.getAssignmentSubExpressions(sub.getAssignment(), expressions);
        } else {
            expressions.add(e);
        }
    }

    public static List<CtExpression<?>> getAssignmentSubExpressions(@NotNull CtExpression<?> e) {
        ArrayList expressions = new ArrayList();
        RulesUtils.getAssignmentSubExpressions(e, expressions);
        return expressions;
    }

    @NotNull
    public static String getTypeName(CtTypeReference<?> type) {
        String qualifiedName;
        if (type != null && !(qualifiedName = type.getQualifiedName()).equals("var")) {
            return qualifiedName;
        }
        return "";
    }

    @NotNull
    public static String getTypeName(CtExpression<?> element) {
        return RulesUtils.getTypeName(RulesUtils.getType(element));
    }

    @Nullable
    public static CtTypeReference<?> getType(CtExpression<?> element) {
        if (element == null) {
            return null;
        }
        try {
            if (!element.getTypeCasts().isEmpty()) {
                return (CtTypeReference)element.getTypeCasts().get(0);
            }
            return element.getType();
        }
        catch (Exception ex) {
            logger.error("Failure to get a type", (Throwable)ex);
            return null;
        }
    }

    @NotNull
    public static String getRawTypeName(CtTypedElement<?> element) {
        try {
            return RulesUtils.getTypeName(element == null ? null : element.getType());
        }
        catch (Exception ex) {
            logger.error("Failure to get a type", (Throwable)ex);
            return "";
        }
    }

    public static boolean isBoolean(@Nullable CtExpression<?> e) {
        return RulesUtils.getTypeName(e).equals("boolean");
    }

    public static boolean isBoxedBoolean(@Nullable CtExpression<?> e) {
        return RulesUtils.getTypeName(e).equals("java.lang.Boolean");
    }

    public static boolean isBooleanOrBoxed(@Nullable CtExpression<?> e) {
        String s = RulesUtils.getTypeName(e);
        return s.equals("boolean") || s.equals("java.lang.Boolean");
    }

    public static boolean isPrimitive(@Nullable CtTypedElement<?> e) {
        return e != null && e.getType() != null && e.getType().isPrimitive();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T loadObject(@NotNull File file) throws InvalidClassException, ClassNotFoundException {
        try (FileInputStream fileStream = new FileInputStream(file);){
            Serializable serializable;
            try (ObjectInputStream objectStream = new ObjectInputStream(new BufferedInputStream(fileStream));){
                serializable = (Serializable)objectStream.readObject();
            }
            return (T)serializable;
        }
        catch (InvalidClassException | ClassNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PvsStudioException("unable to load object", e);
        }
    }

    public static <T extends Serializable> void saveObject(@NotNull T obj, @NotNull File file) {
        try (FileOutputStream fileStream = new FileOutputStream(file);
             ObjectOutputStream objectStream = new ObjectOutputStream(new BufferedOutputStream(fileStream));){
            objectStream.writeObject(obj);
            objectStream.flush();
        }
        catch (Exception e) {
            throw new PvsStudioException("unable to save object", e);
        }
    }

    @NotNull
    public static List<String> getLoopCounters(@NotNull CtFor loop) {
        ArrayList<String> res = new ArrayList<String>();
        for (CtStatement var : loop.getForInit()) {
            if (var instanceof CtLocalVariable) {
                res.add(((CtLocalVariable)var).getSimpleName());
                continue;
            }
            if (!(var instanceof CtAssignment)) continue;
            CtAssignment loc = (CtAssignment)var;
            res.add(loc.getAssigned().toString());
        }
        for (CtStatement var : loop.getForUpdate()) {
            CtUnaryOperator loc;
            CtExpression identifier = null;
            if (var instanceof CtUnaryOperator) {
                loc = (CtUnaryOperator)var;
                if (loc.getKind() == UnaryOperatorKind.POSTDEC || loc.getKind() == UnaryOperatorKind.POSTINC || loc.getKind() == UnaryOperatorKind.PREDEC || loc.getKind() == UnaryOperatorKind.PREINC) {
                    identifier = loc.getOperand();
                }
            } else if (var instanceof CtAssignment) {
                loc = (CtAssignment)var;
                identifier = loc.getAssigned();
            }
            if (identifier == null || res.contains(identifier.toString())) continue;
            res.add(identifier.toString());
        }
        return res;
    }

    @Nullable
    public static String getSingleLoopCounter(@NotNull CtFor loop) {
        List<String> res = RulesUtils.getLoopCounters(loop);
        return res.size() == 1 ? res.get(0) : null;
    }

    @NotNull
    public static List<String> splitName(@Nullable String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        MutableInt i = new MutableInt(0);
        Consumer<Predicate> reader = predicate -> {
            int end;
            int start = i.intValue();
            for (end = start + 1; end < name.length() && predicate.test(Character.valueOf(name.charAt(end))); ++end) {
            }
            res.add(name.substring(start, end));
            i.setValue(end);
        };
        while (i.intValue() < name.length()) {
            char ch = name.charAt(i.intValue());
            if (Character.isLowerCase(ch)) {
                reader.accept(Character::isLowerCase);
                continue;
            }
            if (i.intValue() < name.length() - 1 && Character.isUpperCase(ch)) {
                ch = name.charAt(i.intValue() + 1);
                if (Character.isUpperCase(ch)) {
                    reader.accept(Character::isUpperCase);
                    continue;
                }
                if (Character.isLowerCase(ch)) {
                    reader.accept(Character::isLowerCase);
                    continue;
                }
                reader.accept(c -> false);
                continue;
            }
            if (Character.isDigit(ch)) {
                reader.accept(Character::isDigit);
                continue;
            }
            if (ch != '_') {
                reader.accept(c -> false);
                continue;
            }
            i.increment();
        }
        return res;
    }

    public static boolean isRealType(@Nullable CtExpression<?> exp) {
        String name = RulesUtils.getTypeName(exp);
        return name.equals("float") || name.equals("double");
    }

    public static boolean isBoxedRealType(@Nullable CtExpression<?> exp) {
        String name = RulesUtils.getTypeName(exp);
        return name.equals("java.lang.Float") || name.equals("java.lang.Double");
    }

    public static boolean isIntegerType(@Nullable CtExpression<?> exp) {
        String name = RulesUtils.getTypeName(exp);
        return name.equals("char") || name.equals("byte") || name.equals("short") || name.equals("int") || name.equals("long");
    }

    public static boolean isBoxedIntegerType(@Nullable CtExpression<?> exp) {
        String name = RulesUtils.getTypeName(exp);
        return name.equals("java.lang.Character") || name.equals("java.lang.Byte") || name.equals("java.lang.Short") || name.equals("java.lang.Integer") || name.equals("java.lang.Long");
    }

    public static boolean isParameter(CtExpression<?> lhs) {
        return lhs instanceof CtVariableAccess && ((CtVariableAccess)lhs).getVariable() instanceof CtParameterReference;
    }

    private static Stream<? extends CtElement> getSuppressed(@NotNull CtAnnotation<?> annotation) {
        CtExpression values = annotation.getValue("value");
        if (values instanceof CtNewArray) {
            return ((CtNewArray)values).getElements().stream();
        }
        return Stream.of(values);
    }

    public static Stream<String> getSuppressed(@NotNull CtElement e) {
        return e.getAnnotations().stream().filter(Objects::nonNull).filter(annotation -> annotation.getType() != null).filter(annotation -> annotation.getType().getQualifiedName().equals("java.lang.SuppressWarnings")).flatMap(RulesUtils::getSuppressed).filter(CtLiteral.class::isInstance).map(l -> (CtLiteral)l).map(CtLiteral::getValue).filter(String.class::isInstance).map(String.class::cast);
    }

    @NotNull
    public static WarningLevel getLevel(@NotNull Result res) {
        switch (res) {
            case Level1: {
                return WarningLevel.LEVEL_1;
            }
            case Level2: {
                return WarningLevel.LEVEL_2;
            }
            case Level3: {
                return WarningLevel.LEVEL_3;
            }
        }
        throw new PvsStudioException("Invalid core.Result value");
    }

    @NotNull
    public static WarningPosition getPosition(@Nullable CtElement element, @NotNull Module module) {
        if (element == null) {
            return WarningPosition.DEFAULT;
        }
        SourcePosition position = element.getPosition();
        if (!position.isValidPosition()) {
            return WarningPosition.INVALID_POSITION;
        }
        File positionFile = position.getFile();
        int positionLine = position.getLine();
        return new WarningPosition(positionFile != null ? positionFile.getAbsolutePath() : null, positionLine, position.getEndLine(), position.getColumn() == 0 ? position.getColumn() + 1 : position.getColumn(), position.getEndColumn(), new NavigationInfo(module.getLine(positionFile, positionLine - 1).orElse(""), module.getLine(positionFile, positionLine).orElse(""), module.getLine(positionFile, positionLine + 1).orElse("")));
    }

    public static boolean isNoinspectionComment(@NotNull String comment, @NotNull String id) {
        String noinspection = "noinspection";
        int idx = comment.indexOf(noinspection);
        if (idx >= 0) {
            idx += noinspection.length();
            while (idx < comment.length() && Character.isWhitespace(comment.charAt(idx))) {
                ++idx;
            }
            if (idx < comment.length()) {
                int last = comment.indexOf(32, idx);
                if (last == -1) {
                    last = comment.length();
                }
                return ArrayUtils.contains((Object[])comment.substring(idx, last).split(","), (Object)id);
            }
        }
        return false;
    }

    @NotNull
    public static List<WarningPosition> getPositions(@NotNull Iterable<? extends CtElement> expressions, @NotNull Module module) {
        ArrayList<WarningPosition> result = new ArrayList<WarningPosition>();
        for (CtElement ctElement : expressions) {
            WarningPosition position = RulesUtils.getPosition(ctElement, module);
            if (position == WarningPosition.INVALID_POSITION) continue;
            result.add(position);
        }
        return result;
    }

    @NotNull
    public static String getQualifiedName(@NotNull CtAbstractInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        if (executable == null || executable.getDeclaringType() == null) {
            return "";
        }
        return executable.getDeclaringType().getQualifiedName() + "." + executable.getSimpleName();
    }

    public static void getSimpleNameType(@NotNull CtTypeReference<?> type, @NotNull StringBuilder name) {
        name.append(type.getSimpleName());
        if (!type.getActualTypeArguments().isEmpty()) {
            name.append('<');
            ListIterator iterator = type.getActualTypeArguments().listIterator();
            while (iterator.hasNext()) {
                RulesUtils.getSimpleNameType((CtTypeReference)iterator.next(), name);
                if (!iterator.hasNext()) continue;
                name.append(", ");
            }
            name.append('>');
        }
    }

    public static int calculateLevenshteinDistance(@NotNull String a, @NotNull String b) {
        int[] costs = IntStream.range(0, b.length() + 1).toArray();
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    public static boolean isModifyValue(CtExpression<?> expr, DataFlow df) {
        if (expr.getElements((Filter)new TypeFilter(CtUnaryOperator.class)).stream().anyMatch(arg -> arg.getKind() == UnaryOperatorKind.POSTINC || arg.getKind() == UnaryOperatorKind.PREINC || arg.getKind() == UnaryOperatorKind.POSTDEC || arg.getKind() == UnaryOperatorKind.PREDEC)) {
            return true;
        }
        List invocations = expr.getElements((Filter)new TypeFilter(CtAbstractInvocation.class));
        if (!invocations.isEmpty()) {
            List methodAnnotations = invocations.stream().map(df::getMethodAnnotation).filter(Objects::nonNull).collect(Collectors.toList());
            return methodAnnotations.isEmpty() || !methodAnnotations.stream().allMatch(arg -> arg.getAnnotation().getPure());
        }
        return false;
    }

    public static boolean endsWithFlowControl(CtStatement statement) {
        if (statement instanceof CtStatementList) {
            CtStatementList statementList = (CtStatementList)statement;
            return !statementList.getStatements().isEmpty() && RulesUtils.endsWithFlowControl(statementList.getLastStatement());
        }
        if (statement instanceof CtIf) {
            CtIf ifStatement = (CtIf)statement;
            return ifStatement.getElseStatement() != null && RulesUtils.endsWithFlowControl(ifStatement.getThenStatement()) && RulesUtils.endsWithFlowControl(ifStatement.getElseStatement());
        }
        return statement instanceof CtCFlowBreak;
    }

    public static boolean isAnnotated(@NotNull CtElement element, @NotNull String annotationType) {
        for (CtAnnotation annotation : element.getAnnotations()) {
            CtTypeReference type = annotation.getAnnotationType();
            if (type == null || !Objects.equals(type.getQualifiedName(), annotationType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull CtElement element, String ... annotationTypes) {
        if (annotationTypes.length == 0) {
            return false;
        }
        for (CtAnnotation annotation : element.getAnnotations()) {
            CtTypeReference type = annotation.getAnnotationType();
            if (type == null) continue;
            String qualifiedName = type.getQualifiedName();
            for (String wantedType : annotationTypes) {
                if (!Objects.equals(qualifiedName, wantedType)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T> T getParentBounded(@Nullable CtElement element, @Nullable CtElement bound, @NotNull Class<T> type) {
        while (element != null) {
            if (type.isInstance(element)) {
                return (T)element;
            }
            if (element == bound) break;
            element = element.getParent();
        }
        return null;
    }

    public static String getStringFromDataFlow(DataFlow df, CtElement el) {
        OptionalStringVirtualValue value;
        VirtualValue virtualValue = df.getValue(el).getVirtualValue();
        String arg = null;
        if (!virtualValue.isEmpty() && (value = virtualValue.getString()).isPresent()) {
            arg = value.get().singletonValue().toString();
        }
        return arg;
    }

    public static Object getStringFromExpression(CtExpression<?> expr) {
        if (expr instanceof CtLiteral) {
            return ((CtLiteral)expr).getValue();
        }
        return null;
    }

    @NotNull
    public static Optional<String> lookupStringValue(@NotNull DataFlow dataFlow, @NotNull CtExpression<?> expression) {
        return Optional.ofNullable(RulesUtils.getConstantExpression(dataFlow.getVariablesCache(), expression)).map(Object::toString).or(() -> Optional.ofNullable(RulesUtils.getStringFromDataFlow(dataFlow, (CtElement)expression)));
    }
}

