/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Utils;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.ConstraintSolver;
import com.pvsstudio.core.Context;
import com.pvsstudio.core.IndexArray;
import com.pvsstudio.core.JavaContext;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.Value;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.MethodAnnotation;
import com.pvsstudio.dataflow.TypesCache;
import com.pvsstudio.helpers.annotations.FieldContractAnnotation;
import com.pvsstudio.projects.Module;
import com.pvsstudio.projects.SourceCategory;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.rules.annotation.SecondaryRule;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtAbstractVisitor;
import spoon.support.reflect.declaration.CtAnonymousExecutableImpl;

public abstract class PvsStudioRule
extends CtAbstractVisitor {
    private boolean enabled = false;
    private String name;
    private PvsStudioAnalyzer analyzer;
    protected AnnotationService annotationService;
    private final List<LinkedRule<?>> linked = new ArrayList();
    private final List<MethodInformation<?>> methodInformation = new ArrayList();
    private final List<VariableInformation<?>> variableInformation = new ArrayList();
    private static final CtExecutable<?> NOT_VALID_METHOD = new CtAnonymousExecutableImpl();

    @NotNull
    protected Module getModule() {
        return Objects.requireNonNull(this.getAnalyzer().getModule());
    }

    protected String mergeSastId(String sastId, String secId) {
        Object result = null;
        if (StringUtils.isNotEmpty((CharSequence)sastId)) {
            result = sastId;
        }
        if (StringUtils.isNotEmpty((CharSequence)secId) && this.analyzer.getConfig().securityRelatedIssues.booleanValue()) {
            result = result != null ? (String)result + ", " + secId : secId;
        }
        return result;
    }

    public void init(@NotNull PvsStudioAnalyzer analyzer, AnnotationService annotationService) {
        this.analyzer = analyzer;
        this.name = ((Object)((Object)this)).getClass().getSimpleName();
        this.annotationService = annotationService;
        assert (!this.name.isEmpty());
        assert (this.name.charAt(0) == 'V');
        assert (StringUtils.isNumeric((CharSequence)this.name.substring(1)));
        this.enabled = Utils.isRuleEnabled(this.getAnalyzer().getConfig(), this.name);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public PvsStudioAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @NotNull
    public DataFlow getDataFlow() {
        return this.getAnalyzer().getDataFlow();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean isSuppressed(@NotNull String name) {
        return this.getAnalyzer().getSuppressed().contains(name);
    }

    public boolean isSuppressed(String ... names) {
        return Stream.of(names).anyMatch(this::isSuppressed);
    }

    public boolean isSuppressed(@NotNull CtElement element, String ... names) {
        for (String name : names) {
            List<CtComment> comments = this.getComments(element);
            for (CtComment c : comments) {
                if (!c.getContent().startsWith("-" + name) && !c.getContent().contains("//-" + name)) continue;
                return true;
            }
        }
        while (element != null) {
            if (RulesUtils.getSuppressed(element).anyMatch(s -> ArrayUtils.contains((Object[])names, (Object)s))) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public boolean isAnnotated(@NotNull String name) {
        return this.getAnalyzer().getAnnotations().stream().anyMatch(arg -> arg.getAnnotationType().getSimpleName().contains(name));
    }

    public boolean isAnnotated(String ... names) {
        return Stream.of(names).anyMatch(this::isAnnotated);
    }

    protected boolean shouldProduceWarnings() {
        return this.enabled && !this.isSuppressed("all");
    }

    public boolean shouldBeExecuted() {
        if (((Object)((Object)this)).getClass().isAnnotationPresent(SecondaryRule.class)) {
            return false;
        }
        return this.shouldProduceWarnings() || this.linked.stream().anyMatch(it -> ((PvsStudioRule)((Object)((Object)it.get()))).shouldProduceWarnings());
    }

    public boolean isEnabledInFirstIteration() {
        return false;
    }

    public boolean isEnabledInUnreachableCode() {
        return false;
    }

    public void clear() {
        this.methodInformation.forEach(MethodInformation::clear);
        this.variableInformation.forEach(VariableInformation::clear);
    }

    public boolean isInsideTestSources(@NotNull CtElement element) {
        return this.getModule().resolveSourceCategory(element) == SourceCategory.TEST;
    }

    public boolean isInsideTestClass(@NotNull CtElement element) {
        if (!this.isInsideTestSources(element)) {
            return false;
        }
        CtType type = (CtType)element.getParent(CtType.class);
        if (type == null) {
            return false;
        }
        return type.getMethods().stream().flatMap(it -> it.getAnnotations().stream()).map(it -> it.getType().getSimpleName()).anyMatch(Predicate.isEqual("Test"));
    }

    public boolean isInsideTestCase(@NotNull CtElement element) {
        if (!this.isInsideTestSources(element)) {
            return false;
        }
        CtExecutable executable = (CtExecutable)element.getParent(CtExecutable.class);
        if (executable == null) {
            return false;
        }
        return executable.getAnnotations().stream().map(annotation -> annotation.getType().getSimpleName()).anyMatch(Predicate.isEqual("Test"));
    }

    public boolean isInsideExampleFile(@NotNull CtExpression<?> expression) {
        SourcePosition position = expression.getPosition();
        if (!position.isValidPosition()) {
            return false;
        }
        File file = position.getFile();
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        return filename.toLowerCase().contains("example");
    }

    @NotNull
    public TypesCache getTypes() {
        return this.getDataFlow().getTypesCache();
    }

    @Nullable
    public CtVariable<?> getDeclaration(@Nullable CtVariableReference<?> var) {
        return this.getDataFlow().getVariablesCache().resolve(var);
    }

    @Nullable
    public CtType<?> getDeclaration(@Nullable CtTypeReference<?> var) {
        return this.getDataFlow().getTypesCache().resolve(var);
    }

    @Nullable
    public CtExecutable<?> getDeclaration(@Nullable CtExecutableReference<?> var) {
        try {
            return var == null ? null : var.getDeclaration();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public CtType<?> getType(@Nullable CtExpression<?> exp) {
        return this.getDataFlow().getTypesCache().resolve(RulesUtils.getType(exp));
    }

    public void enter(CtElement e) {
    }

    public void exit(CtElement e) {
    }

    @NotNull
    public Annotation getTypeAnnotation(@Nullable CtExpression<?> exp) {
        return this.getDataFlow().getSafeTypeAnnotation(exp);
    }

    @NotNull
    public Annotation getMethodAnnotation(@NotNull CtAbstractInvocation<?> invocation) {
        MethodAnnotation res = this.getDataFlow().getMethodAnnotation(invocation);
        return res == null ? this.getTypes().getEmptyAnnotation() : res.getAnnotation();
    }

    @NotNull
    public Annotation getMethodAnnotation(@NotNull CtExecutableReferenceExpression<?, ?> invocation) {
        MethodAnnotation res = this.getDataFlow().getMethodAnnotation(invocation);
        return res == null ? this.getTypes().getEmptyAnnotation() : res.getAnnotation();
    }

    @NotNull
    public Value getValue(@Nullable CtElement e) {
        return this.getDataFlow().getValue(e);
    }

    @NotNull
    public List<CtComment> getComments(@NotNull CtElement element) {
        SourcePosition position = element.getPosition();
        if (position.isValidPosition()) {
            return this.getModule().getComments(position.getFile(), position.getLine(), position.getEndLine());
        }
        return Collections.emptyList();
    }

    public boolean isConstantExpression(@Nullable CtExpression<?> expression) {
        return RulesUtils.isConstantExpression(this.getDataFlow().getVariablesCache(), expression);
    }

    @Nullable
    CtExecutable<?> getCurrentMethod() {
        return this.getDataFlow().getCurrentMethod();
    }

    @Nullable
    protected com.pvsstudio.dataflow.java.DataFlow getJavaDataFlow() {
        return this.getAnalyzer().getJavaDataFlow();
    }

    protected boolean hasAnnotation(@NotNull CtElement element, @NotNull com.pvsstudio.annotation.Annotation annotation) {
        return this.annotationService.getAnnotations(element).contains(annotation);
    }

    protected boolean hasMethodFieldAnnotation(@NotNull CtInvocation<?> inv, @NotNull CtFieldReference<?> fieldReference, FlagAnnotation flagAnnotation) {
        CtExecutable executable = inv.getExecutable().getDeclaration();
        if (executable == null) {
            return false;
        }
        Annotations annotations = this.annotationService.getAnnotations((CtElement)executable);
        return annotations.getCustomAnnotations().stream().filter(FieldContractAnnotation.class::isInstance).map(FieldContractAnnotation.class::cast).filter(ann -> ann.getAnnotation().equals((Object)flagAnnotation)).anyMatch(ann -> ann.getField().equals((Object)fieldReference));
    }

    @NotNull
    ConstraintSolver constraints() {
        return this.getDataFlow().constraints();
    }

    public void visitCtLoop(CtLoop loop) {
    }

    public final <T> void visitCtMethod(CtMethod<T> m) {
    }

    public void visitCtFor(CtFor forLoop) {
        this.visitCtLoop((CtLoop)forLoop);
    }

    public void visitCtWhile(CtWhile whileLoop) {
        this.visitCtLoop((CtLoop)whileLoop);
    }

    public void visitCtForEach(CtForEach foreach) {
        this.visitCtLoop((CtLoop)foreach);
    }

    public void visitCtDo(CtDo doLoop) {
        this.visitCtLoop((CtLoop)doLoop);
    }

    public void addInterproceduralPositions(@NotNull WarningAdapter warning, IndexArray array) {
        if (array == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            CtElement e = this.getDataFlow().getExpressionByIndex(array.get(i));
            if (e == null) continue;
            warning.addSourcePosition(e, this.getModule());
        }
    }

    public void visitContractFailure(@NotNull CtAbstractInvocation<?> invocation, @NotNull Context context, @NotNull Annotation annotation, @NotNull Constraint constraint, @NotNull Stream<Map.Entry<Integer, CtElement>> usedArguments, @NotNull Result result) {
    }

    public void scanContractFailures(@NotNull CtAbstractInvocation<?> invocation) {
        MethodAnnotation annotation = this.getDataFlow().getMethodAnnotation(invocation);
        if (annotation == null) {
            return;
        }
        JavaContext context = annotation.getContext();
        if (context == null) {
            return;
        }
        Result res = context.getContractResult();
        if (res == Result.Ok) {
            return;
        }
        Optional<Constraint> contractType = context.getContractType();
        if (!contractType.isPresent()) {
            return;
        }
        Stream<Map.Entry<Integer, CtElement>> usedArguments = IntStream.range(0, invocation.getArguments().size() + 1).filter(i -> context.getArgument(i).getUsed()).mapToObj(i -> Pair.of((Object)i, (Object)this.getDataFlow().getExpressionByIndex(context.getArgument(i).getTree())));
        this.visitContractFailure(invocation, context, annotation.getAnnotation(), contractType.get(), usedArguments, res);
    }

    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        this.scanContractFailures((CtAbstractInvocation<?>)inv);
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> inv) {
        this.scanContractFailures((CtAbstractInvocation<?>)inv);
    }

    protected class LinkedRule<T extends PvsStudioRule> {
        private final Class<T> clazz;
        private T result;

        LinkedRule(Class<T> clazz) {
            this.clazz = clazz;
            PvsStudioRule.this.linked.add(this);
        }

        @NotNull
        T get() {
            if (this.result == null) {
                this.result = (PvsStudioRule)((Object)PvsStudioRule.this.getAnalyzer().getRule(this.clazz));
            }
            return this.result;
        }
    }

    protected class MethodInformation<T> {
        private final Map<CtExecutable<?>, T> data = new HashMap();
        private final Supplier<T> supplier;

        MethodInformation() {
            PvsStudioRule.this.methodInformation.add(this);
            this.supplier = null;
        }

        MethodInformation(Supplier<T> supplier) {
            PvsStudioRule.this.methodInformation.add(this);
            this.supplier = supplier;
        }

        T get(@NotNull CtExecutable<?> method) {
            if (this.supplier != null) {
                return (T)this.data.computeIfAbsent(method, (? super K m) -> this.supplier.get());
            }
            return this.data.get(method);
        }

        private CtExecutable<?> getNotNullCurrentMethod() {
            return PvsStudioRule.this.getCurrentMethod() == null ? NOT_VALID_METHOD : PvsStudioRule.this.getCurrentMethod();
        }

        T current() {
            return this.get(this.getNotNullCurrentMethod());
        }

        T computeIfAbsent(@NotNull CtExecutable<?> method, @NotNull Function<CtExecutable<?>, T> fn) {
            return this.data.computeIfAbsent(method, fn);
        }

        T computeIfAbsent(@NotNull Function<CtExecutable<?>, T> fn) {
            return this.data.computeIfAbsent(PvsStudioRule.this.getCurrentMethod(), fn);
        }

        public boolean add(@Nullable CtExecutable<?> method) {
            CtExecutable<?> notNullMethod = method == null ? NOT_VALID_METHOD : method;
            boolean res = !this.data.containsKey(notNullMethod);
            this.get(notNullMethod);
            return res;
        }

        void clear() {
            this.data.clear();
        }
    }

    protected class VariableInformation<T> {
        private final Map<CtVariable<?>, T> data = new HashMap();
        private final Supplier<T> supplier;

        VariableInformation() {
            PvsStudioRule.this.variableInformation.add(this);
            this.supplier = null;
        }

        VariableInformation(Supplier<T> supplier) {
            PvsStudioRule.this.variableInformation.add(this);
            this.supplier = supplier;
        }

        T get(@NotNull CtVariable<?> variable) {
            if (this.supplier != null) {
                return (T)this.data.computeIfAbsent(variable, m -> this.supplier.get());
            }
            return this.data.get(variable);
        }

        public boolean add(@NotNull CtVariable<?> variable) {
            boolean res = !this.data.containsKey(variable);
            this.get(variable);
            return res;
        }

        void clear() {
            this.data.clear();
        }
    }

    protected class Pattern {
        private static final int MAX_MESSAGE_LEN = 150;
        private static final int MAX_MESSAGE_LENGTH_DIFFERENCE = 50;
        private final String message;
        private final String extendedMessage;
        private final WarningLevel level;
        private final Integer cwe;
        private final String sastId;
        private final String secId;

        private Pattern(String message, String extendedMessage, WarningLevel level, Integer cwe, String sastId, String secId) {
            this.message = message;
            this.extendedMessage = extendedMessage;
            this.level = level;
            this.cwe = cwe;
            this.sastId = sastId;
            this.secId = secId;
        }

        @NotNull
        WarningAdapter add(@NotNull CtElement pos, Object ... messageObjects) {
            String tempExtendedMessage;
            WarningPosition position = RulesUtils.getPosition(pos, PvsStudioRule.this.getModule());
            if (position == WarningPosition.INVALID_POSITION || !PvsStudioRule.this.shouldProduceWarnings()) {
                return WarningAdapter.INVALID_WARNING;
            }
            for (int i = 0; i < messageObjects.length; ++i) {
                if (!(messageObjects[i] instanceof CtCodeElement)) continue;
                messageObjects[i] = RulesUtils.astToString(PvsStudioRule.this.getAnalyzer().print((CtCodeElement)messageObjects[i]));
            }
            String tempDefaultMessage = String.format(this.message, messageObjects);
            String message = this.extendedMessage != null ? ((tempExtendedMessage = String.format(this.extendedMessage, messageObjects)).length() <= 150 ? tempExtendedMessage : (tempExtendedMessage.length() - tempDefaultMessage.length() < 50 ? tempExtendedMessage : tempDefaultMessage)) : tempDefaultMessage;
            message = message.replace('\n', ' ').replace("\r", "");
            Warning warning = new Warning(PvsStudioRule.this.getName(), message, this.level, position);
            warning.cwe = this.cwe == null ? 0 : this.cwe;
            warning.sastId = PvsStudioRule.this.mergeSastId(this.sastId, this.secId);
            warning.falseAlarm = PvsStudioRule.this.isSuppressed(pos, PvsStudioRule.this.name);
            if (!warning.falseAlarm && position.file != null) {
                for (CtComment comment : PvsStudioRule.this.getModule().getComments(new File(position.file))) {
                    SourcePosition commentPosition = comment.getPosition();
                    if (commentPosition.getLine() == position.line && comment.getContent().contains("-" + warning.code)) {
                        warning.falseAlarm = true;
                        break;
                    }
                    if (commentPosition.getLine() != position.line - 1 || !RulesUtils.isNoinspectionComment(comment.getContent(), warning.code)) continue;
                    warning.falseAlarm = true;
                    break;
                }
            }
            PvsStudioRule.this.getAnalyzer().getWarnings().add(warning);
            return new WarningAdapter(warning);
        }

        @NotNull
        public WarningLevel getLevel() {
            return this.level;
        }
    }

    protected class PatternBuilder {
        private String message;
        private String extendedMessage;
        private WarningLevel level = WarningLevel.LEVEL_1;
        private Integer cwe;
        private String sastId;
        private String secId;

        protected PatternBuilder() {
        }

        @NotNull
        public PatternBuilder setMessage(@NotNull String message) {
            assert (!message.isEmpty());
            assert (message.endsWith("."));
            this.message = message;
            return this;
        }

        @NotNull
        public PatternBuilder setExtendedMessage(@NotNull String extendedMessage) {
            assert (!extendedMessage.isEmpty());
            assert (extendedMessage.endsWith("."));
            this.extendedMessage = extendedMessage;
            return this;
        }

        @NotNull
        public PatternBuilder setLevel(@NotNull WarningLevel level) {
            this.level = level;
            return this;
        }

        @NotNull
        public PatternBuilder setCwe(@Nullable Integer cwe) {
            this.cwe = cwe;
            return this;
        }

        @NotNull
        public PatternBuilder setSastId(@Nullable String sastId) {
            this.sastId = sastId;
            return this;
        }

        public PatternBuilder setSecId(@Nullable String secId) {
            this.secId = secId;
            return this;
        }

        @NotNull
        public Pattern build() {
            if (this.message == null) {
                throw new IllegalStateException("No message specified");
            }
            return new Pattern(this.message, this.extendedMessage, this.level, this.cwe, this.sastId, this.secId);
        }
    }
}

