/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.projects.Module;
import com.pvsstudio.warnings.Warning;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.compiler.Environment;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.DefaultTokenWriter;
import spoon.reflect.visitor.PrinterHelper;
import spoon.reflect.visitor.TokenWriter;

public class PrettyPrinter
extends DefaultJavaPrettyPrinter {
    private final TokenWriter printer;
    private final List<CtExpression<?>> parentheses = new ArrayList();
    private final List<CtType<?>> types = new ArrayList();
    private final Module module;

    public PrettyPrinter(@NotNull Environment e, Module module) {
        super(e);
        this.module = module;
        this.printer = new DefaultTokenWriter(new PrinterHelper(e));
        this.setLineSeparator(" ");
        this.setPrinterTokenWriter(this.printer);
    }

    public void enterType(CtType<?> type) {
        this.types.add(type);
    }

    public void exitType() {
        this.types.remove(this.types.size() - 1);
    }

    public String print(@NotNull CtElement e) {
        this.printer.reset();
        SourcePosition position = e.getPosition();
        if (position != null) {
            File file = position.getFile();
            int line = position.getLine();
            int endLine = position.getEndLine();
            int column = position.getColumn();
            int endColumn = position.getEndColumn();
            if (file != null && line > 0 && endLine > 0 && column > 0 && endColumn > 0) {
                StringBuilder prettyBuilder = new StringBuilder();
                boolean failed = false;
                try {
                    for (int i = line; i <= endLine; ++i) {
                        Optional<String> lineStrOpt = this.module.getLine(file, i);
                        if (lineStrOpt.isEmpty()) {
                            failed = true;
                            break;
                        }
                        String currentLine = lineStrOpt.get();
                        if (i == line && i == endLine) {
                            currentLine = currentLine.substring(column - 1, endColumn);
                        } else if (i == line) {
                            currentLine = currentLine.substring(column - 1);
                        } else if (i == endLine) {
                            currentLine = currentLine.substring(0, endColumn);
                        }
                        if (i != line) {
                            prettyBuilder.append(' ');
                        }
                        prettyBuilder.append(Warning.removeTrailingComments(currentLine).trim());
                    }
                }
                catch (Exception ex) {
                    failed = true;
                }
                if (!failed) {
                    List casts;
                    Object pretty = Warning.removeInlineComments(prettyBuilder);
                    if (e instanceof CtExpression && !(casts = ((CtExpression)e).getTypeCasts()).isEmpty()) {
                        String castsStr = casts.stream().map(cast -> "(" + cast.getSimpleName() + ") ").collect(Collectors.joining());
                        pretty = castsStr + (String)pretty;
                    }
                    this.printer.writeIdentifier((String)pretty);
                } else {
                    this.scan(e);
                }
            } else {
                this.scan(e);
            }
        } else {
            this.scan(e);
        }
        return this.getResult();
    }

    protected void enterCtExpression(CtExpression<?> e) {
        if (this.addParentheses(e)) {
            this.parentheses.add(e);
            this.printer.writeSeparator("(");
        }
        if (!e.getTypeCasts().isEmpty()) {
            for (CtTypeReference r : e.getTypeCasts()) {
                this.printer.writeSeparator("(");
                this.scan((CtElement)r);
                this.printer.writeSeparator(")");
            }
            this.printer.writeSpace();
            if (!(e instanceof CtVariableAccess)) {
                this.printer.writeSeparator("(");
                this.parentheses.add(e);
            }
        }
    }

    private int operatorPrecedence(BinaryOperatorKind kind) {
        switch (kind) {
            case MUL: 
            case DIV: 
            case MOD: {
                return 12;
            }
            case PLUS: 
            case MINUS: {
                return 11;
            }
            case SL: 
            case SR: 
            case USR: {
                return 10;
            }
            case LE: 
            case LT: 
            case GE: 
            case GT: 
            case INSTANCEOF: {
                return 9;
            }
            case EQ: 
            case NE: {
                return 8;
            }
            case BITAND: {
                return 7;
            }
            case BITXOR: {
                return 6;
            }
            case BITOR: {
                return 5;
            }
            case AND: {
                return 4;
            }
            case OR: {
                return 3;
            }
        }
        return -1;
    }

    private boolean addParentheses(CtBinaryOperator<?> op, CtBinaryOperator<?> parent) {
        int operatorPrecedence = this.operatorPrecedence(op.getKind());
        int parentPrecedence = this.operatorPrecedence(parent.getKind());
        return operatorPrecedence != -1 && parentPrecedence != -1 && (operatorPrecedence < parentPrecedence || operatorPrecedence == parentPrecedence && parent.getLeftHandOperand() != op);
    }

    private boolean addParentheses(CtExpression<?> e) {
        if (!e.getTypeCasts().isEmpty()) {
            return true;
        }
        try {
            CtElement parent = e.getParent();
            if (parent instanceof CtBinaryOperator) {
                return e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtBinaryOperator && this.addParentheses((CtBinaryOperator)e, (CtBinaryOperator)parent);
            }
            if (parent instanceof CtUnaryOperator) {
                return e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator || e instanceof CtBinaryOperator;
            }
            if (parent instanceof CtTargetedExpression) {
                return e instanceof CtBinaryOperator || e instanceof CtAssignment || e instanceof CtConditional || e instanceof CtUnaryOperator;
            }
        }
        catch (ParentNotInitializedException parentNotInitializedException) {
            // empty catch block
        }
        return false;
    }

    private void visitField(CtFieldAccess<?> f) {
        this.enterCtExpression((CtExpression<?>)f);
        CtExpression target = f.getTarget();
        CtFieldReference variable = f.getVariable();
        if (!(variable.isStatic() && !this.types.isEmpty() && target instanceof CtTypeAccess && ((CtTypeAccess)target).getAccessedType().getQualifiedName().equals(this.types.get(this.types.size() - 1).getQualifiedName()) || target == null || target.isImplicit())) {
            this.scan((CtElement)target);
            this.printer.writeSeparator(".");
        }
        this.printer.writeIdentifier(variable.getSimpleName());
        this.exitCtExpression((CtExpression<?>)f);
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> f) {
        this.visitField((CtFieldAccess<?>)f);
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> f) {
        this.visitField((CtFieldAccess<?>)f);
    }

    protected void exitCtExpression(CtExpression<?> e) {
        while (!this.parentheses.isEmpty() && e == this.parentheses.get(this.parentheses.size() - 1)) {
            this.parentheses.remove(this.parentheses.size() - 1);
            this.printer.writeSeparator(")");
        }
    }
}

