/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.projects;

import com.pvsstudio.projects.SourceCategory;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;

public interface SourceCategoryResolver {
    @NotNull
    public SourceCategory resolve(@NotNull CtElement var1);

    public static class Main
    implements SourceCategoryResolver {
        private final Set<String> testSources;

        public Main(Set<String> testSources) {
            this.testSources = testSources;
        }

        @Override
        @NotNull
        public SourceCategory resolve(@NotNull CtElement e) {
            String path;
            File file = e.getPosition().getFile();
            if (file != null && this.testSources.contains(path = file.getAbsolutePath())) {
                return SourceCategory.TEST;
            }
            return SourceCategory.MAIN;
        }
    }

    public static class Heuristic
    implements SourceCategoryResolver {
        private boolean isTestClass(CtType<?> type) {
            for (CtType currentType = type; currentType != null; currentType = currentType.getDeclaringType()) {
                if (currentType.getSimpleName().endsWith("Test")) {
                    return true;
                }
                if (currentType.getSuperclass() != null && Objects.equals(currentType.getSuperclass().getQualifiedName(), "junit.framework.TestCase")) {
                    return true;
                }
                boolean hasTestMarkers = type.getMethods().stream().flatMap(it -> it.getAnnotations().stream()).anyMatch(it -> it.getType() != null && (Objects.equals(it.getType().getSimpleName(), "Test") || it.getType().getQualifiedName().startsWith("junit.")));
                if (!hasTestMarkers) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public SourceCategory resolve(@NotNull CtElement e) {
            CtType declaringType = (CtType)e.getParent(CtType.class);
            if (declaringType != null && this.isTestClass(declaringType)) {
                return SourceCategory.TEST;
            }
            return SourceCategory.MAIN;
        }
    }
}

