/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.projects;

import com.google.common.io.Files;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JdkRuntimeUtils;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import com.pvsstudio.dataflow.DataFlowLauncher;
import com.pvsstudio.dataflow.graph.GraphModel;
import com.pvsstudio.projects.IncrementalLauncher;
import com.pvsstudio.projects.Project;
import com.pvsstudio.projects.SourceCategory;
import com.pvsstudio.projects.SourceCategoryResolver;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.util.exclude.ExcludeResolver;
import com.pvsstudio.util.path.PathResolver;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class Module {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final Set<File> sourceFiles;
    @NotNull
    private final Set<String> classpathAbsoluteFilesPaths;
    @NotNull
    private final File modulePvsStudioDirectory;
    @NotNull
    private final Set<File> sourcesForAnalysis = new HashSet<File>();
    private IncrementalLauncher launcher;
    private final SourceCategoryResolver sourceCategoryResolver;
    private CtModel model;
    private GraphModel graphModel;
    private final Map<File, List<CtComment>> commentsMap = new HashMap<File, List<CtComment>>();
    private final Map<File, List<String>> fileLines = new HashMap<File, List<String>>();
    private boolean forceRebuild;
    private boolean disableCache;
    private boolean ignoreErrors = true;
    private static final Logger logger = LoggerFactory.getLogger(Module.class);

    public Module(@NotNull Project project, @NotNull String name, @Nullable Set<String> sourceFiles, @Nullable Set<String> testSourceFiles, @Nullable Set<String> classpath, @Nullable Set<String> generatedSources) {
        AnalyzerConfig config = project.getConfig();
        this.project = project;
        this.name = name;
        this.sourceFiles = Utils.collectAllJavaFiles(sourceFiles);
        if (testSourceFiles == null) {
            this.sourceCategoryResolver = new SourceCategoryResolver.Heuristic();
        } else {
            Set<String> testSourcesAbsolutePaths = Utils.collectAllJavaFiles(testSourceFiles).stream().map(File::getAbsolutePath).collect(Collectors.toSet());
            this.sourceCategoryResolver = new SourceCategoryResolver.Main(testSourcesAbsolutePaths);
        }
        this.classpathAbsoluteFilesPaths = classpath == null ? Collections.emptySet() : Utils.collectAllClasspathFiles(classpath).stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        this.forceRebuild = config.forceRebuild;
        this.disableCache = config.disableCache;
        this.modulePvsStudioDirectory = new File(Utils.absolutePath(config.projectPath, ".PVS-Studio/models", this.name));
        if (!this.modulePvsStudioDirectory.exists() && !this.modulePvsStudioDirectory.mkdirs()) {
            throw new PvsStudioException("unable to create .PVS-Studio/models directory at " + String.valueOf(this.modulePvsStudioDirectory));
        }
        File analysisInfoFile = new File(this.modulePvsStudioDirectory, "analysis-info");
        AnalysisInfo oldAnalysisInfo = null;
        HashSet<File> modifiedSources = new HashSet<File>();
        if (analysisInfoFile.exists()) {
            try {
                oldAnalysisInfo = (AnalysisInfo)RulesUtils.loadObject(analysisInfoFile);
                Sets.SetView addedSources = Sets.difference(this.sourceFiles, oldAnalysisInfo.inputSources);
                Sets.SetView sameSources = Sets.union(oldAnalysisInfo.inputSources, this.sourceFiles);
                modifiedSources.addAll((Collection<File>)addedSources);
                for (File f : sameSources) {
                    if (f.lastModified() < oldAnalysisInfo.lastAnalysisTime) continue;
                    modifiedSources.add(f);
                }
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                logger.warn("Different analyzer versions: ", (Throwable)e);
            }
        }
        Set generatedFiles = generatedSources == null || config.includeGenerated != false ? Collections.emptySet() : (Collection)Utils.collectAllJavaFiles(generatedSources).stream().map(File::getPath).collect(Collectors.toSet());
        for (File file : this.sourceFiles) {
            boolean excluded;
            if (config.incremental.booleanValue() && oldAnalysisInfo != null && !modifiedSources.contains(file) || (excluded = this.isExcluded(file) || generatedFiles.contains(file.getAbsolutePath())) || !this.project.getUniqueFiles().add(file)) continue;
            this.sourcesForAnalysis.add(file);
        }
        AnalysisInfo analysisInfo = new AnalysisInfo();
        analysisInfo.lastAnalysisTime = System.currentTimeMillis();
        analysisInfo.inputSources = this.sourceFiles;
        RulesUtils.saveObject(analysisInfo, analysisInfoFile);
    }

    public void setDisableCache(boolean value) {
        this.disableCache = value;
    }

    public void setIgnoreErrors(boolean value) {
        this.ignoreErrors = value;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Set<File> getSourceFilesForAnalysis() {
        return Collections.unmodifiableSet(this.sourcesForAnalysis);
    }

    @NotNull
    public SourceCategory resolveSourceCategory(@NotNull CtElement e) {
        return this.sourceCategoryResolver.resolve(e);
    }

    @NotNull
    public List<String> getLinesInFile(@NotNull File file) {
        List res = this.fileLines.get(file);
        if (res != null) {
            return res;
        }
        try {
            res = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            this.fileLines.put(file, res);
            return res;
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean isExcluded(@NotNull File file) {
        AnalyzerConfig config = this.getProject().getConfig();
        PathResolver pathResolver = PathResolver.forConfig(config);
        ExcludeResolver excludeResolver = new ExcludeResolver(config);
        String path = pathResolver.resolveAbsolutePath(file.toString());
        if (excludeResolver.isExcludedByAutoGeneratedComment(this.getLinesInFile(file))) {
            this.fileLines.remove(file);
            return true;
        }
        return excludeResolver.isExcludedByAnalyzeOnly(path) || excludeResolver.isExcludedByExclude(path, true);
    }

    public boolean isExcluded(@NotNull CtType<?> ctTopType) {
        return !this.getSourceFilesForAnalysis().contains(ctTopType.getPosition().getFile());
    }

    @NotNull
    public List<CtComment> getComments(@NotNull File file) {
        return Collections.unmodifiableList(this.commentsMap.getOrDefault(file, Collections.emptyList()));
    }

    @NotNull
    public List<CtComment> getComments(@NotNull File file, int fromLine, int toLine) {
        ArrayList<CtComment> commentsInRange = new ArrayList<CtComment>();
        List<CtComment> allComments = this.commentsMap.get(file);
        if (allComments != null) {
            for (CtComment comment : allComments) {
                SourcePosition pos = comment.getPosition();
                if ((pos.getLine() < fromLine || pos.getLine() > toLine) && (pos.getEndLine() < fromLine || pos.getEndLine() > toLine)) continue;
                commentsInRange.add(comment);
            }
        }
        return commentsInRange;
    }

    @NotNull
    public IncrementalLauncher getLauncher() {
        if (this.launcher == null) {
            this.build();
        }
        return this.launcher;
    }

    @NotNull
    public CtModel getModel() {
        if (this.model == null) {
            this.build();
        }
        return this.model;
    }

    private IncrementalLauncher configureNewLauncherForBuild() {
        IncrementalLauncher launcher = new IncrementalLauncher(this.sourceFiles, this.classpathAbsoluteFilesPaths, this.modulePvsStudioDirectory, this.forceRebuild, this.disableCache);
        launcher.getEnvironment().setNoClasspath(this.ignoreErrors);
        launcher.getEnvironment().setCommentEnabled(true);
        launcher.getEnvironment().setLevel(this.getProject().getConfig().logging);
        int complianceLevel = JdkRuntimeUtils.getNewComplianceLevel();
        logger.info("Module name: {} Compliance level: {}", (Object)this.getName(), (Object)complianceLevel);
        launcher.getEnvironment().setComplianceLevel(complianceLevel);
        launcher.getEnvironment().setEncodingProvider((spoonFile, fileBytes) -> {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(fileBytes, 0, fileBytes.length);
            detector.dataEnd();
            String encoding = detector.getDetectedCharset();
            detector.reset();
            return Charset.forName(encoding != null ? encoding : "UTF-8");
        });
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : this.classpathAbsoluteFilesPaths) {
                URL url = Path.of(path, new String[0]).toUri().toURL();
                urls.add(url);
            }
            URLClassLoader inputClassLoader = new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader().getParent());
            launcher.getEnvironment().setInputClassLoader((ClassLoader)inputClassLoader);
        }
        catch (MalformedURLException e) {
            logger.warn("An error occurred when creating a URLClassLoader:", (Throwable)e);
        }
        return launcher;
    }

    public void build() {
        boolean isFirstException = true;
        while (true) {
            this.launcher = this.configureNewLauncherForBuild();
            try {
                this.model = this.launcher.buildModel();
            }
            catch (Throwable ex) {
                if (isFirstException && !this.launcher.buildingFromScratch()) {
                    isFirstException = false;
                    this.forceRebuild = true;
                    continue;
                }
                logger.error("Model build failed: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
            break;
        }
        if (this.launcher.changesPresent() && !this.disableCache) {
            this.launcher.saveCache();
        }
        this.removeAndLoadAllComments();
        logger.info("Model build success.");
    }

    public void clear() {
        this.model = null;
        this.commentsMap.clear();
        this.fileLines.clear();
    }

    @NotNull
    public Optional<String> getLine(@Nullable File file, int line) {
        List<String> allLines = this.fileLines.get(file);
        if (allLines == null || line <= 0 || line > allLines.size()) {
            return Optional.empty();
        }
        return Optional.of(allLines.get(line - 1));
    }

    @NotNull
    public List<String> getLines(@NotNull File file, int fromLine, int toLine) {
        List<String> allLines = this.fileLines.get(file);
        if (allLines == null || fromLine <= 0 || fromLine > allLines.size() || toLine <= 0 || fromLine > toLine) {
            return Collections.emptyList();
        }
        return allLines.subList(fromLine - 1, Math.min(toLine, allLines.size()));
    }

    private void removeAndLoadAllComments() {
        TypeFilter commentFilter = new TypeFilter(CtComment.class);
        List comments = this.model.getElements((Filter)commentFilter);
        for (CtComment comment : comments) {
            File file = comment.getPosition().getFile();
            this.commentsMap.computeIfAbsent(file, f -> new ArrayList()).add(comment);
            comment.delete();
        }
        List classes = this.model.getAllTypes().stream().filter(CtType::isTopLevel).collect(Collectors.toList());
        for (CtType clazz : classes) {
            if (!clazz.getPosition().isValidPosition()) continue;
            comments = clazz.getPosition().getCompilationUnit().getElements((Filter)commentFilter);
            for (CtComment comment : comments) {
                File file = comment.getPosition().getFile();
                comment.setCommentType(CtComment.CommentType.FILE);
                this.commentsMap.computeIfAbsent(file, f -> new ArrayList()).add(comment);
                comment.delete();
            }
        }
    }

    public void buildGraphModel() {
        this.graphModel = new DataFlowLauncher().buildGraphModel(this.model);
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    private static class AnalysisInfo
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public long lastAnalysisTime;
        public Set<File> inputSources;

        private AnalysisInfo() {
        }
    }
}

