/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.projects;

import com.google.gson.GsonBuilder;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JsonModule;
import com.pvsstudio.JsonProject;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import com.pvsstudio.projects.Module;
import com.pvsstudio.projects.Project;
import com.pvsstudio.projects.ProjectEvaluator;
import com.pvsstudio.runner.AnalyzerProgress;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEvaluator
implements ProjectEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(JsonEvaluator.class);

    @Override
    @NotNull
    public Project evaluate(@NotNull AnalyzerConfig config, @NotNull AnalyzerProgress progress) {
        JsonProject jsonProject;
        Project project = new Project("java", config);
        String jsonPath = Utils.absolutePath(config.projectPath, JsonProject.FILENAME);
        try {
            jsonProject = (JsonProject)new GsonBuilder().setLenient().create().fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonPath), StandardCharsets.UTF_8)), JsonProject.class);
        }
        catch (Exception e) {
            throw new PvsStudioException("unable to parse json", e);
        }
        for (JsonModule module : jsonProject.modules) {
            progress.ensureNotCancelled();
            project.addModule(new Module(project, module.name, module.sources, module.testSources, module.classpath, module.generatedSources));
            logger.info("Module: {}", (Object)module.name);
            logger.info("Sources:");
            module.sources.forEach(arg_0 -> ((Logger)logger).info(arg_0));
            logger.info("Classpath:");
            module.classpath.forEach(arg_0 -> ((Logger)logger).info(arg_0));
        }
        return project;
    }
}

