/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.projects;

import com.google.common.collect.Sets;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.rules.RulesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.Launcher;
import spoon.SpoonModelBuilder;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.support.SerializationModelStreamer;

public class IncrementalLauncher
extends Launcher {
    private final Set<File> inputSources;
    private final File incrementalCacheDirectory;
    private final File modelFile;
    private final File cacheInfoFile;
    private final File classFilesDir;
    private final boolean changesPresent;
    private final boolean buildingFromScratch;
    private final Set<String> sourceClasspath;
    private Set<File> removedSources = new HashSet<File>();
    private Set<File> addedSources = new HashSet<File>();
    private Set<File> commonSources = new HashSet<File>();
    private CacheInfo cacheInfo = null;
    private static final Logger logger = LoggerFactory.getLogger(IncrementalLauncher.class);

    public boolean changesPresent() {
        return this.changesPresent;
    }

    public boolean buildingFromScratch() {
        return this.buildingFromScratch;
    }

    private void saveFactory(Factory factory, File file) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            new SerializationModelStreamer().save(factory, (OutputStream)stream);
        }
        catch (Exception e) {
            throw new PvsStudioException("unable to save factory", e);
        }
    }

    private Factory loadFactory(File file) {
        Factory factory;
        FileInputStream stream = new FileInputStream(file);
        try {
            factory = new SerializationModelStreamer().load((InputStream)stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new PvsStudioException("unable to load factory from cache directory", e);
            }
        }
        ((InputStream)stream).close();
        return factory;
    }

    public IncrementalLauncher(Set<File> inputSources, Set<String> sourceClasspath, File cacheDirectory, boolean forceRebuild, boolean disableCache) {
        if (cacheDirectory == null) {
            throw new PvsStudioException("unable to create incremental launcher with null cache directory");
        }
        this.inputSources = inputSources;
        this.sourceClasspath = sourceClasspath == null ? new HashSet<String>() : new HashSet<String>(sourceClasspath);
        this.incrementalCacheDirectory = cacheDirectory;
        this.modelFile = new File(cacheDirectory, "model");
        this.cacheInfoFile = new File(cacheDirectory, "cache-info");
        this.classFilesDir = new File(cacheDirectory, "class-files");
        if (!(this.incrementalCacheDirectory.exists() && this.modelFile.exists() && this.cacheInfoFile.exists() && this.classFilesDir.exists())) {
            forceRebuild = true;
        } else {
            try {
                this.cacheInfo = (CacheInfo)RulesUtils.loadObject(this.cacheInfoFile);
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                logger.info("Different cache versions.");
                forceRebuild = true;
            }
            catch (PvsStudioException e) {
                logger.info("Unable to load cache.");
                forceRebuild = true;
            }
        }
        if (!(disableCache || this.incrementalCacheDirectory.exists() || this.incrementalCacheDirectory.mkdirs())) {
            throw new PvsStudioException("unable to create cache directory");
        }
        if (!(disableCache || this.classFilesDir.exists() || this.classFilesDir.mkdirs())) {
            throw new PvsStudioException("unable to create class files directory");
        }
        boolean outdatedModel = false;
        if (!forceRebuild && !disableCache) {
            try {
                logger.info("Load model from cache...");
                this.factory = this.loadFactory(this.modelFile);
                this.factory.getModel().setBuildModelIsFinished(false);
            }
            catch (Exception e) {
                logger.warn("Failed to load cached model");
                forceRebuild = true;
            }
            if (!forceRebuild) {
                try {
                    File typeFile;
                    logger.info("Build model incrementally...");
                    logger.info("Current time: {}", (Object)System.currentTimeMillis());
                    logger.info("Last build time: {}", (Object)this.cacheInfo.lastBuildTime);
                    logger.info("Keyset size: {}", (Object)this.cacheInfo.inputSourcesMap.keySet().size());
                    logger.info("Input sources size: {}", (Object)this.inputSources.size());
                    this.removedSources = Sets.difference(this.cacheInfo.inputSourcesMap.keySet(), this.inputSources);
                    this.addedSources = Sets.difference(this.inputSources, this.cacheInfo.inputSourcesMap.keySet());
                    this.commonSources = Sets.union(this.cacheInfo.inputSourcesMap.keySet(), this.inputSources);
                    logger.info("Removed sources size: {}", (Object)this.removedSources.size());
                    logger.info("Added sources size: {}", (Object)this.addedSources.size());
                    logger.info("Common sources size: {}", (Object)this.commonSources.size());
                    HashSet<File> incrementalSources = new HashSet<File>(this.addedSources);
                    for (File e : this.commonSources) {
                        if (e.lastModified() < this.cacheInfo.lastBuildTime) continue;
                        incrementalSources.add(e);
                    }
                    logger.info("Incremental sources size: {}", (Object)incrementalSources.size());
                    List oldTypes = this.factory.Type().getAll();
                    logger.info("Old types size: {}", (Object)oldTypes.size());
                    HashSet<CtType> changedTypes = new HashSet<CtType>();
                    for (CtType type : oldTypes) {
                        typeFile = type.getPosition().getFile();
                        if (!incrementalSources.contains(typeFile)) continue;
                        changedTypes.add(type);
                    }
                    logger.info("Changed types size: {}", (Object)changedTypes.size());
                    logger.info("Enter types loop");
                    block12: for (CtType type : oldTypes) {
                        typeFile = type.getPosition().getFile();
                        if (this.removedSources.contains(typeFile)) {
                            type.delete();
                            continue;
                        }
                        Set referencedTypes = type.getReferencedTypes();
                        for (CtType changedType : changedTypes) {
                            if (!referencedTypes.contains(changedType.getReference())) continue;
                            incrementalSources.add(typeFile);
                            type.delete();
                            continue block12;
                        }
                    }
                    logger.info("Exit types loop");
                    try {
                        this.sourceClasspath.add(this.classFilesDir.getCanonicalPath());
                    }
                    catch (IOException e2) {
                        throw new PvsStudioException("unable to locate class files dir: " + String.valueOf(this.classFilesDir), e2);
                    }
                    Collection oldPackages = this.factory.Package().getAll();
                    logger.info("Old packages size: {}", (Object)oldPackages.size());
                    for (CtPackage pkg : oldPackages) {
                        if (!pkg.getTypes().isEmpty() || !pkg.getPackages().isEmpty() || pkg.isUnnamedPackage()) continue;
                        pkg.delete();
                    }
                    logger.info("Data processed");
                    this.processArguments();
                    incrementalSources.forEach(f -> this.addInputResource(f.getPath()));
                    outdatedModel = !this.removedSources.isEmpty() || !this.addedSources.isEmpty() || !incrementalSources.isEmpty();
                    this.setBinaryOutputDirectory(this.classFilesDir);
                    logger.info("Added: {}", (Object)this.addedSources.size());
                    logger.info("Removed: {}", (Object)this.removedSources.size());
                    logger.info("Modified : {}", (Object)(incrementalSources.size() - this.addedSources.size()));
                }
                catch (PvsStudioException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn("Failed to use cached model");
                    this.removedSources = Collections.emptySet();
                    this.addedSources = Collections.emptySet();
                    this.commonSources = Collections.emptySet();
                    forceRebuild = true;
                }
            }
        }
        boolean bl = this.buildingFromScratch = forceRebuild || disableCache;
        if (this.buildingFromScratch) {
            logger.info("Build model from scratch...");
            this.factory = this.createFactory();
            this.processArguments();
            this.inputSources.forEach(f -> this.addInputResource(f.getPath()));
            outdatedModel = true;
            this.setBinaryOutputDirectory(this.classFilesDir);
        }
        this.changesPresent = outdatedModel;
        this.getEnvironment().setSourceClasspath(this.sourceClasspath.toArray(new String[0]));
    }

    public void saveCache() {
        if (this.incrementalCacheDirectory == null) {
            throw new PvsStudioException("incremental cache directory is null");
        }
        Factory factory = this.getFactory();
        if (factory == null) {
            throw new PvsStudioException("factory is null");
        }
        logger.info("Cache saving started.");
        try {
            this.getModelBuilder().compile(new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.FILES});
        }
        catch (Exception ex) {
            logger.warn("Spoon compile error: {}", (Object)ex.getMessage(), (Object)ex);
        }
        this.saveFactory(factory, this.modelFile);
        CacheInfo newCacheInfo = new CacheInfo();
        newCacheInfo.lastBuildTime = System.currentTimeMillis();
        HashMap<File, Set<File>> newSourcesMap = new HashMap<File, Set<File>>();
        for (Map.Entry e : factory.CompilationUnit().getMap().entrySet()) {
            newSourcesMap.put(new File((String)e.getKey()), new HashSet(((CompilationUnit)e.getValue()).getBinaryFiles()));
        }
        if (this.cacheInfo != null) {
            newSourcesMap.putAll(this.cacheInfo.inputSourcesMap);
            for (File r : this.removedSources) {
                ((Set)newSourcesMap.get(r)).forEach(File::delete);
                newSourcesMap.remove(r);
            }
        }
        Collection dirs = FileUtils.listFilesAndDirs((File)this.classFilesDir, (IOFileFilter)DirectoryFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        dirs.stream().filter(d -> d.exists() && FileUtils.listFiles((File)d, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).isEmpty()).forEach(FileUtils::deleteQuietly);
        newCacheInfo.inputSourcesMap = newSourcesMap;
        RulesUtils.saveObject(newCacheInfo, this.cacheInfoFile);
        logger.info("Cache saving finished.");
    }

    private static class CacheInfo
    implements Serializable {
        public static final long serialVersionUID = 15L;
        public long lastBuildTime;
        public Map<File, Set<File>> inputSourcesMap;

        private CacheInfo() {
        }
    }
}

