/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.processors;

import com.pvsstudio.PvsStudioException;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtVisitor;

public class RuntimeAnnotationProcessor {
    private final Set<RuntimeAnnotationRunner> annotationRunners = new HashSet<RuntimeAnnotationRunner>();

    public RuntimeAnnotationProcessor(DataFlow dataFlow, AnnotationService annotationService) {
        String packageName = RuntimeAnnotationRunner.class.getPackage().getName();
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        for (Class type : reflections.getSubTypesOf(RuntimeAnnotationRunner.class)) {
            try {
                RuntimeAnnotationRunner ruleInstance = (RuntimeAnnotationRunner)((Object)type.getDeclaredConstructor(DataFlow.class, AnnotationService.class).newInstance(dataFlow, annotationService));
                this.annotationRunners.add(ruleInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new PvsStudioException("Failed to instantiate runtime annotations", e);
            }
        }
    }

    public void process(CtElement element) {
        if (element != null) {
            for (RuntimeAnnotationRunner runner : this.annotationRunners) {
                element.accept((CtVisitor)runner);
            }
        }
    }
}

