/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.migration;

import com.pvsstudio.migration.ClassInfo;
import com.pvsstudio.migration.MethodInfo;
import com.pvsstudio.migration.PackageInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationUtils {
    private static final Logger logger = LoggerFactory.getLogger(MigrationUtils.class);

    public static void saveInfoToFile(String filename, Object info) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(info);
            byte[] encodeBytes = Base64.getEncoder().encode(byteArrayOutputStream.toByteArray());
            try (FileOutputStream outputStream = new FileOutputStream(filename);){
                ((OutputStream)outputStream).write(encodeBytes);
            }
        }
        catch (IOException e) {
            logger.warn("Unable to save compatibility rules.", (Throwable)e);
        }
    }

    public static Map<String, PackageInfo> getInfoFromFile(String path) {
        Map map;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(FileUtils.readFileToByteArray((File)new File(path))));
        ObjectInputStream in = new ObjectInputStream(byteArrayInputStream);
        try {
            map = (Map)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                logger.warn("Unable to read compatibility rules.", (Throwable)e);
                return new HashMap<String, PackageInfo>();
            }
        }
        in.close();
        return map;
    }

    public static Map<String, PackageInfo> getInfoFromFile(InputStream is) {
        Map map;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(IOUtils.toByteArray((InputStream)is)));
        ObjectInputStream in = new ObjectInputStream(byteArrayInputStream);
        try {
            map = (Map)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn("Unable to read compatibility rules", (Throwable)e);
                return new HashMap<String, PackageInfo>();
            }
        }
        in.close();
        return map;
    }

    public static Map<String, PackageInfo> diffFromTo(Map<String, PackageInfo> from, Map<String, PackageInfo> to) {
        int countDeletedPackage = 0;
        int countDeletedClass = 0;
        int countDeletedMethods = 0;
        int countDeletedSignature = 0;
        int countDeprecatedMethods = 0;
        HashMap<String, PackageInfo> result = new HashMap<String, PackageInfo>();
        for (Map.Entry<String, PackageInfo> fromPackageInfoEntry : from.entrySet()) {
            String fromPackageInfoName = fromPackageInfoEntry.getKey();
            PackageInfo fromPackageInfo = fromPackageInfoEntry.getValue();
            PackageInfo diffPackageInfo = new PackageInfo();
            PackageInfo toPackageInfo = to.getOrDefault(fromPackageInfoName, null);
            if (toPackageInfo == null) {
                diffPackageInfo.clearFlags();
                diffPackageInfo.setDeleted(true);
                result.put(fromPackageInfoName, diffPackageInfo);
                ++countDeletedPackage;
                continue;
            }
            if (!fromPackageInfo.isDeprecated() && toPackageInfo.isDeprecated()) {
                diffPackageInfo.setDeprecated(true);
                result.put(fromPackageInfoName, diffPackageInfo);
            }
            for (Map.Entry<String, ClassInfo> fromClassInfoEntry : fromPackageInfo.getAllClasses().entrySet()) {
                String fromClassInfoName = fromClassInfoEntry.getKey();
                ClassInfo fromClassInfo = fromClassInfoEntry.getValue();
                ClassInfo diffClassInfo = new ClassInfo();
                ClassInfo toClassInfo = toPackageInfo.getClass(fromClassInfoName);
                if (toClassInfo == null) {
                    diffClassInfo.clearFlags();
                    diffClassInfo.setDeleted(true);
                    diffPackageInfo.addClass(fromClassInfoName, diffClassInfo);
                    ++countDeletedClass;
                    continue;
                }
                if (!fromClassInfo.isDeprecated() && toClassInfo.isDeprecated()) {
                    diffClassInfo.setDeprecated(true);
                    diffPackageInfo.addClass(fromClassInfoName, diffClassInfo);
                }
                for (Map.Entry<String, MethodInfo> fromMethodsEntry : fromClassInfo.getAllMethods().entrySet()) {
                    String fromMethodInfoName = fromMethodsEntry.getKey();
                    MethodInfo fromMethodInfo = fromMethodsEntry.getValue();
                    int indexFirstElement = fromMethodInfoName.indexOf(40);
                    if (indexFirstElement < 0) continue;
                    String nameWithoutSignature = fromMethodInfoName.substring(0, indexFirstElement);
                    List filterMethods = toClassInfo.getAllMethods().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(nameWithoutSignature)).collect(Collectors.toList());
                    if (filterMethods.isEmpty()) {
                        fromMethodInfo.clearFlags();
                        fromMethodInfo.setDeleted(true);
                        diffClassInfo.addMethod(fromMethodInfoName, fromMethodInfo);
                        ++countDeletedMethods;
                        continue;
                    }
                    MethodInfo toMethod = toClassInfo.getMethod(fromMethodInfoName);
                    if (toMethod == null) {
                        fromMethodInfo.clearFlags();
                        fromMethodInfo.setDeletedSignature(true);
                        diffClassInfo.addMethod(fromMethodInfoName, fromMethodInfo);
                        ++countDeletedSignature;
                        continue;
                    }
                    if (fromMethodInfo.isDeprecated() || !toMethod.isDeprecated()) continue;
                    diffClassInfo.addMethod(fromMethodInfoName, toMethod);
                    ++countDeprecatedMethods;
                }
                if (diffClassInfo.getAllMethods().isEmpty()) continue;
                diffPackageInfo.addClass(fromClassInfoName, diffClassInfo);
            }
            if (diffPackageInfo.getAllClasses().isEmpty()) continue;
            result.put(fromPackageInfoName, diffPackageInfo);
        }
        System.out.println("----------------------------------");
        System.out.println("Number of deleted packages: " + countDeletedPackage);
        System.out.println("Number of deleted classes: " + countDeletedClass);
        System.out.println("Number of deleted methods: " + countDeletedMethods);
        System.out.println("Number of deleted signatures: " + countDeletedSignature);
        System.out.println("Number of deprecated methods: " + countDeprecatedMethods);
        System.out.println("----------------------------------");
        return result;
    }

    public static Map<String, PackageInfo> merge(Map<String, PackageInfo> firstMap, Map<String, PackageInfo> secondMap) {
        HashMap<String, PackageInfo> resultMap = new HashMap<String, PackageInfo>(firstMap);
        for (Map.Entry<String, PackageInfo> secondPackageInfoEntry : secondMap.entrySet()) {
            String secondPackageInfoName = secondPackageInfoEntry.getKey();
            PackageInfo secondPackageInfo = secondPackageInfoEntry.getValue();
            PackageInfo firstPackageInfo = resultMap.getOrDefault(secondPackageInfoName, null);
            if (firstPackageInfo == null) {
                resultMap.put(secondPackageInfoName, secondPackageInfo);
                continue;
            }
            if (!firstPackageInfo.isDeleted() && secondPackageInfo.isDeleted()) {
                firstPackageInfo.setDeleted(true);
                firstPackageInfo.getAllClasses().clear();
                continue;
            }
            for (Map.Entry<String, ClassInfo> secondClassInfoEntry : secondPackageInfo.getAllClasses().entrySet()) {
                String secondClassInfoName = secondClassInfoEntry.getKey();
                ClassInfo secondClassInfo = secondClassInfoEntry.getValue();
                ClassInfo firstClassInfo = firstPackageInfo.getClass(secondClassInfoName);
                if (firstClassInfo == null) {
                    firstPackageInfo.addClass(secondClassInfoName, secondClassInfo);
                    continue;
                }
                if (!firstClassInfo.isDeleted() && secondClassInfo.isDeleted()) {
                    firstClassInfo.clearFlags();
                    firstClassInfo.setDeleted(true);
                    firstClassInfo.getAllMethods().clear();
                    continue;
                }
                for (Map.Entry<String, MethodInfo> secondMethodInfoEntry : secondClassInfo.getAllMethods().entrySet()) {
                    firstClassInfo.addMethod(secondMethodInfoEntry.getKey(), secondMethodInfoEntry.getValue());
                }
            }
        }
        return resultMap;
    }
}

