/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.matcher.InvocationMatcher;
import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;

public class XmlParserAnnotationRunner
extends RuntimeAnnotationRunner {
    private static final String SET_PROPERTY = "setProperty";
    private static final String SET_FEATURE = "setFeature";
    private static final String SET_ATTRIBUTE = "setAttribute";
    private final List<ArgumentMethodMatcher> xeeSources;
    private final List<ArgumentMethodMatcher> xxeSanitizations;
    private final List<ArgumentMethodMatcher> universalSanitizations;

    public XmlParserAnnotationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
        Predicate<CtElement> literalValidator = el -> el instanceof CtLiteral;
        Predicate<CtElement> emptyStringPredicate = this.createCertainLiteralPredicate("");
        Predicate<CtElement> truePredicate = this.createCertainLiteralPredicate(Boolean.TRUE);
        Predicate<CtElement> falsePredicate = this.createCertainLiteralPredicate(Boolean.FALSE);
        this.universalSanitizations = this.getUniversalSanitizations(emptyStringPredicate, literalValidator);
        this.xxeSanitizations = this.getXxeSanitizations(emptyStringPredicate, literalValidator, truePredicate);
        this.xeeSources = this.getXeeSources(literalValidator, falsePredicate);
    }

    @NotNull
    private Predicate<CtElement> createCertainLiteralPredicate(@NotNull Object obj) {
        return v -> Optional.ofNullable(v).filter(el -> el instanceof CtLiteral).map(el -> ((CtLiteral)el).getValue()).filter(obj::equals).isPresent();
    }

    private List<ArgumentMethodMatcher> getUniversalSanitizations(Predicate<CtElement> emptyStringPredicate, Predicate<CtElement> literalValidator) {
        Predicate<List<CtElement>> disallowAllDtd = XmlParserAnnotationRunner.getMapPairValidator(Map.of("http://apache.org/xml/features/disallow-doctype-decl", true, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false));
        LinkedList<ArgumentMethodMatcher> matchers = new LinkedList<ArgumentMethodMatcher>();
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.DocumentBuilderFactory", SET_FEATURE, List.of(literalValidator, literalValidator), disallowAllDtd));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.SAXParserFactory", SET_FEATURE, List.of(literalValidator, literalValidator), disallowAllDtd));
        matchers.add(new ArgumentMethodMatcher("org.dom4j.io.SAXReader", SET_FEATURE, List.of(literalValidator, literalValidator), disallowAllDtd));
        matchers.add(new ArgumentMethodMatcher("org.xml.sax.XMLReader", SET_FEATURE, List.of(literalValidator, literalValidator), disallowAllDtd));
        matchers.add(new ArgumentMethodMatcher("javax.xml.stream.XMLInputFactory", SET_PROPERTY, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLInputFactory", Set.of("SUPPORT_DTD")), emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.stream.XMLInputFactory", SET_PROPERTY, List.of(literalValidator, literalValidator), XmlParserAnnotationRunner.getMapPairValidator(Map.of("javax.xml.stream.supportDTD", false))));
        return matchers;
    }

    private List<ArgumentMethodMatcher> getXxeSanitizations(Predicate<CtElement> emptyStringPredicate, Predicate<CtElement> literalValidator, Predicate<CtElement> truePredicate) {
        LinkedList<ArgumentMethodMatcher> matchers = new LinkedList<ArgumentMethodMatcher>();
        matchers.add(new ArgumentMethodMatcher("javax.xml.stream.XMLInputFactory", SET_PROPERTY, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLInputFactory", Set.of("IS_SUPPORTING_EXTERNAL_ENTITIES")), emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.stream.XMLInputFactory", SET_PROPERTY, List.of(literalValidator, literalValidator), XmlParserAnnotationRunner.getMapPairValidator(Map.of("javax.xml.stream.isSupportingExternalEntities", false))));
        Predicate<List<CtElement>> saxSanitization = XmlParserAnnotationRunner.getMapPairValidator(Map.of("http://xml.org/sax/features/external-general-entities", false, "http://xml.org/sax/features/external-parameter-entities", false));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.DocumentBuilderFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSanitization));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.SAXParserFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSanitization));
        matchers.add(new ArgumentMethodMatcher("org.dom4j.io.SAXReader", SET_FEATURE, List.of(literalValidator, literalValidator), saxSanitization));
        matchers.add(new ArgumentMethodMatcher("org.xml.sax.XMLReader", SET_FEATURE, List.of(literalValidator, literalValidator), saxSanitization));
        Predicate<CtElement> xmlConstantsKeyValidator = el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("ACCESS_EXTERNAL_DTD", "ACCESS_EXTERNAL_SCHEMA", "ACCESS_EXTERNAL_STYLESHEET"));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.SAXParser", SET_PROPERTY, List.of(xmlConstantsKeyValidator, emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.validation.SchemaFactory", SET_PROPERTY, List.of(xmlConstantsKeyValidator, emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.transform.sax.SAXTransformerFactory", SET_ATTRIBUTE, List.of(xmlConstantsKeyValidator, emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.validation.Validator", SET_PROPERTY, List.of(xmlConstantsKeyValidator, emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.transform.TransformerFactory", SET_ATTRIBUTE, List.of(xmlConstantsKeyValidator, emptyStringPredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.transform.TransformerFactory", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), truePredicate)));
        return matchers;
    }

    private List<ArgumentMethodMatcher> getXeeSources(Predicate<CtElement> literalValidator, Predicate<CtElement> falsePredicate) {
        LinkedList<ArgumentMethodMatcher> matchers = new LinkedList<ArgumentMethodMatcher>();
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.DocumentBuilderFactory", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), falsePredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.transform.TransformerFactory", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), falsePredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.validation.SchemaFactory", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), falsePredicate)));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.SAXParserFactory", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), falsePredicate)));
        matchers.add(new ArgumentMethodMatcher("org.xml.sax.XMLReader", SET_FEATURE, List.of(el -> XmlParserAnnotationRunner.validateField(el, "XMLConstants", Set.of("FEATURE_SECURE_PROCESSING")), falsePredicate)));
        Predicate<List<CtElement>> saxSource = XmlParserAnnotationRunner.getMapPairValidator(Map.of("http://javax.xml.XMLConstants/feature/secure-processing", false));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.DocumentBuilderFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSource));
        matchers.add(new ArgumentMethodMatcher("javax.xml.transform.TransformerFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSource));
        matchers.add(new ArgumentMethodMatcher("javax.xml.validation.SchemaFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSource));
        matchers.add(new ArgumentMethodMatcher("javax.xml.parsers.SAXParserFactory", SET_FEATURE, List.of(literalValidator, literalValidator), saxSource));
        matchers.add(new ArgumentMethodMatcher("org.xml.sax.XMLReader", SET_FEATURE, List.of(literalValidator, literalValidator), saxSource));
        return matchers;
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (this.universalSanitizations.stream().anyMatch(x -> x.matches(invocation))) {
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.MODIFIES_STATE);
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.XXE_PARSER_SANITIZATION);
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.XEE_PARSER_SANITIZATION);
        }
        if (this.xxeSanitizations.stream().anyMatch(x -> x.matches(invocation))) {
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.MODIFIES_STATE);
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.XXE_PARSER_SANITIZATION);
        }
        if (this.xeeSources.stream().anyMatch(x -> x.matches(invocation))) {
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.MODIFIES_STATE);
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.XEE_UNSECURE_PARSER_SOURCE);
        }
    }

    private static boolean validateField(CtElement element, String typeName, Set<String> fieldNames) {
        Matcher fieldAccessMatcher = new Matcher(fieldAccess -> fieldNames.contains(fieldAccess.getVariable().getSimpleName()) && Optional.ofNullable(fieldAccess.getTarget()).filter(x -> x instanceof CtTypeAccess).map(x -> (CtTypeAccess)x).map(CtTypeAccess::getAccessedType).filter(x -> typeName.equals(x.getSimpleName())).isPresent());
        return element instanceof CtFieldAccess && fieldAccessMatcher.matches((CtElement)((CtFieldAccess)element));
    }

    private static Predicate<List<CtElement>> getMapPairValidator(Map<Object, Object> pairs) {
        return list -> {
            if (list.size() != 2) {
                return false;
            }
            CtElement first = (CtElement)list.get(0);
            CtElement second = (CtElement)list.get(1);
            if (!(first instanceof CtLiteral) || !(second instanceof CtLiteral)) {
                return false;
            }
            Object firstObject = ((CtLiteral)first).getValue();
            Object secondObject = ((CtLiteral)second).getValue();
            return Objects.equals(pairs.get(firstObject), secondObject);
        };
    }

    private class ArgumentMethodMatcher {
        protected final InvocationMatcher invocationMatcher;
        protected final List<Predicate<CtElement>> argumentPredicates;
        protected final Predicate<List<CtElement>> argumentsBundlePredicate;

        private ArgumentMethodMatcher(String className, String methodName, List<Predicate<CtElement>> argumentPredicates, Predicate<List<CtElement>> argumentsBundlePredicate) {
            this.invocationMatcher = Matcher.ofClass((String)className).ofMethod(new String[]{methodName}).anyParameters().build();
            this.argumentPredicates = argumentPredicates;
            this.argumentsBundlePredicate = argumentsBundlePredicate;
        }

        private ArgumentMethodMatcher(String className, String methodName, List<Predicate<CtElement>> argumentPredicates) {
            this(className, methodName, argumentPredicates, list -> list.stream().noneMatch(Objects::isNull));
        }

        private boolean matches(CtInvocation<?> invocation) {
            List args = invocation.getArguments();
            if (this.invocationMatcher.matches(invocation) && args.size() == this.argumentPredicates.size()) {
                LinkedList<CtElement> arguments = new LinkedList<CtElement>();
                for (int i = 0; i < args.size(); ++i) {
                    arguments.add(XmlParserAnnotationRunner.this.findVariableDefinition((CtElement)args.get(i), this.argumentPredicates.get(i)));
                }
                return this.argumentsBundlePredicate.test(arguments);
            }
            return false;
        }
    }
}

