/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.Set;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;

public class SqlSanitizationRunner
extends RuntimeAnnotationRunner {
    private static final Set<String> sanitization = Set.of("\"", "'", ";", "--", "#", "/*", "*/", "or", "and", "union", "(", ")", "`", "+", "-", "/", "|", "&", "%", "_");

    public SqlSanitizationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (!this.isSanitized(invocation)) {
            this.removeAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.SQL_SANITIZATION);
        }
    }

    private boolean isSanitized(CtInvocation<?> inv) {
        if (this.containsAnnotation((CtElement)inv, (Annotation)FlagAnnotation.SQL_SANITIZATION)) {
            if (inv.getArguments().size() == 1) {
                return true;
            }
            String arg = this.getString((CtElement)inv.getArguments().get(0));
            if (arg != null) {
                String tStr = arg.toLowerCase();
                return sanitization.stream().anyMatch(x -> x.equals(tStr));
            }
        }
        return false;
    }
}

