/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.FieldContractAnnotation;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtAbstractVisitor;

public abstract class RuntimeAnnotationRunner
extends CtAbstractVisitor {
    protected final DataFlow dataFlow;
    protected final AnnotationService annotationService;

    RuntimeAnnotationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        this.dataFlow = Objects.requireNonNull(dataFlow);
        this.annotationService = Objects.requireNonNull(annotationService);
    }

    @NotNull
    public Annotations getLibraryAnnotation(@NotNull CtElement invocation) {
        return this.annotationService.getAnnotations(invocation);
    }

    @Nullable
    public CtElement findVariableDefinition(CtElement start, Predicate<CtElement> elementPredicate) {
        if (elementPredicate == null || elementPredicate.test(start)) {
            return start;
        }
        if (start instanceof CtVariable) {
            CtVariable variable = (CtVariable)start;
            return this.findVariableDefinition((CtElement)variable.getDefaultExpression(), elementPredicate);
        }
        if (start instanceof CtVariableAccess) {
            CtVariableAccess access = (CtVariableAccess)start;
            CtVariableReference reference = access.getVariable();
            CtVariable declaration = reference.getDeclaration();
            if (declaration == null) {
                return null;
            }
            if (declaration.isFinal() && declaration.getDefaultExpression() != null) {
                return this.findVariableDefinition((CtElement)declaration.getDefaultExpression(), elementPredicate);
            }
            CtExecutable executable = (CtExecutable)start.getParent(CtExecutable.class);
            if (executable == null) {
                return null;
            }
            CtElement chainDefaultExpression = this.dataFlow.getVariableExpression(access, start);
            return this.findVariableDefinition(chainDefaultExpression, elementPredicate);
        }
        return null;
    }

    @Nullable
    public String getString(CtElement element) {
        return Optional.ofNullable(this.findVariableDefinition(element, CtLiteral.class::isInstance)).filter(CtLiteral.class::isInstance).map(CtLiteral.class::cast).map(CtLiteral::getValue).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    protected final void removeAnnotation(CtElement element, Annotation annotation) {
        this.annotationService.getAnnotations(element).remove(annotation);
    }

    protected final void addAnnotation(CtElement element, Annotation annotation) {
        this.annotationService.addAnnotation(element, annotation);
        if (annotation instanceof FlagAnnotation && element instanceof CtInvocation) {
            this.acceptForField((CtInvocation)element, (FlagAnnotation)annotation);
        }
    }

    protected final boolean containsAnnotation(CtElement element, Annotation annotation) {
        return this.annotationService.getAnnotations(element).contains(annotation);
    }

    private void acceptForField(CtInvocation<?> invocation, FlagAnnotation flagAnnotation) {
        if (!(invocation.getParent() instanceof CtBlock) || !(invocation.getParent().getParent() instanceof CtExecutable)) {
            return;
        }
        CtExecutable executable = (CtExecutable)invocation.getParent().getParent();
        if (executable instanceof CtLambda) {
            return;
        }
        CtFieldAccess field = null;
        if (Optional.of(invocation.getParent()).filter(x -> x instanceof CtAssignment).map(x -> ((CtAssignment)x).getAssigned()).filter(x -> x instanceof CtFieldAccess).map(x -> (CtFieldAccess)x).filter(x -> x.getTarget() instanceof CtThisAccess).isPresent()) {
            field = (CtFieldAccess)((CtAssignment)invocation.getParent()).getAssigned();
        }
        if (this.containsAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.MODIFIES_STATE) && invocation.getTarget() instanceof CtFieldAccess && ((CtFieldAccess)invocation.getTarget()).getTarget() instanceof CtThisAccess) {
            field = (CtFieldAccess)invocation.getTarget();
        }
        if (field != null && !this.dataFlow.containsAnyUsagesAfter((CtVariableAccess<?>)field)) {
            this.annotationService.addAnnotation((CtElement)executable, (Annotation)new FieldContractAnnotation(field.getVariable(), flagAnnotation));
        }
    }
}

