/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class RegexSanitizationRunner
extends RuntimeAnnotationRunner {
    public RegexSanitizationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (!this.isSanitized(invocation)) {
            this.removeAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.REGEX_SANITIZATION);
        }
    }

    private boolean isSanitized(CtInvocation<?> inv) {
        if (this.containsAnnotation((CtElement)inv, (Annotation)FlagAnnotation.REGEX_SANITIZATION)) {
            if (this.containsAnnotation((CtElement)inv, (Annotation)FlagAnnotation.REGEX_TARGET_SANITIZATION)) {
                for (CtVariableRead read : inv.getTarget().getElements((Filter)new TypeFilter(CtVariableRead.class))) {
                    this.addAnnotation((CtElement)read, (Annotation)FlagAnnotation.REGEX_SANITIZATION);
                }
            }
            return true;
        }
        return false;
    }
}

