/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;

public class PathTraversalSanitizationRunner
extends RuntimeAnnotationRunner {
    private static final Map<String, Set<String>> EXPECTED_SUBSTRINGS_BY_POSSIBLE_SANITIZATION_METHOD = Map.of("contains", Set.of("..", "~", ":"), "startsWith", Set.of("/", "\\"));

    public PathTraversalSanitizationRunner(DataFlow dataFlow, AnnotationService service) {
        super(dataFlow, service);
    }

    public <T> void visitCtInvocation(@NotNull CtInvocation<T> invocation) {
        if (this.isSanitization(invocation)) {
            this.addAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.PATH_TRAVERSAL_SANITIZATION);
        } else {
            this.removeAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.PATH_TRAVERSAL_SANITIZATION);
        }
    }

    private boolean isSanitization(@NotNull CtInvocation<?> invocation) {
        return this.containsAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.PATH_TRAVERSAL_SANITIZATION) || this.isSanitizationViaNormalizedStartsWith(invocation) || this.isContainsOrStartsWithSanitization(invocation);
    }

    private boolean isContainsOrStartsWithSanitization(@NotNull CtInvocation<?> invocation) {
        if (!this.containsAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.POTENTIAL_PATH_TRAVERSAL_SANITIZATION)) {
            return false;
        }
        List arguments = invocation.getArguments();
        if (arguments.isEmpty()) {
            return false;
        }
        CtExecutableReference executable = invocation.getExecutable();
        Set<String> expected = EXPECTED_SUBSTRINGS_BY_POSSIBLE_SANITIZATION_METHOD.get(executable.getSimpleName());
        if (expected == null) {
            return false;
        }
        return Optional.ofNullable(this.getString((CtElement)arguments.get(0))).filter(expected::contains).isPresent();
    }

    private boolean isSanitizationViaNormalizedStartsWith(@NotNull CtInvocation<?> invocation) {
        CtExpression target = invocation.getTarget();
        return target instanceof CtInvocation && this.containsAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.NORMALIZED_PATH_TRAVERSAL_SANITIZATION) && this.containsAnnotation((CtElement)target, (Annotation)FlagAnnotation.PATH_NORMALIZATION);
    }
}

