/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.matcher.InvocationMatcher;
import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class NoSqlAnnotationRunner
extends RuntimeAnnotationRunner {
    private static final InvocationMatcher mapMatcher = Matcher.ofClass((String)"java.util.Map").includeSubtypes().ofMethod(new String[]{"put"}).anyParameters().build();
    private static final Set<Matcher<CtTypeReference<?>>> mongoClasses = Set.of(Matcher.ofClass((String)"com.mongodb.BasicDBObject").build(), Matcher.ofClass((String)"com.mongodb.BasicDBObjectBuilder").build());

    public NoSqlAnnotationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.visitAbstractInvocation((CtAbstractInvocation<?>)ctConstructorCall);
    }

    public <T> void visitCtInvocation(@NotNull CtInvocation<T> inv) {
        this.visitAbstractInvocation((CtAbstractInvocation<?>)inv);
    }

    private void visitAbstractInvocation(CtAbstractInvocation<?> inv) {
        if (this.annotationService.getAnnotations(inv).contains((Annotation)FlagAnnotation.POTENTIAL_NOSQL_INJECTION_SINK) && inv.getArguments().size() == 2) {
            CtVariableRead variableRead;
            CtTypeReference typeReference;
            CtExpression expr = (CtExpression)inv.getArguments().get(0);
            boolean flag = true;
            if (inv instanceof CtInvocation && ((CtInvocation)inv).getTarget() instanceof CtVariableRead && (typeReference = (variableRead = (CtVariableRead)((CtInvocation)inv).getTarget()).getVariable().getType()) != null && mapMatcher.matches(inv) && mongoClasses.stream().noneMatch(matcher -> matcher.matches((CtElement)typeReference))) {
                List<CtElement> vars = this.dataFlow.getReachableUsages((CtElement)variableRead, this::filterToInvocations);
                flag = !vars.isEmpty();
            }
            String value = this.getString((CtElement)expr);
            if (flag && ("$where".equals(value) || "$function".equals(value) || "$accumulator".equals(value))) {
                this.annotationService.addAnnotation(inv, (Annotation)FlagAnnotation.NOSQL_INJECTION_SINK);
                this.annotationService.addAnnotation(inv, (Annotation)FlagAnnotation.SECOND_ARGUMENT_SINK);
            }
        }
    }

    private boolean filterToInvocations(CtVariableReference<?> reference) {
        CtAbstractInvocation abstractInvocation = (CtAbstractInvocation)reference.getParent(CtAbstractInvocation.class);
        if (abstractInvocation != null) {
            CtTypeReference type = null;
            if (abstractInvocation instanceof CtInvocation) {
                CtInvocation inv = (CtInvocation)abstractInvocation;
                if (inv.getTarget() instanceof CtTypeAccess) {
                    type = ((CtTypeAccess)inv.getTarget()).getAccessedType();
                } else if (inv.getTarget() instanceof CtVariableAccess) {
                    type = ((CtVariableAccess)inv.getTarget()).getType();
                }
            } else if (abstractInvocation instanceof CtConstructorCall) {
                CtConstructorCall c = (CtConstructorCall)abstractInvocation;
                type = c.getExecutable().getDeclaringType();
            }
            if (type != null) {
                CtTypeReference type1 = type;
                return mongoClasses.stream().anyMatch(matcher -> matcher.matches((CtElement)type1));
            }
        }
        return false;
    }
}

