/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.Set;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;

public class LogSanitizationRunner
extends RuntimeAnnotationRunner {
    private static final Set<String> SANITIZATION = Set.of("\n", "\r", "\r\n", "<br>", "\u0000");

    public LogSanitizationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (!this.isSanitized(invocation)) {
            this.removeAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.LOG_SANITIZATION);
        }
    }

    private boolean isSanitized(CtInvocation<?> inv) {
        if (!this.containsAnnotation((CtElement)inv, (Annotation)FlagAnnotation.LOG_SANITIZATION)) {
            return false;
        }
        if (inv.getArguments().size() == 1) {
            return true;
        }
        String arg = this.getString((CtElement)inv.getArguments().get(0));
        if (arg != null) {
            String lowerCaseArg = arg.toLowerCase();
            return SANITIZATION.stream().anyMatch(x -> x.equals(lowerCaseArg));
        }
        return false;
    }
}

