/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class LdapSanitizationRunner
extends RuntimeAnnotationRunner {
    private static final Map<String, String> ESCAPED_CHARACTERS = new HashMap<String, String>();

    public LdapSanitizationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        boolean isSanitized;
        boolean bl = isSanitized = this.containsAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.LDAP_SANITIZATION) && this.isCharacterEscaping(invocation);
        if (!isSanitized) {
            this.removeAnnotation((CtElement)invocation, (Annotation)FlagAnnotation.LDAP_SANITIZATION);
        }
    }

    private boolean isCharacterEscaping(CtInvocation<?> invocation) {
        List arguments = invocation.getArguments();
        if (arguments.isEmpty() || arguments.size() > 2) {
            return false;
        }
        String firstStringArgument = this.getStringValue((CtExpression)arguments.get(0));
        if (firstStringArgument == null || !ESCAPED_CHARACTERS.containsKey(firstStringArgument)) {
            return false;
        }
        if (arguments.size() == 1) {
            return true;
        }
        String secondArgument = this.getStringValue((CtExpression)arguments.get(1));
        return secondArgument != null && ESCAPED_CHARACTERS.get(firstStringArgument).equals(secondArgument);
    }

    @Nullable
    private String getStringValue(CtExpression<?> expression) {
        if (expression instanceof CtInvocation) {
            return Optional.of((CtInvocation)expression).filter(inv -> this.isCharacterToString(inv.getExecutable())).map(inv -> this.getStringValue((CtExpression)inv.getArguments().get(0))).orElse(null);
        }
        if (expression instanceof CtLiteral) {
            return Optional.of((CtLiteral)expression).filter(this::isStringOrCharType).map(CtLiteral::getValue).map(Object::toString).orElse(null);
        }
        return this.getString((CtElement)expression);
    }

    private boolean isCharacterToString(CtExecutableReference<?> executableReference) {
        return Optional.of(executableReference).filter(er -> er.getSimpleName().equals("toString")).filter(er -> er.getDeclaringType() != null && er.getDeclaringType().getQualifiedName().equals("java.lang.Character")).isPresent();
    }

    private boolean isStringOrCharType(CtExpression<?> expression) {
        CtTypeReference reference = expression.getType();
        String[] stringTypes = new String[]{"java.lang.String", "java.lang.CharSequence", "char", "java.lang.Character"};
        if (reference.isArray()) {
            reference = ((CtArrayTypeReference)reference).getArrayType();
        }
        CtTypeReference finalReference = reference;
        return Arrays.stream(stringTypes).anyMatch(typeName -> finalReference.getQualifiedName().equals(typeName));
    }

    static {
        ESCAPED_CHARACTERS.put("*", "\\2a");
        ESCAPED_CHARACTERS.put("(", "\\28");
        ESCAPED_CHARACTERS.put(")", "\\29");
        ESCAPED_CHARACTERS.put("|", "\\7c");
        ESCAPED_CHARACTERS.put("\\", "\\5c");
        ESCAPED_CHARACTERS.put("&", "\\26");
        ESCAPED_CHARACTERS.put("!", "\\21");
        ESCAPED_CHARACTERS.put("=", "\\3d");
        ESCAPED_CHARACTERS.put(">", "\\3e");
        ESCAPED_CHARACTERS.put("<", "\\3c");
        ESCAPED_CHARACTERS.put("NUL", "\\00");
        ESCAPED_CHARACTERS.put("\\*", "\\\\2a");
        ESCAPED_CHARACTERS.put("\\(", "\\\\28");
        ESCAPED_CHARACTERS.put("\\)", "\\\\29");
        ESCAPED_CHARACTERS.put("\\|", "\\\\7c");
        ESCAPED_CHARACTERS.put("\\\\", "\\\\5c");
        ESCAPED_CHARACTERS.put("\\&", "\\\\26");
        ESCAPED_CHARACTERS.put("\\!", "\\\\21");
        ESCAPED_CHARACTERS.put("\\=", "\\\\3d");
        ESCAPED_CHARACTERS.put("\\>", "\\\\3e");
        ESCAPED_CHARACTERS.put("\\<", "\\\\3c");
        ESCAPED_CHARACTERS.put("\u0000", "\\00");
        ESCAPED_CHARACTERS.put("\\\u0000", "\\\\00");
    }
}

