/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import java.util.List;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

public class ControllerMethodAnnotationRunner
extends RuntimeAnnotationRunner {
    private static final List<String> TARGET_METHOD_ANNOTATIONS = List.of("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PatchMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PutMapping", "jakarta.ws.rs.GET", "jakarta.ws.rs.PUT", "jakarta.ws.rs.POST", "jakarta.ws.rs.DELETE", "jakarta.ws.rs.PATCH", "jakarta.ws.rs.HEAD", "jakarta.ws.rs.OPTIONS");

    public ControllerMethodAnnotationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtMethod(CtMethod<T> m) {
        if (m.getAnnotations().stream().filter(ann -> ann.getType() != null).anyMatch(ann -> TARGET_METHOD_ANNOTATIONS.contains(ann.getType().toString()))) {
            this.addAnnotation((CtElement)m, (Annotation)FlagAnnotation.CONTROLLER_METHOD);
        }
    }
}

