/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers.annotations;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.helpers.annotations.RuntimeAnnotationRunner;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;

public class CommonSanitizationRunner
extends RuntimeAnnotationRunner {
    public CommonSanitizationRunner(DataFlow dataFlow, AnnotationService annotationService) {
        super(dataFlow, annotationService);
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        BinaryOperatorKind opKind = operator.getKind();
        if (opKind.equals((Object)BinaryOperatorKind.EQ) || opKind.equals((Object)BinaryOperatorKind.NE)) {
            boolean isNullLiteralRight;
            CtExpression lho = operator.getLeftHandOperand();
            CtExpression rho = operator.getRightHandOperand();
            boolean isNullLiteralLeft = lho instanceof CtLiteral && ((CtLiteral)lho).getValue() == null;
            boolean bl = isNullLiteralRight = rho instanceof CtLiteral && ((CtLiteral)rho).getValue() == null;
            if (lho != rho && !isNullLiteralLeft && !isNullLiteralRight) {
                this.addAnnotation((CtElement)operator, (Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION);
            }
        }
    }

    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.containsAnnotation((CtElement)inv, (Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION) && inv.getArguments().contains(inv.getTarget())) {
            this.removeAnnotation((CtElement)inv, (Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION);
        }
    }
}

