/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;

public class TreeNode {
    private CtCodeElement element;
    private List<CtCodeElement> children = null;

    public TreeNode(CtCodeElement element) {
        this.element = element;
    }

    public final CtCodeElement getElement() {
        return this.element;
    }

    public final void setElement(CtCodeElement element) {
        this.element = element;
        this.children = null;
    }

    private List<CtCodeElement> getChildrenInternal() {
        CtCodeElement current = this.getElement();
        if (current instanceof CtLiteral) {
            return Collections.emptyList();
        }
        List<CtCodeElement> children = this.getChildrenHook();
        if (children != null) {
            return children;
        }
        if (current instanceof CtBinaryOperator) {
            CtBinaryOperator op = (CtBinaryOperator)current;
            return Arrays.asList(op.getLeftHandOperand(), op.getRightHandOperand());
        }
        if (current instanceof CtUnaryOperator) {
            return Collections.singletonList(((CtUnaryOperator)current).getOperand());
        }
        if (current instanceof CtConditional) {
            CtConditional cond = (CtConditional)current;
            return Arrays.asList(cond.getThenExpression(), cond.getElseExpression(), cond.getCondition());
        }
        return Collections.emptyList();
    }

    public List<CtCodeElement> getChildren() {
        if (this.children == null) {
            this.children = this.getChildrenInternal();
        }
        return this.children;
    }

    protected List<CtCodeElement> getChildrenHook() {
        return null;
    }

    public boolean hasChildren() {
        if (this.children == null) {
            this.children = this.getChildrenInternal();
        }
        return !this.children.isEmpty();
    }
}

