/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.helpers;

import com.pvsstudio.helpers.TreeNode;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import spoon.reflect.code.CtCodeElement;

public class TreeIterator {
    private final TreeNode currentNode;
    private final LinkedList<CtCodeElement> unfoldedNodes = new LinkedList();

    public TreeIterator(CtCodeElement node) {
        this.currentNode = new TreeNode(node);
    }

    public TreeIterator(CtCodeElement node, Function<CtCodeElement, TreeNode> constructor) {
        this.currentNode = constructor.apply(node);
    }

    public CtCodeElement getCurrentNode() {
        return this.currentNode.getElement();
    }

    public boolean isTerminalNode() {
        return !this.currentNode.hasChildren();
    }

    public CtCodeElement next() {
        List<CtCodeElement> children = this.currentNode.getChildren();
        if (children != null) {
            this.unfoldedNodes.addAll(children);
        }
        if (this.unfoldedNodes.isEmpty()) {
            return null;
        }
        this.currentNode.setElement(this.unfoldedNodes.pop());
        return this.currentNode.getElement();
    }

    public void forEach(BiFunction<CtCodeElement, TreeIterator, Boolean> action) {
        CtCodeElement node = this.getCurrentNode();
        while (node != null) {
            if (!action.apply(node, this).booleanValue()) {
                return;
            }
            node = this.next();
        }
    }

    public static void forEach(CtCodeElement node, BiFunction<CtCodeElement, TreeIterator, Boolean> action) {
        new TreeIterator(node).forEach(action);
    }

    public static void forEach(CtCodeElement node, Function<CtCodeElement, TreeNode> constructor, BiFunction<CtCodeElement, TreeIterator, Boolean> action) {
        new TreeIterator(node, constructor).forEach(action);
    }
}

