/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.formats;

import com.pvsstudio.core.OutputOptions;
import com.pvsstudio.core.OutputReport;
import com.pvsstudio.core.Warning;
import com.pvsstudio.core.WarningPosition;
import com.pvsstudio.runner.NativeLoader;
import com.pvsstudio.warnings.NavigationInfo;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlOutput
implements WarningsOutput {
    @Override
    @NotNull
    public String[] names() {
        return new String[]{"fullhtml"};
    }

    @Override
    @NotNull
    public String[] extensions() {
        return new String[]{"fullhtml"};
    }

    @Override
    public void write(@Nullable String outputPath, @NotNull WarningsSet warnings, @Nullable BufferedWriter writer) {
        if (outputPath == null) {
            return;
        }
        NativeLoader.load();
        OutputOptions options = new OutputOptions();
        options.setOutput(outputPath);
        options.setCodeMappings(new String[]{"CWE"});
        OutputReport outputReport = new OutputReport(options);
        outputReport.start();
        warnings.stream().filter(w -> !w.falseAlarm).forEach(w -> outputReport.write(this.convertToCoreWarning((com.pvsstudio.warnings.Warning)w)));
        outputReport.finish();
    }

    public void write(@Nullable String projectPath, @NotNull WarningsSet warnings) {
        this.write(projectPath, warnings, null);
    }

    private Warning convertToCoreWarning(com.pvsstudio.warnings.Warning warning) {
        Warning coreWarning = new Warning();
        coreWarning.setCode(warning.code);
        coreWarning.setMessage(warning.message);
        WarningPosition[] warningPositions = new WarningPosition[warning.positions.size()];
        for (int i = 0; i < warning.positions.size(); ++i) {
            WarningPosition warningPosition = new WarningPosition();
            warningPosition.setFile(warning.positions.get((int)i).file);
            warningPosition.setLine(warning.positions.get((int)i).line);
            warningPosition.setColumn(warning.positions.get((int)i).column);
            warningPosition.setEndLine(warning.positions.get((int)i).endLine);
            warningPosition.setEndColumn(warning.positions.get((int)i).endColumn);
            NavigationInfo warnNavigationInfo = warning.positions.get((int)i).navigation;
            if (warnNavigationInfo != null) {
                com.pvsstudio.core.NavigationInfo coreNavigationInfo = new com.pvsstudio.core.NavigationInfo();
                coreNavigationInfo.setPreviousLine(warnNavigationInfo.previousLine);
                coreNavigationInfo.setPreviousLineString(String.valueOf(warnNavigationInfo.previousLine));
                coreNavigationInfo.setCurrentLine(warnNavigationInfo.currentLine);
                coreNavigationInfo.setCurrentLineString(String.valueOf(warnNavigationInfo.currentLine));
                coreNavigationInfo.setNextLine(warnNavigationInfo.nextLine);
                coreNavigationInfo.setNextLineString(String.valueOf(warnNavigationInfo.nextLine));
                coreNavigationInfo.setColumns(warnNavigationInfo.columns);
                warningPosition.setNavigation(coreNavigationInfo);
            }
            warningPositions[i] = warningPosition;
        }
        coreWarning.setPositions(warningPositions);
        if (warning.stacktrace != null) {
            coreWarning.setStacktrace(warning.stacktrace.toArray(new String[warning.stacktrace.size()]));
        }
        coreWarning.setProjects(warning.projects.toArray(new String[warning.projects.size()]));
        coreWarning.setCwe(warning.cwe);
        coreWarning.setLevel(warning.level.ordinal());
        coreWarning.setFavorite(warning.favorite);
        coreWarning.setFalseAlarm(warning.falseAlarm);
        return coreWarning;
    }
}

