/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.resolvers;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.resolvers.AbstractResolver;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import java.util.List;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

public class XmlParserSanitizationResolver
extends AbstractResolver {
    private final FlagAnnotation sanitizationAnnotation;
    private final FlagAnnotation sourceAnnotation;
    private final Class<?> ruleClass;
    private List<TaintResult> declarationPlaces;

    public XmlParserSanitizationResolver(DataFlow dataFlow, AnnotationService service, FlagAnnotation sanitizationAnnotation, FlagAnnotation sourceAnnotation, Class<?> ruleClass) {
        super(dataFlow, service);
        this.sanitizationAnnotation = sanitizationAnnotation;
        this.sourceAnnotation = sourceAnnotation;
        this.ruleClass = ruleClass;
    }

    public List<TaintResult> getDeclarationPlaces() {
        return this.declarationPlaces;
    }

    @Override
    public void resolve(CtElement element) {
        if (!(element instanceof CtInvocation) || this.containsAnnotation(this.sanitizationAnnotation, element)) {
            return;
        }
        CtInvocation invocation = (CtInvocation)element;
        if (this.containsAnnotation(FlagAnnotation.XML_PARSING_SINK, (CtElement)invocation)) {
            List<TaintResult> result = this.dataFlow.scanTaint((CtElement)invocation.getTarget(), this.getStrategy(), this.ruleClass);
            this.declarationPlaces = result;
            if (result == null || result.isEmpty() || result.stream().noneMatch(TaintResult::isTainted)) {
                this.annotationService.addAnnotation((CtElement)invocation, (Annotation)this.sanitizationAnnotation);
            }
        }
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRuleStrategy(){

            @Override
            public boolean isSource(CtElement chainElement, CtExecutable<?> currentExecutable) {
                return XmlParserSanitizationResolver.this.containsAnnotation(XmlParserSanitizationResolver.this.sourceAnnotation, chainElement);
            }

            @Override
            public boolean isSink(CtElement chainElement) {
                return false;
            }

            @Override
            public boolean isSanitized(CtElement chainElement, Context context) {
                return XmlParserSanitizationResolver.this.containsAnnotation(XmlParserSanitizationResolver.this.sanitizationAnnotation, chainElement) || chainElement instanceof CtInvocation && context.getCurrentVariable() instanceof CtFieldReference && XmlParserSanitizationResolver.this.containsMethodFieldAnnotation(XmlParserSanitizationResolver.this.sanitizationAnnotation, (CtInvocation)chainElement, (CtFieldReference)context.getCurrentVariable());
            }

            @Override
            public boolean isBranchDirectionReversed(CtElement chainElement) {
                return XmlParserSanitizationResolver.this.containsAnnotation(FlagAnnotation.INVERSE_BRANCH_DIRECTION, chainElement);
            }

            @Override
            public boolean isStringConcatenationMethod(CtInvocation<?> inv) {
                return false;
            }

            @Override
            public boolean isStringsOnly() {
                return false;
            }

            @Override
            public boolean isTypeIgnored(CtTypeReference<?> type) {
                return false;
            }

            @Override
            public boolean isBlackListCommonSanitization(CtElement chainElement) {
                return false;
            }

            @Override
            public boolean isCommonSanitization(CtElement inv) {
                return false;
            }

            @Override
            public boolean isPushingCollectionMethod(CtInvocation<?> invocation) {
                return XmlParserSanitizationResolver.this.containsAnnotation(FlagAnnotation.PUSHING_METHOD, (CtElement)invocation);
            }

            @Override
            public boolean isSourceFirstElementsOnly() {
                return false;
            }
        };
    }
}

