/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.resolvers;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.resolvers.AbstractResolver;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import java.util.List;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

public final class ParseIntResolver
extends AbstractResolver {
    private final DataFlow cppDataFlow;

    public ParseIntResolver(DataFlow dataFlow) {
        super(dataFlow.getAnalyzer().getJavaDataFlow(), dataFlow.getAnalyzer().getAnnotationService());
        this.cppDataFlow = dataFlow;
    }

    @Override
    public void resolve(CtElement element) {
        if (!(element instanceof CtAbstractInvocation)) {
            return;
        }
        CtAbstractInvocation inv = (CtAbstractInvocation)element;
        if (inv.getExecutable().getDeclaringType() == null || !inv.getExecutable().getDeclaringType().getQualifiedName().equals("java.lang.Integer") || !inv.getExecutable().getSimpleName().equals("parseInt") || inv.getArguments().size() != 1) {
            return;
        }
        List<TaintResult> result = this.scan((CtElement)inv.getArguments().get(0));
        if (result != null && !result.isEmpty() && result.stream().anyMatch(TaintResult::isTainted)) {
            this.cppDataFlow.setValue((CtExpression)inv, this.cppDataFlow.generateIntPreciseValue());
        }
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRuleStrategy(){

            @Override
            public boolean isSource(CtElement chainElement, CtExecutable<?> currentExecutable) {
                if (chainElement instanceof CtParameterReference) {
                    if (currentExecutable instanceof CtMethod) {
                        return ParseIntResolver.this.containsAnnotation(FlagAnnotation.CONTROLLER_METHOD, (CtElement)currentExecutable) || ParseIntResolver.this.containsAnnotation(FlagAnnotation.MAIN_METHOD, (CtElement)currentExecutable);
                    }
                } else if (chainElement instanceof CtInvocation) {
                    return ParseIntResolver.this.containsAnnotation(FlagAnnotation.COMMON_SOURCE, chainElement);
                }
                return false;
            }

            @Override
            public boolean isSink(CtElement chainElement) {
                return false;
            }

            @Override
            public boolean isStringsOnly() {
                return false;
            }

            @Override
            public boolean isTypeIgnored(CtTypeReference<?> type) {
                return false;
            }

            @Override
            public boolean isBlackListCommonSanitization(CtElement element) {
                return false;
            }

            @Override
            public boolean isCommonSanitization(CtElement inv) {
                return false;
            }

            @Override
            public boolean isPushingCollectionMethod(CtInvocation<?> invocation) {
                return ParseIntResolver.this.containsAnnotation(FlagAnnotation.PUSHING_METHOD, (CtElement)invocation);
            }

            @Override
            public boolean isSanitized(CtElement el, Context context) {
                return false;
            }

            @Override
            public boolean isSourceFirstElementsOnly() {
                return true;
            }

            @Override
            public boolean isBranchDirectionReversed(CtElement chainElement) {
                return ParseIntResolver.this.containsAnnotation(FlagAnnotation.INVERSE_BRANCH_DIRECTION, chainElement);
            }

            @Override
            public boolean isStringConcatenationMethod(CtInvocation<?> invocation) {
                return ParseIntResolver.this.containsAnnotation(FlagAnnotation.STRING_CONCAT, (CtElement)invocation);
            }
        };
    }
}

