/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.resolvers;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.helpers.annotations.FieldContractAnnotation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtFieldReference;

public abstract class AbstractResolver {
    @NotNull
    protected final AnnotationService annotationService;
    @NotNull
    protected final DataFlow dataFlow;

    protected AbstractResolver(@NotNull DataFlow dataFlow, @NotNull AnnotationService annotationService) {
        this.annotationService = annotationService;
        this.dataFlow = dataFlow;
    }

    protected abstract TaintRuleStrategy getStrategy();

    public abstract void resolve(CtElement var1);

    protected final List<TaintResult> scan(CtElement element) {
        return this.dataFlow.scanTaint(element, this.getStrategy(), this.getClass());
    }

    protected final boolean containsAnnotation(FlagAnnotation annotation, CtElement element) {
        return this.annotationService.getAnnotations(element).contains((Annotation)annotation);
    }

    protected final boolean containsMethodFieldAnnotation(FlagAnnotation flagAnnotation, CtInvocation<?> inv, CtFieldReference<?> fieldReference) {
        CtExecutable executable = inv.getExecutable().getDeclaration();
        if (executable == null) {
            return false;
        }
        Annotations annotations = this.annotationService.getAnnotations((CtElement)executable);
        return annotations.getCustomAnnotations().stream().filter(FieldContractAnnotation.class::isInstance).map(FieldContractAnnotation.class::cast).filter(ann -> ann.getAnnotation().equals((Object)flagAnnotation)).anyMatch(ann -> ann.getField().equals((Object)fieldReference));
    }
}

