/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.annotation;

import com.google.inject.Inject;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtExecutable;

public class OneTimeAnnotationSetter
implements AnnotationSetter {
    private final AnnotationSetter proxyAnnotationSetter;
    private final Set<CtExecutable<?>> passedExecutables = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    @Inject
    public OneTimeAnnotationSetter(AnnotationSetter proxyAnnotationSetter) {
        this.proxyAnnotationSetter = proxyAnnotationSetter;
    }

    @Override
    public void processAnnotations(@NotNull CtExecutable<?> executable) {
        if (this.passedExecutables.add(executable)) {
            this.proxyAnnotationSetter.processAnnotations(executable);
        }
    }
}

