/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow.annotation;

import com.google.inject.Inject;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.processors.RuntimeAnnotationProcessor;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.visitor.CtScanner;

public class DataFlowAnnotationSetter
implements AnnotationSetter {
    private final CtScanner runtimeAnnotationScanner;

    @Inject
    public DataFlowAnnotationSetter(DataFlow dataFlow, AnnotationService service) {
        final RuntimeAnnotationProcessor processor = new RuntimeAnnotationProcessor(dataFlow, service);
        this.runtimeAnnotationScanner = new CtScanner(){

            public void scan(CtElement el) {
                processor.process(el);
                super.scan(el);
            }
        };
    }

    @Override
    public void processAnnotations(@NotNull CtExecutable<?> executable) {
        if (this.runtimeAnnotationScanner != null) {
            this.runtimeAnnotationScanner.scan(executable);
        }
    }
}

