/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.pvsstudio.dataflow.TypesCache;
import com.pvsstudio.runner.Benchmark;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.reflect.code.CtLocalVariableImpl;

public class VariablesCache {
    private final Map<CtVariableReference<?>, CtVariable<?>> references = new IdentityHashMap();
    private final TypesCache typesCache;
    private static final CtVariable<?> NOT_VALID = new CtLocalVariableImpl();

    public VariablesCache(TypesCache types) {
        this.typesCache = types;
    }

    @Nullable
    private CtVariable<?> find(@NotNull CtVariableReference<?> ref) {
        if (ref instanceof CtFieldReference) {
            CtType<?> type = this.typesCache.resolve(((CtFieldReference)ref).getDeclaringType());
            return type == null ? null : type.getField(ref.getSimpleName());
        }
        return ref.getDeclaration();
    }

    @Nullable
    public CtVariable<?> resolve(@Nullable CtVariableReference<?> ref) {
        if (ref == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        CtVariable res = this.references.computeIfAbsent(ref, this::find);
        Benchmark.instance().step("Static analysis: variables resolving", System.currentTimeMillis() - start);
        return res == NOT_VALID ? null : res;
    }

    public void clear() {
        this.references.clear();
    }
}

