/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.pvsstudio.Utils;
import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Annotations;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.runner.Benchmark;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.reflect.declaration.CtTypeImpl;

public class TypesCache {
    private static final CtType<?> NOT_VALID = new CtTypeImpl<Object>(){
        private static final long serialVersionUID = 1L;

        public boolean isSubtypeOf(CtTypeReference<?> ctTypeReference) {
            return false;
        }

        public void accept(CtVisitor ctVisitor) {
        }
    };
    private static Annotations globalAnnotations;
    private static final Comparator<CtTypeReference<?>> HIERARCHY_COMPARATOR;
    private static Annotation globalEmptyAnnotation;
    private final Map<String, WeakReference<CtType<?>>> cache = new HashMap();
    private final Map<String, Long> annotationsCache = new HashMap<String, Long>();
    private final Map<CtTypeReference<?>, List<CtTypeReference<?>>> extendedClasses = new HashMap();
    private final Map<CtTypeReference<?>, List<CtTypeReference<?>>> implementedInterfaces = new HashMap();
    private final Annotations annotations;
    private final Annotation emptyAnnotation;

    public static synchronized Annotations getNativeAnnotations() {
        if (globalAnnotations == null) {
            globalAnnotations = new Annotations();
            globalEmptyAnnotation = new EmptyAnnotation(Annotation.getCPtr(globalAnnotations.getEmpty()));
        }
        return globalAnnotations;
    }

    public TypesCache() {
        TypesCache.getNativeAnnotations();
        this.annotations = globalAnnotations;
        this.emptyAnnotation = globalEmptyAnnotation;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public Annotation getEmptyAnnotation() {
        return this.emptyAnnotation;
    }

    private void getNestedTypes(CtType<?> type) {
        class NestedTypeScanner
        extends CtScanner {
            NestedTypeScanner() {
            }

            public <U> void visitCtClass(CtClass<U> ctClass) {
                super.visitCtClass(ctClass);
                TypesCache.this.cache.put(ctClass.getQualifiedName(), new WeakReference<CtClass<U>>(ctClass));
            }

            public <U> void visitCtInterface(CtInterface<U> ctInterface) {
                super.visitCtInterface(ctInterface);
                TypesCache.this.cache.put(ctInterface.getQualifiedName(), new WeakReference<CtInterface<U>>(ctInterface));
            }

            public <U extends Enum<?>> void visitCtEnum(CtEnum<U> ctEnum) {
                super.visitCtEnum(ctEnum);
                TypesCache.this.cache.put(ctEnum.getQualifiedName(), new WeakReference<CtEnum<U>>(ctEnum));
            }

            public <A extends java.lang.annotation.Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                super.visitCtAnnotationType(annotationType);
                TypesCache.this.cache.put(annotationType.getQualifiedName(), new WeakReference<CtAnnotationType<A>>(annotationType));
            }

            public <T> void visitCtNewClass(CtNewClass<T> newClass) {
                super.visitCtNewClass(newClass);
                TypesCache.this.cache.put(newClass.getAnonymousClass().getQualifiedName(), new WeakReference<CtClass>(newClass.getAnonymousClass()));
            }
        }
        new NestedTypeScanner().scan((CtElement)type);
    }

    public void add(@NotNull CtType<?> type) {
        this.cache.put(type.getQualifiedName(), new WeakReference(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CtType<?> resolve(@Nullable CtTypeReference<?> ref) {
        long start = System.currentTimeMillis();
        try {
            WeakReference<CtType<?>> res;
            if (ref == null) {
                CtType<?> ctType = null;
                return ctType;
            }
            int inertTypeIndex = ref.getQualifiedName().indexOf(36);
            if (inertTypeIndex == -1) {
                CtType ctType = ref.getTypeDeclaration();
                return ctType;
            }
            if (this.cache.size() >= 10240) {
                this.cache.clear();
            }
            if ((res = this.cache.get(ref.getQualifiedName())) == null || res.get() == null) {
                String s = ref.getQualifiedName().substring(0, inertTypeIndex);
                CtType t = ref.getFactory().Type().get(s);
                if (t == null) {
                    t = ref.getFactory().Type().get(ref.getActualClass());
                }
                if (t != null) {
                    this.getNestedTypes(t);
                }
                if ((res = this.cache.get(ref.getQualifiedName())) == null) {
                    CtType found = ref.getTypeDeclaration();
                    this.cache.put(ref.getQualifiedName(), new WeakReference<CtType>(found == null ? NOT_VALID : found));
                    res = this.cache.get(ref.getQualifiedName());
                }
            }
            CtType ctType = res.get() == NOT_VALID ? null : (CtType)res.get();
            return ctType;
        }
        catch (SpoonClassNotFoundException e) {
            this.cache.put(ref.getQualifiedName(), new WeakReference(NOT_VALID));
            CtType<?> ctType = null;
            return ctType;
        }
        finally {
            Benchmark.instance().step("Static analysis: type resolving", System.currentTimeMillis() - start);
        }
    }

    public boolean isSubtypeOf(CtTypeReference<?> type1, CtTypeReference<?> type2) {
        try {
            return type1.isSubtypeOf(type2);
        }
        catch (SpoonClassNotFoundException e) {
            return false;
        }
    }

    public boolean isSubtypeOf(CtExpression<?> expression, String qualifiedName) {
        try {
            CtTypeReference type1 = expression.getType();
            return type1 != null && type1.isSubtypeOf(expression.getFactory().Type().createReference(qualifiedName));
        }
        catch (SpoonClassNotFoundException e) {
            return false;
        }
    }

    @Nullable
    public CtTypeReference<?> getSuperclass(@Nullable CtTypeReference<?> type) {
        CtType<?> decl = this.resolve(type);
        return decl == null ? null : decl.getSuperclass();
    }

    @NotNull
    public Set<CtTypeReference<?>> getSuperInterfaces(@Nullable CtTypeReference<?> type) {
        CtType<?> decl = this.resolve(type);
        return decl == null ? Collections.emptySet() : decl.getSuperInterfaces();
    }

    @NotNull
    public List<CtTypeReference<?>> getAllExtendedClasses(@NotNull CtTypeReference<?> type) {
        if (type.getSuperclass() == null) {
            return Collections.emptyList();
        }
        List<CtTypeReference<?>> cachedResult = this.extendedClasses.get(type);
        if (cachedResult != null) {
            return cachedResult;
        }
        LinkedList<CtTypeReference<?>> result = new LinkedList<Object>();
        result.add(type.getSuperclass());
        result.addAll(this.getAllExtendedClasses(type.getSuperclass()));
        result = Collections.unmodifiableList(result);
        this.extendedClasses.put(type, result);
        return result;
    }

    @NotNull
    public List<CtTypeReference<?>> getAllImplementedInterfaces(@NotNull CtTypeReference<?> type) {
        List<CtTypeReference<?>> cachedResult = this.implementedInterfaces.get(type);
        if (cachedResult != null) {
            return cachedResult;
        }
        HashSet<Object> allInterfaces = new HashSet<Object>();
        if (type.getSuperclass() != null) {
            allInterfaces.addAll(this.getAllImplementedInterfaces(type.getSuperclass()));
        }
        for (CtTypeReference superInterface : type.getSuperInterfaces()) {
            if (!allInterfaces.add(superInterface)) continue;
            allInterfaces.addAll(this.getAllImplementedInterfaces(superInterface));
        }
        ArrayList<CtTypeReference<?>> result = new ArrayList(allInterfaces);
        Utils.bubbleSort(result, HIERARCHY_COMPARATOR);
        result = Collections.unmodifiableList(result);
        this.implementedInterfaces.put(type, result);
        return result;
    }

    @Nullable
    public Annotation getAnnotation(@NotNull String name) {
        long address = this.annotationsCache.computeIfAbsent(name, n -> Annotation.getCPtr(this.annotations.find((String)n)));
        return address == 0L ? null : new JavaAnnotation(address);
    }

    public void clear() {
        this.cache.clear();
        this.extendedClasses.clear();
        this.implementedInterfaces.clear();
    }

    static {
        HIERARCHY_COMPARATOR = (o1, o2) -> {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            if (o2.isSubtypeOf(o1)) {
                return 1;
            }
            if (o1.isSubtypeOf(o2)) {
                return -1;
            }
            return 0;
        };
    }

    static class EmptyAnnotation
    extends Annotation {
        public EmptyAnnotation(long address) {
            super(address);
        }

        @Override
        public boolean is(TypeClassification classification) {
            return false;
        }

        @Override
        public boolean is(FunctionClassification classification) {
            return false;
        }
    }

    static class JavaAnnotation
    extends Annotation {
        JavaAnnotation(long address) {
            super(address);
        }
    }
}

