/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.pvsstudio.core.Type;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.reference.CtFieldReference;

public class IntConstantsPool {
    private static final Set<Constant> pool = Set.of(new Constant(Integer.class, "MAX_VALUE", Integer.MAX_VALUE), new Constant(Integer.class, "MIN_VALUE", Integer.MIN_VALUE), new Constant(Integer.class, "SIZE", 32), new Constant(Integer.class, "BYTES", 4), new Constant(Long.class, "MAX_VALUE", Long.MAX_VALUE), new Constant(Long.class, "MIN_VALUE", Long.MIN_VALUE), new Constant(Short.class, "MAX_VALUE", Short.MAX_VALUE), new Constant(Short.class, "MIN_VALUE", Short.MIN_VALUE));

    private IntConstantsPool() {
    }

    @Nullable
    public static Pair<Number, Type> getFromPool(@NotNull CtFieldRead<?> variable) {
        CtFieldReference reference = variable.getVariable();
        if (reference == null || reference.getDeclaringType() == null) {
            return null;
        }
        for (Constant cons : pool) {
            if (!cons.typeCanonicalName.equals(reference.getDeclaringType().getQualifiedName()) || !cons.name.equals(reference.getSimpleName())) continue;
            return Pair.of((Object)cons.value, (Object)((Object)cons.type));
        }
        return null;
    }

    private static class Constant {
        private final String typeCanonicalName;
        private final String name;
        private final Number value;
        private final Type type;

        private Constant(Class<? extends Number> type, String name, Number value) {
            this.typeCanonicalName = type.getCanonicalName();
            this.name = name;
            this.value = value;
            if (type.equals(Integer.class)) {
                this.type = Type.Int32;
            } else if (type.equals(Long.class)) {
                this.type = Type.Int64;
            } else if (type.equals(Short.class)) {
                this.type = Type.Int16;
            } else {
                throw new IllegalArgumentException("Only integer types are supported in IntConstantsPool");
            }
        }
    }
}

