/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.declaration.CtElement;

public class IndicesMap {
    private final Map<CtElement, Integer> map = new IdentityHashMap<CtElement, Integer>(32);
    private final List<CtElement> list = new ArrayList<CtElement>();
    private final IndicesMap prev;
    private final long start;

    public IndicesMap(long start, IndicesMap prev) {
        this.start = start;
        this.prev = prev;
    }

    public void clear() {
        this.map.clear();
        this.list.clear();
    }

    public long getExpressionIndex(CtElement e) {
        if (e == null) {
            return 0L;
        }
        int newIndex = this.list.size() + 1;
        int prevIndex = Optional.ofNullable(this.map.putIfAbsent(e, newIndex)).orElse(0);
        if (prevIndex == 0) {
            this.list.add(e);
            return (long)newIndex + this.start;
        }
        return (long)prevIndex + this.start;
    }

    @Nullable
    public CtElement getExpressionByIndex(long idx) {
        if (idx == 0L) {
            return null;
        }
        if (idx <= this.start) {
            return this.prev == null ? null : this.prev.getExpressionByIndex(idx);
        }
        if ((idx -= this.start) > (long)this.list.size()) {
            return null;
        }
        return this.list.get((int)idx - 1);
    }
}

