/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.dataflow;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.pvsstudio.Utils;
import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.AnnotationHolder;
import com.pvsstudio.core.AnnotationsQueryResult;
import com.pvsstudio.core.BinaryOperator;
import com.pvsstudio.core.ClassVisitor;
import com.pvsstudio.core.ConditionTarget;
import com.pvsstudio.core.ConditionTargets;
import com.pvsstudio.core.ConstraintSolver;
import com.pvsstudio.core.FunctionVisitor;
import com.pvsstudio.core.JavaContext;
import com.pvsstudio.core.JavaDataFlow;
import com.pvsstudio.core.NegateConditionVisitor;
import com.pvsstudio.core.Type;
import com.pvsstudio.core.UnaryOperator;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.ValuesContainer;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VariableStateBuilder;
import com.pvsstudio.dataflow.IndicesMap;
import com.pvsstudio.dataflow.MethodAnnotation;
import com.pvsstudio.dataflow.TypesCache;
import com.pvsstudio.dataflow.VariablesCache;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.utility.LanguageUtility;
import com.pvsstudio.visitors.CallGraphVisitor;
import com.pvsstudio.visitors.DataFlowVisitor;
import com.pvsstudio.visitors.ModificationsScanner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class DataFlow
extends JavaDataFlow {
    private static final Logger logger = LoggerFactory.getLogger(DataFlow.class);
    private PvsStudioAnalyzer analyzer;
    private final Map<CtType<?>, Set<CtElement>> modifiedPrivateFields = new IdentityHashMap();
    private final Map<String, Variable> thisVariables = new HashMap<String, Variable>();
    private final Map<Variable, Boolean> mutableVariables = new HashMap<Variable, Boolean>();
    private Map<Variable, Boolean> mutableFields = new HashMap<Variable, Boolean>();
    private Map<CtVariable<?>, Variable> localVariables = new IdentityHashMap();
    private final IndicesMap indices = new IndicesMap(0L, null);
    private final IndicesMap interproceduralIndices = new IndicesMap(Integer.MAX_VALUE, this.indices);
    private final Map<CtElement, Long> values = new IdentityHashMap<CtElement, Long>(128);
    private final ListMultimap<CtElement, Pair<String, Long>> valueToTargetTypeBeforeCast = Multimaps.newListMultimap(new IdentityHashMap(128), ArrayList::new);
    private final Map<CtElement, MethodAnnotation> invocations = new IdentityHashMap<CtElement, MethodAnnotation>();
    private final Map<CtElement, MethodAnnotation> methodRefs = new IdentityHashMap<CtElement, MethodAnnotation>();
    private Map<String, CtTypeReference<?>> cacheAnnotations = new ConcurrentHashMap();
    private final Map<CtStatement, String> breakContainers = new IdentityHashMap<CtStatement, String>();
    private final Map<CtStatement, ValuesContainer> continueContainers = new IdentityHashMap<CtStatement, ValuesContainer>();
    private final TypesCache typesCache = new TypesCache();
    private final VariablesCache variablesCache = new VariablesCache(this.typesCache);
    private final ConditionTargets emptyTargets = new ConditionTargets();
    private final ConstraintSolver constraintSolver;
    private boolean isUnreachable = false;
    private boolean isFirstIteration = false;
    private final Map<CtExecutable<?>, AnnotationHolder> interproceduralInformation = new IdentityHashMap();
    private WeakReference<CtExecutable<?>> currentMethod = null;
    private final CallGraphVisitor callGraphVisitor = new CallGraphVisitor();
    private final Set<String> nameAnnotations = new HashSet<String>(Arrays.asList(TypesCache.getNativeAnnotations().getAllNameAnnotations(',').split(",")));

    public DataFlow() {
        super(TypesCache.getNativeAnnotations());
        this.constraintSolver = new ConstraintSolver(this);
    }

    public DataFlow(@NotNull PvsStudioAnalyzer analyzer) {
        this();
        this.analyzer = analyzer;
    }

    @NotNull
    private Variable createNewVariable(@NotNull CtVariable<?> var) {
        Variable res = this.getVariable(var.getSimpleName());
        if (var instanceof CtField) {
            if (!this.hasImmutableValue(var.getReference())) {
                this.mutableFields.put(res, false);
            }
            res.setGlobal(true);
        }
        if (var instanceof CtParameter && var.getAnnotations().stream().anyMatch(ann -> ann.toString().equalsIgnoreCase("nullable") || ann.toString().toLowerCase().endsWith(".nullable"))) {
            this.setValue(res, new VariableStateBuilder(this.getPool(), this.visitNullable()).build());
        }
        return res;
    }

    @NotNull
    private Variable getVariable(@NotNull CtTypeReference<?> type, Consumer<Variable> initVariable) {
        return this.thisVariables.computeIfAbsent(type.getQualifiedName(), v -> {
            Variable var = this.getVariable((String)v);
            initVariable.accept(var);
            return var;
        });
    }

    @NotNull
    private Variable getVariable(@NotNull CtVariable<?> var) {
        return this.localVariables.computeIfAbsent(var, this::createNewVariable);
    }

    private Set<CtElement> getModifiedFields(@NotNull CtType<?> type) {
        return ModificationsScanner.scan(type, this.variablesCache).keySet();
    }

    public void addGlobalVariable(@NotNull Variable var, boolean onlyState) {
        if (onlyState) {
            this.mutableVariables.putIfAbsent(var, true);
        } else {
            this.mutableVariables.put(var, false);
        }
    }

    private void addGlobalVariable(CtElement varRef, boolean onlyState) {
        Variable var = this.getVariableFromAccess(varRef);
        if (var != null) {
            this.visitRead(var);
            this.deleteValue(var, onlyState);
            this.addGlobalVariable(var, onlyState);
        }
    }

    public <T> void visitClass(CtType<T> ctClass, CtScanner visitor) {
        this.typesCache.add(ctClass);
        if (ctClass.getTypeMembers() != null && !ctClass.getTypeMembers().isEmpty()) {
            try (ClassVisitor classVisitor = new ClassVisitor(this);){
                for (CtTypeMember typeMember : ctClass.getTypeMembers()) {
                    if (!(typeMember instanceof CtType)) continue;
                    visitor.scan((CtElement)typeMember);
                }
                this.callGraphVisitor.build(ctClass.getTypeMembers().stream().filter(m -> !(m instanceof CtType)));
                List<CtElement> sorted = this.callGraphVisitor.getSorted();
                if (ctClass.isTopLevel()) {
                    new DataFlowVisitor(this).scan(this.callGraphVisitor.getExternalMembers());
                }
                visitor.scan(sorted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, T extends CtExecutable<A>> void visitMethod(T method, Consumer<T> visitor) {
        boolean isGlobal = this.isInGlobalNamespace();
        Map<CtVariable<?>, Variable> localVariables = this.localVariables;
        Map<Variable, Boolean> mutableFields = this.mutableFields;
        if (isGlobal) {
            this.localVariables = new IdentityHashMap(localVariables);
            this.mutableFields = new IdentityHashMap<Variable, Boolean>(mutableFields);
        } else {
            ModificationsScanner.scan(method, this.variablesCache).forEach(this::addGlobalVariable);
            method.getElements((Filter)new TypeFilter(CtVariableAccess.class)).stream().map(this::getVariableFromAccess).filter(Objects::nonNull).forEach(this::visitRead);
        }
        if (!this.isFirstIteration) {
            WeakReference<CtExecutable<?>> oldMethod = this.currentMethod;
            try (FunctionVisitor functionVisitor = new FunctionVisitor(this);){
                CtParameter parameter;
                Iterator iterator = method.getParameters().iterator();
                while (iterator.hasNext() && !(parameter = (CtParameter)iterator.next()).isVarArgs()) {
                    this.visitParameter(this.getVariable((CtVariable<?>)parameter), this.getExpressionIndex((CtElement)parameter));
                }
                this.currentMethod = new WeakReference<T>(method);
                visitor.accept(method);
                if (DataFlow.canUseInterproceduralAnalysis(method)) {
                    boolean unreachable = this.isUnreachable();
                    this.visitReachable();
                    long res = functionVisitor.saveInterproceduralInformation();
                    if (unreachable) {
                        this.visitUnreachable();
                    }
                    if (res != 0L) {
                        this.interproceduralInformation.put(method, this.createAnnotationFromInterproceduralInformation(res));
                    }
                }
            }
            finally {
                this.currentMethod = oldMethod;
            }
        }
        if (isGlobal) {
            this.indices.clear();
            this.values.clear();
            this.valueToTargetTypeBeforeCast.clear();
            this.invocations.clear();
            this.methodRefs.clear();
            this.breakContainers.clear();
            this.continueContainers.clear();
            this.variablesCache.clear();
            this.mutableVariables.clear();
            this.thisVariables.clear();
            this.localVariables = localVariables;
            this.mutableFields = mutableFields;
        }
    }

    public static boolean canUseInterproceduralAnalysis(@NotNull CtExecutable<?> method) {
        if (method instanceof CtConstructor) {
            return true;
        }
        if (!(method instanceof CtMethod)) {
            return false;
        }
        CtMethod ctMethod = (CtMethod)method;
        if (ctMethod.isStatic() || ctMethod.isFinal() || ctMethod.isPrivate()) {
            return true;
        }
        CtType declaringType = ctMethod.getDeclaringType();
        if (declaringType != null && declaringType.isFinal()) {
            return true;
        }
        List<String> words = Utils.splitWords(method.getSimpleName());
        if (words.isEmpty()) {
            return false;
        }
        String firstWord = words.get(0).toLowerCase().trim();
        return firstWord.equals("fail") || firstWord.equals("throw");
    }

    public static boolean canUseInterproceduralAnalysis(@NotNull CtField<?> field) {
        return DataFlow.hasImmutableValueStrict(field.getReference()) && field.getDefaultExpression() != null && LanguageUtility.isConstantExpression(field.getDefaultExpression());
    }

    @Nullable
    public CtExecutable<?> getCurrentMethod() {
        return this.currentMethod == null ? null : (CtExecutable)this.currentMethod.get();
    }

    @NotNull
    private ConditionTargets getConditionTargets(CtExpression<?> e, boolean collectImprecise, boolean unbox, CtExpression<?> src) {
        if (e == null) {
            return this.emptyTargets;
        }
        Value exp = this.getValue((CtElement)e);
        if (exp.getVariable() != null) {
            CtFieldAccess var;
            if (e instanceof CtFieldAccess && (var = (CtFieldAccess)e).getTarget() != null && var.getTarget().getType() instanceof CtArrayTypeReference && var.getTarget() instanceof CtVariableAccess && var.getVariable().getSimpleName().equals("length")) {
                Value arrayValue = this.visitVariableReference((CtVariableAccess<?>)((CtVariableRead)var.getTarget()));
                return ConditionTarget.from(ConditionTarget.from(arrayValue.getVariable(), arrayValue.getVirtualValue(), arrayValue.getType().getType(), true), this.getConditionTargets(e == src ? exp : this.getValue((CtElement)src), RulesUtils.getTypeName(src), unbox));
            }
            return this.getConditionTargets(e == src ? exp : this.getValue((CtElement)src), RulesUtils.getTypeName(src), unbox);
        }
        ConditionTargets targets = this.emptyTargets;
        if (collectImprecise && e instanceof CtBinaryOperator) {
            CtBinaryOperator binOp = (CtBinaryOperator)e;
            targets = ConditionTarget.from(this.getConditionTargets(binOp.getLeftHandOperand(), true, unbox, e), this.getConditionTargets(binOp.getRightHandOperand(), true, unbox, e), false);
        } else {
            if (e instanceof CtAssignment) {
                CtAssignment assignment = (CtAssignment)e;
                return ConditionTarget.from(this.getConditionTargets(assignment.getAssigned(), collectImprecise, unbox, e), this.getConditionTargets(assignment.getAssignment(), collectImprecise, unbox, e));
            }
            if (e instanceof CtUnaryOperator) {
                CtUnaryOperator unOp = (CtUnaryOperator)e;
                if (unOp.getKind() == UnaryOperatorKind.PREINC || unOp.getKind() == UnaryOperatorKind.PREDEC) {
                    return this.getConditionTargets(unOp.getOperand(), collectImprecise, unbox, e);
                }
            } else if (e instanceof CtAbstractInvocation) {
                MethodAnnotation node = this.getMethodAnnotation((CtAbstractInvocation)e);
                if (node != null && node.getContext() != null) {
                    return this.getSymbolicConditionTargets(e, unbox, src, this.getValue((CtElement)e), this.getConditionTargets(node.getAnnotation(), node.getContext()));
                }
                return this.emptyTargets;
            }
        }
        targets = this.getSymbolicConditionTargets(e, unbox, src, exp, targets);
        return targets;
    }

    @NotNull
    private ConditionTargets getConditionTargets(CtExpression<?> e, boolean collectImprecise, boolean unbox) {
        return this.getConditionTargets(e, collectImprecise, unbox, e);
    }

    private ConditionTargets getSymbolicConditionTargets(CtExpression<?> e, boolean unbox, CtExpression<?> src, Value exp, ConditionTargets targets) {
        Variable symbolicVariable = exp.getSymbolicValue().getSymbolicVariable(this);
        if (symbolicVariable != null) {
            if (!exp.getVirtualValue().isEmpty()) {
                symbolicVariable.setState(new VariableStateBuilder(this.getPool(), symbolicVariable.getState()).setValue(exp.getVirtualValue()).build());
            }
            targets = ConditionTarget.from(targets, this.getConditionTargets(this.visitVariableReference(RulesUtils.getTypeName(e), symbolicVariable), RulesUtils.getTypeName(src), unbox));
        }
        return targets;
    }

    @NotNull
    public Value visitCondition(@Nullable CtExpression<?> e, boolean isBooleanCondition) {
        Value cond = this.getValue((CtElement)e);
        this.visitRead(cond);
        if (this.isInCondition()) {
            if (isBooleanCondition) {
                cond = this.cast(cond, RulesUtils.getTypeName(e), "boolean");
            }
            this.getVirtualValuesForIf(e);
            this.visitCondition(cond);
        }
        return cond;
    }

    private void getVirtualValuesForIf(@Nullable CtExpression<?> e) {
        if (e == null || RulesUtils.isBoolean(e) && !this.getValue((CtElement)e).isIndeterminate()) {
            return;
        }
        if (e instanceof CtUnaryOperator) {
            CtUnaryOperator op = (CtUnaryOperator)e;
            CtExpression operand = op.getOperand();
            switch (op.getKind()) {
                case NOT: {
                    try (NegateConditionVisitor visitor = new NegateConditionVisitor(this);){
                        this.getVirtualValuesForIf(operand);
                        break;
                    }
                }
                case PREINC: 
                case PREDEC: {
                    this.getVirtualValuesForIf(operand);
                    break;
                }
                default: {
                    UnaryOperator operator = DataFlow.getUnaryOperator(op.getKind());
                    this.visitUnaryCondition(this.getConditionTargets(operand, false, false), operator);
                }
            }
        } else if (e instanceof CtBinaryOperator) {
            this.getVirtualValuesForIf((CtBinaryOperator)e);
        } else {
            this.visitBooleanCondition(this.getConditionTargets(e, false, !RulesUtils.isBoolean(e)));
        }
    }

    private void getVirtualValuesForIf(@NotNull CtBinaryOperator<?> operator) {
        CtExpression lhs = operator.getLeftHandOperand();
        CtExpression rhs = operator.getRightHandOperand();
        BinaryOperator binaryOp = DataFlow.getBinaryOperator(operator.getKind());
        if (operator.getKind() == BinaryOperatorKind.INSTANCEOF) {
            this.visitInstanceOfCondition(this.getConditionTargets(lhs, false, false));
        } else if (operator.getKind() != BinaryOperatorKind.AND && operator.getKind() != BinaryOperatorKind.OR && binaryOp != null) {
            boolean isInLoop = operator.getParent(CtStatement.class::isInstance) instanceof CtLoop;
            boolean isRhsPrimitive = RulesUtils.isPrimitive(rhs);
            boolean isLhsPrimitive = RulesUtils.isPrimitive(lhs);
            this.visitBinaryCondition(this.getConditionTargets(lhs, !isInLoop, isRhsPrimitive), this.getValue((CtElement)lhs), RulesUtils.getTypeName(lhs), isLhsPrimitive, this.getConditionTargets(rhs, !isInLoop, isLhsPrimitive), this.getValue((CtElement)rhs), RulesUtils.getTypeName(rhs), isRhsPrimitive, binaryOp);
        }
    }

    @NotNull
    public List<Pair<String, Value>> getValuesWithTargetTypesBeforeCasts(@NotNull CtElement e) {
        List result = this.valueToTargetTypeBeforeCast.get((Object)e);
        if (result.isEmpty()) {
            return List.of();
        }
        return Collections.unmodifiableList(Lists.transform((List)result, pair -> (Pair)pair.apply((typename, ptr) -> Pair.of((Object)typename, (Object)Value.fromCPtr(ptr)))));
    }

    private void addValueBeforeCast(@NotNull CtElement e, @NotNull Value value, @NotNull String targetTypename) {
        if (value.isEmpty() || "empty".equals(value.toString())) {
            return;
        }
        this.valueToTargetTypeBeforeCast.put((Object)e, (Object)Pair.of((Object)targetTypename, (Object)Value.getCPtr(value)));
    }

    @NotNull
    public Value getValue(@Nullable CtElement e) {
        return Value.fromCPtr(this.values.getOrDefault(e, 0L));
    }

    public void setValue(@NotNull CtElement exp, @NotNull Value value) {
        if (value.isEmpty()) {
            this.values.remove(exp);
        } else {
            this.values.put(exp, Value.getCPtr(value));
        }
    }

    public <T> void setValue(@NotNull CtExpression<T> exp, @NotNull Value value) {
        String src = RulesUtils.getRawTypeName(exp);
        for (CtTypeReference type : exp.getTypeCasts()) {
            if (value.isEmpty()) break;
            String dst = RulesUtils.getTypeName(type);
            if (!src.equals(dst)) {
                this.addValueBeforeCast((CtElement)exp, value, dst);
                value = this.cast(value, src, dst);
            }
            src = dst;
        }
        this.setValue((CtElement)exp, value);
    }

    @Nullable
    public static BinaryOperator getBinaryOperator(BinaryOperatorKind op) {
        switch (op) {
            case EQ: {
                return BinaryOperator.Equals;
            }
            case NE: {
                return BinaryOperator.NotEquals;
            }
            case LE: {
                return BinaryOperator.LessOrEquals;
            }
            case LT: {
                return BinaryOperator.LessThan;
            }
            case GE: {
                return BinaryOperator.GreaterOrEquals;
            }
            case GT: {
                return BinaryOperator.GreaterThan;
            }
            case SL: {
                return BinaryOperator.ShiftLeft;
            }
            case SR: 
            case USR: {
                return BinaryOperator.ShiftRight;
            }
            case AND: {
                return BinaryOperator.LogicAnd;
            }
            case OR: {
                return BinaryOperator.LogicOr;
            }
            case BITAND: {
                return BinaryOperator.BitwiseAnd;
            }
            case BITOR: {
                return BinaryOperator.BitwiseOr;
            }
            case BITXOR: {
                return BinaryOperator.BitwiseXor;
            }
            case DIV: {
                return BinaryOperator.Divide;
            }
            case PLUS: {
                return BinaryOperator.Plus;
            }
            case MINUS: {
                return BinaryOperator.Minus;
            }
            case MOD: {
                return BinaryOperator.Mod;
            }
            case MUL: {
                return BinaryOperator.Multiply;
            }
        }
        return null;
    }

    public static UnaryOperator getUnaryOperator(UnaryOperatorKind kind) {
        switch (kind) {
            case NEG: {
                return UnaryOperator.Minus;
            }
            case POS: {
                return UnaryOperator.Plus;
            }
            case COMPL: {
                return UnaryOperator.BitwiseNot;
            }
            case NOT: {
                return UnaryOperator.LogicNot;
            }
            case PREDEC: 
            case POSTDEC: {
                return UnaryOperator.Decrement;
            }
            case PREINC: 
            case POSTINC: {
                return UnaryOperator.Increment;
            }
        }
        return null;
    }

    private Variable getThisVariable(CtTargetedExpression<?, ?> var) {
        CtTypeReference type;
        if (var.getParent() instanceof CtFieldAccess) {
            CtFieldAccess field = (CtFieldAccess)var.getParent();
            type = field.getVariable().getDeclaringType();
        } else {
            type = var.getType();
        }
        if (type != null) {
            return this.getVariable(type, newVar -> newVar.setState(new VariableStateBuilder(this.getPool(), this.visitNotNull()).build()));
        }
        return null;
    }

    @NotNull
    public Value visitThisReference(CtTargetedExpression<?, ?> access) {
        Variable var = this.getThisVariable(access);
        return var == null ? Value.EMPTY : this.visitVariableReference("<unknown>", var);
    }

    @NotNull
    public Value visitVariableReference(@NotNull CtVariable<?> var) {
        if (var.hasModifier(ModifierKind.VOLATILE)) {
            return Value.EMPTY;
        }
        if (!(var instanceof CtLocalVariable || var instanceof CtParameter || var instanceof CtCatchVariable || var instanceof CtField && DataFlow.hasImmutableStateStrict(var.getReference()))) {
            this.visitImpure();
        }
        return this.visitVariableReference(RulesUtils.getRawTypeName(var), this.getVariable(var));
    }

    @NotNull
    public Value visitVariableReference(CtFieldAccess<?> fieldAccess) {
        CtField declaration = (CtField)this.variablesCache.resolve((CtVariableReference<?>)fieldAccess.getVariable());
        if (declaration != null && declaration.hasModifier(ModifierKind.VOLATILE)) {
            this.visitRead((CtElement)fieldAccess.getTarget());
            return Value.EMPTY;
        }
        if (declaration != null && (declaration.isStatic() || DataFlow.canUseInterproceduralAnalysis(declaration) || declaration instanceof CtEnumValue)) {
            return this.visitVariableReference((CtVariable<?>)declaration);
        }
        if (fieldAccess.getTarget() != null && fieldAccess.getTarget().getType() instanceof CtArrayTypeReference && fieldAccess.getVariable().getSimpleName().equals("length")) {
            return this.visitArrayLengthReference(RulesUtils.getRawTypeName(fieldAccess), this.getValue((CtElement)fieldAccess.getTarget()), fieldAccess.getVariable().getSimpleName());
        }
        return this.visitVariableFieldReference(RulesUtils.getRawTypeName(fieldAccess), this.getValue((CtElement)fieldAccess.getTarget()), fieldAccess.getVariable().getSimpleName());
    }

    @NotNull
    public Value visitVariableReference(CtVariableAccess<?> var) {
        CtVariable<?> varDecl = this.variablesCache.resolve(var.getVariable());
        if (varDecl == null) {
            return Value.EMPTY;
        }
        return this.visitVariableReference(varDecl);
    }

    public long getExpressionIndex(CtElement e) {
        return this.indices.getExpressionIndex(e);
    }

    public long getInterproceduralExpressionIndex(CtElement e) {
        return this.interproceduralIndices.getExpressionIndex(e);
    }

    @Nullable
    public CtElement getExpressionByIndex(long idx) {
        return this.interproceduralIndices.getExpressionByIndex(idx);
    }

    private static boolean isCppLikeStatement(CtElement e) {
        return e instanceof CtIf || e instanceof CtLoop || e instanceof CtBlock || e instanceof CtSwitch || e instanceof CtTry || e instanceof CtSynchronized || e instanceof CtTypeMember;
    }

    @Nullable
    public CtElement getParentStatement(@Nullable CtElement e) {
        if (e == null || e instanceof CtBlock || e instanceof CtSwitch) {
            return e;
        }
        if (DataFlow.isCppLikeStatement(e)) {
            return e.getParent(DataFlow::isCppLikeStatement);
        }
        return this.getParentStatement(e.getParent(DataFlow::isCppLikeStatement));
    }

    @Override
    public long getParentStatement(long idx) {
        return this.getExpressionIndex(this.getParentStatement(this.getExpressionByIndex(idx)));
    }

    @Override
    public boolean isRestrict(long st1, long st2) {
        CtElement a = this.getExpressionByIndex(st1);
        CtElement b = this.getExpressionByIndex(st2);
        return a == null || b == null || !RulesUtils.equals(a, b);
    }

    @Override
    public void clear() {
        this.indices.clear();
        this.interproceduralIndices.clear();
        this.values.clear();
        this.valueToTargetTypeBeforeCast.clear();
        this.invocations.clear();
        this.methodRefs.clear();
        this.breakContainers.clear();
        this.continueContainers.clear();
        this.thisVariables.clear();
        this.localVariables.clear();
        this.mutableVariables.clear();
        this.mutableFields.clear();
        this.modifiedPrivateFields.clear();
        this.variablesCache.clear();
        this.interproceduralInformation.forEach((k, v) -> v.delete());
        this.interproceduralInformation.clear();
        super.clear();
    }

    public void putContinue(@NotNull CtLoop loop, @NotNull ValuesContainer container) {
        this.continueContainers.put((CtStatement)loop, container);
    }

    public void removeContinue(@NotNull CtLoop loop) {
        this.continueContainers.remove(loop);
    }

    public void visitBreak(@NotNull CtBreak breakStatement) {
        if (breakStatement.getLabelledStatement() == null) {
            this.visitBreak();
        } else {
            this.visitGoto(this.breakContainers.computeIfAbsent(breakStatement.getLabelledStatement(), st -> breakStatement.getLabel() + ":" + this.breakContainers.size()));
        }
    }

    public void visitContinue(@NotNull CtContinue continueStatement) {
        if (continueStatement.getLabelledStatement() == null) {
            this.visitContinue();
        } else {
            ValuesContainer container = this.continueContainers.get(continueStatement.getLabelledStatement());
            if (container != null) {
                this.visitContinue(container);
            }
        }
    }

    public void mergeBreak(CtElement e) {
        String container;
        if (e instanceof CtStatement && (container = this.breakContainers.get(e)) != null) {
            this.visitLabel(container);
        }
    }

    @Nullable
    public Annotation getTypeAnnotation(String qualifiedName) {
        return this.typesCache.getAnnotation(qualifiedName);
    }

    @Nullable
    public Annotation getTypeAnnotation(CtTypedElement<?> element) {
        return this.getTypeAnnotation(RulesUtils.getRawTypeName(element));
    }

    @Nullable
    public Annotation getTypeAnnotation(CtExpression<?> element) {
        return this.getTypeAnnotation(RulesUtils.getTypeName(element));
    }

    @NotNull
    public Annotation getSafeTypeAnnotation(CtExpression<?> element) {
        Annotation res = this.getTypeAnnotation(element);
        return res == null ? this.typesCache.getEmptyAnnotation() : res;
    }

    @NotNull
    private <T> JavaContext getContext(CtAbstractInvocation<T> invocation) {
        JavaContext context = new JavaContext(this);
        context.setArgumentsNumber(1 + invocation.getArguments().size());
        if (invocation instanceof CtInvocation) {
            CtExpression self = ((CtInvocation)invocation).getTarget();
            context.setArgument(0, RulesUtils.getTypeName(self), this.getValue((CtElement)self), this.getExpressionIndex((CtElement)self), this.getInterproceduralExpressionIndex((CtElement)self));
            context.setReturnType(RulesUtils.getTypeName(invocation.getExecutable().getType()));
        } else if (invocation instanceof CtConstructorCall) {
            context.setReturnType(Type.Pointer);
        }
        if (!(invocation instanceof CtTargetedExpression)) {
            context.noThisArgument();
        } else {
            CtExpression target = ((CtTargetedExpression)invocation).getTarget();
            if (target == null || target instanceof CtTypeAccess) {
                context.noThisArgument();
            }
        }
        int i = 1;
        for (CtExpression arg : invocation.getArguments()) {
            if (RulesUtils.isSubtypeOf(arg, "java.lang.Throwable")) {
                context.setArgument(i, "java.lang.Throwable", this.getValue((CtElement)arg), this.getExpressionIndex((CtElement)arg), this.getInterproceduralExpressionIndex((CtElement)arg));
            } else {
                context.setArgument(i, RulesUtils.getTypeName(arg), this.getValue((CtElement)arg), this.getExpressionIndex((CtElement)arg), this.getInterproceduralExpressionIndex((CtElement)arg));
            }
            ++i;
        }
        return context;
    }

    @Nullable
    public <T> MethodAnnotation getMethodAnnotation(@NotNull CtAbstractInvocation<T> inv) {
        return this.invocations.get(inv);
    }

    @Nullable
    public <T, E extends CtExpression<?>> MethodAnnotation getMethodAnnotation(@NotNull CtExecutableReferenceExpression<T, E> ref) {
        return this.methodRefs.get(ref);
    }

    @NotNull
    public VariablesCache getVariablesCache() {
        return this.variablesCache;
    }

    @NotNull
    public TypesCache getTypesCache() {
        return this.typesCache;
    }

    @Nullable
    private <T> MethodAnnotation setMethodAnnotation(CtAbstractInvocation<T> inv, CtTypeReference<?> selfType, String name) {
        if (selfType == null) {
            return null;
        }
        Annotation parent = this.getTypeAnnotation(selfType.getQualifiedName());
        if (parent == null) {
            return null;
        }
        AnnotationsQueryResult query = parent.findMultiple(name, inv.getArguments().size());
        if (query.isEmpty()) {
            return null;
        }
        JavaContext context = this.getContext(inv);
        Annotation annotation = parent.find(context, query);
        if (annotation == null) {
            context.delete();
            return null;
        }
        MethodAnnotation res = new MethodAnnotation(context, annotation, this.visitFunctionCall(context, annotation));
        this.invocations.put((CtElement)inv, res);
        return res;
    }

    @Nullable
    public <T> MethodAnnotation setMethodAnnotation(CtAbstractInvocation<T> inv) {
        CtExecutableReference executable = inv.getExecutable();
        if (executable == null) {
            return null;
        }
        if (RulesUtils.getQualifiedName(inv).startsWith("com.sun.jna")) {
            return null;
        }
        logger.trace("{} -> setMethodAnnotation: {}", (Object)Thread.currentThread().getName(), (Object)RulesUtils.getQualifiedName(inv));
        long start = System.currentTimeMillis();
        MethodAnnotation res = this.findManualAnnotation(inv);
        if (res == null) {
            res = this.findInferedAnnotation(inv, executable);
        }
        Benchmark.instance().step("Static analysis: annotations", System.currentTimeMillis() - start);
        return res;
    }

    @Nullable
    public <T, E extends CtExpression<?>> MethodAnnotation setMethodAnnotation(CtExecutableReferenceExpression<T, E> methodReference) {
        CtExecutableReference executable = methodReference.getExecutable();
        if (executable == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        MethodAnnotation res = this.findManualAnnotation(methodReference);
        Benchmark.instance().step("Static analysis: annotations (method reference)", System.currentTimeMillis() - start);
        return res;
    }

    @Nullable
    private <T, E extends CtExpression<?>> MethodAnnotation setMethodAnnotation(CtExecutableReferenceExpression<T, E> methodReference, CtTypeReference<?> selfType, String name) {
        CtExecutableReference executable = methodReference.getExecutable();
        if (executable == null) {
            return null;
        }
        Annotation parent = this.getTypeAnnotation(selfType.getQualifiedName());
        if (parent == null) {
            return null;
        }
        AnnotationsQueryResult query = parent.findMultiple(name, executable.getParameters().size());
        if (query.isEmpty()) {
            return null;
        }
        JavaContext context = new JavaContext(this);
        context.setArgumentsNumber(1 + executable.getParameters().size());
        CtExpression target = methodReference.getTarget();
        context.setArgument(0, RulesUtils.getTypeName(target), this.getValue((CtElement)target), this.getExpressionIndex((CtElement)target), this.getInterproceduralExpressionIndex((CtElement)target));
        context.setReturnType(RulesUtils.getTypeName(methodReference.getExecutable().getType()));
        int i = 1;
        for (CtTypeReference typeReference : methodReference.getExecutable().getParameters()) {
            context.setArgument(i, RulesUtils.getTypeName(typeReference), this.getValue(null), this.getExpressionIndex(null), this.getInterproceduralExpressionIndex(null));
            ++i;
        }
        Annotation annotation = parent.find(context, query);
        if (annotation == null) {
            context.delete();
            return null;
        }
        MethodAnnotation res = new MethodAnnotation(context, annotation, Value.EMPTY);
        this.methodRefs.put((CtElement)methodReference, res);
        return res;
    }

    private <T> MethodAnnotation findInferedAnnotation(CtAbstractInvocation<T> inv, CtExecutableReference<?> executable) {
        try {
            AnnotationHolder annotationHolder;
            CtExecutable declaration = executable.getExecutableDeclaration();
            if (declaration != null && (annotationHolder = this.interproceduralInformation.get(declaration)) != null) {
                Annotation annotation = annotationHolder.getAnnotation();
                JavaContext context = this.getContext(inv);
                MethodAnnotation res = new MethodAnnotation(context, annotation, this.visitFunctionCall(context, annotation));
                this.invocations.put((CtElement)inv, res);
                return res;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private static String getMethodSignature(CtAbstractInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        StringBuilder signature = new StringBuilder();
        signature.append(executable.getDeclaringType().getQualifiedName());
        signature.append('.');
        signature.append(executable.isConstructor() ? "new" : executable.getSimpleName());
        signature.append('(');
        if (executable.getParameters().size() == invocation.getArguments().size()) {
            for (int i = 0; i < executable.getParameters().size(); ++i) {
                signature.append(executable.getParameters().get(i) instanceof CtTypeParameterReference ? "?" : ((CtTypeReference)executable.getParameters().get(i)).getSimpleName());
                signature.append(" | ");
                CtExpression argument = (CtExpression)invocation.getArguments().get(i);
                CtTypeReference ctTypeReference = argument.getType();
                if (ctTypeReference == null) {
                    return null;
                }
                if (ctTypeReference.isPrimitive()) {
                    if (RulesUtils.isIntegerType(argument)) {
                        signature.append('i');
                    } else if (RulesUtils.isRealType(argument)) {
                        signature.append('r');
                    } else if (ctTypeReference.getSimpleName().equals("boolean")) {
                        signature.append('b');
                    } else {
                        signature.append('?');
                    }
                } else {
                    signature.append('?');
                }
                signature.append(i + 1 != executable.getParameters().size() ? ", " : "");
            }
        }
        signature.append(')');
        return signature.toString();
    }

    @Nullable
    private MethodAnnotation findManualAnnotation(CtAbstractInvocation<?> invocation) {
        String name;
        CtExecutableReference executable = invocation.getExecutable();
        String string = name = invocation instanceof CtConstructorCall ? "new" : executable.getSimpleName();
        if (!this.nameAnnotations.contains(name)) {
            return null;
        }
        CtTypeReference declaringType = executable.getDeclaringType();
        if (declaringType == null || declaringType.getQualifiedName().endsWith("$") || declaringType.getQualifiedName().contains("$.")) {
            return null;
        }
        String signature = DataFlow.getMethodSignature(invocation);
        if (signature == null) {
            return null;
        }
        CtTypeReference cacheType = this.cacheAnnotations.getOrDefault(signature, null);
        if (cacheType != null) {
            if (cacheType.equals((Object)declaringType.getFactory().Type().VOID)) {
                return null;
            }
            return this.setMethodAnnotation(invocation, cacheType, name);
        }
        Iterable allInheritedTypes = Iterables.concat(Collections.singleton(declaringType), this.typesCache.getAllExtendedClasses(declaringType), this.typesCache.getAllImplementedInterfaces(declaringType), Collections.singleton(declaringType.getFactory().Type().OBJECT));
        MethodAnnotation res = null;
        for (CtTypeReference type : allInheritedTypes) {
            boolean isOverriddenByCurrent;
            CtType declaration;
            if (type != declaringType && !executable.isConstructor() && ((declaration = type.getTypeDeclaration()) == null || !(isOverriddenByCurrent = declaration.getMethodsByName(executable.getSimpleName()).stream().anyMatch(it -> executable.isOverriding(it.getReference())))) || (res = this.setMethodAnnotation(invocation, type, name)) == null) continue;
            declaringType = type;
            break;
        }
        if (res == null) {
            this.cacheAnnotations.putIfAbsent(signature, declaringType.getFactory().Type().VOID);
        } else {
            this.cacheAnnotations.putIfAbsent(signature, declaringType);
        }
        return res;
    }

    @Nullable
    private <T, E extends CtExpression<?>> MethodAnnotation findManualAnnotation(CtExecutableReferenceExpression<T, E> methodReference) {
        String selfName;
        if (this.getValue((CtElement)methodReference.getTarget()).getVariable() == null) {
            return null;
        }
        MethodAnnotation res = null;
        CtExecutableReference executableReference = methodReference.getExecutable();
        String name = executableReference.getSimpleName();
        if (!this.nameAnnotations.contains(name)) {
            return null;
        }
        CtTypeReference<?> selfType = executableReference.getDeclaringType();
        while (res == null && selfType != null && !(selfName = selfType.getQualifiedName()).endsWith("$") && !selfName.contains("$.")) {
            res = this.setMethodAnnotation(methodReference, selfType, name);
            if (res == null) {
                Function<Collection, MethodAnnotation> findAnnotation = inheritors -> {
                    for (CtTypeReference inheritor : inheritors) {
                        MethodAnnotation methodAnnotation = this.setMethodAnnotation(methodReference, inheritor, name);
                        if (methodAnnotation == null) continue;
                        return methodAnnotation;
                    }
                    return null;
                };
                List<CtTypeReference<?>> inheritors2 = new ArrayList();
                inheritors2.add(selfType);
                inheritors2.addAll(this.typesCache.getAllExtendedClasses(selfType));
                res = findAnnotation.apply(inheritors2);
                if (res != null) {
                    return res;
                }
                inheritors2 = this.typesCache.getAllImplementedInterfaces(selfType);
                res = findAnnotation.apply(inheritors2);
                if (res != null) {
                    return res;
                }
            }
            selfType = this.typesCache.getSuperclass(selfType);
        }
        return res;
    }

    public static boolean hasImmutableValueStrict(CtVariableReference<?> variableReference) {
        return (Boolean)variableReference.getValueByRole(CtRole.IS_FINAL);
    }

    public boolean hasImmutableValue(CtVariableReference<?> variableReference) {
        if (DataFlow.hasImmutableValueStrict(variableReference)) {
            return true;
        }
        CtVariable variable = variableReference.getDeclaration();
        if (!(variable instanceof CtField)) {
            return false;
        }
        return !this.canBeModified((CtField)variable);
    }

    public static boolean hasImmutableStateStrict(CtVariableReference<?> variableReference) {
        if (!DataFlow.hasImmutableValueStrict(variableReference)) {
            return false;
        }
        CtTypeReference type = variableReference.getType();
        if (type.isPrimitive()) {
            return true;
        }
        switch (type.getQualifiedName()) {
            case "java.lang.String": 
            case "java.lang.Boolean": 
            case "java.lang.Byte": 
            case "java.lang.Character": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return true;
            }
        }
        return false;
    }

    public boolean hasImmutableState(CtVariableReference<?> variableReference) {
        if (DataFlow.hasImmutableStateStrict(variableReference)) {
            return true;
        }
        CtVariable variable = variableReference.getDeclaration();
        if (!(variable instanceof CtField)) {
            return false;
        }
        return !this.canBeModified((CtField)variable);
    }

    private boolean canBeModified(CtField<?> field) {
        if (!field.isPrivate() || field.hasModifier(ModifierKind.VOLATILE)) {
            return true;
        }
        Set fields = this.modifiedPrivateFields.computeIfAbsent(field.getDeclaringType(), this::getModifiedFields);
        return fields.contains(field);
    }

    public void updateStatus() {
        this.isUnreachable = super.isUnreachable();
        this.isFirstIteration = super.isInFirstIteration();
    }

    @Override
    public boolean isUnreachable() {
        return this.isUnreachable;
    }

    public PvsStudioAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public boolean isInFirstIteration() {
        return this.isFirstIteration;
    }

    private void removeGlobalVariable(Variable var, boolean onlyState) {
        this.visitRead(var);
        this.deleteValue(var, onlyState);
    }

    private void removeGlobalVariable(Variable var) {
        this.visitRead(var);
        this.deleteValue(var, false);
    }

    public void removeGlobalVariables() {
        this.mutableVariables.forEach(this::removeGlobalVariable);
        this.mutableFields.forEach(this::removeGlobalVariable);
    }

    public void removeThisValue() {
        this.thisVariables.values().forEach(this::removeGlobalVariable);
    }

    @Nullable
    private Variable getVariableFromAccess(CtElement varRef) {
        if (varRef instanceof CtFieldAccess) {
            CtFieldAccess access = (CtFieldAccess)varRef;
            if (access.getTarget() instanceof CtThisAccess) {
                Variable var = this.getThisVariable((CtTargetedExpression<?, ?>)((CtThisAccess)access.getTarget()));
                if (var != null) {
                    var = this.getVariableField(var, access.getVariable().getSimpleName());
                }
                return var;
            }
        } else if (varRef instanceof CtVariableAccess) {
            CtVariable<?> varDecl = this.variablesCache.resolve(((CtVariableAccess)varRef).getVariable());
            if (varDecl == null) {
                return null;
            }
            return this.getVariable(varDecl);
        }
        return null;
    }

    public void visitDereference(CtTypedElement<?> e) {
        if (!RulesUtils.isPrimitive(e)) {
            this.visitDereference(this.getValue((CtElement)e), this.getInterproceduralExpressionIndex((CtElement)e));
        }
    }

    public void visitRead(CtElement e) {
        Value value = this.getValue(e);
        if (!value.isEmpty()) {
            this.visitRead(value);
        }
    }

    public void visitGlobalsRead() {
        this.thisVariables.values().forEach(this::visitRead);
        this.mutableFields.keySet().forEach(this::visitRead);
        this.mutableVariables.keySet().forEach(this::visitRead);
        if (this.getCurrentMethod() != null) {
            for (CtParameter parameter : this.getCurrentMethod().getParameters()) {
                this.visitRead(this.getVariable((CtVariable<?>)parameter));
            }
            if (this.getCurrentMethod() instanceof CtAnonymousExecutable) {
                ((CtAnonymousExecutable)this.getCurrentMethod()).getDeclaringType().getFields().stream().filter(CtModifiable::isFinal).filter(CtModifiable::isStatic).map(this::findVariable).filter(Objects::nonNull).forEach(this::visitRead);
            }
        }
    }

    @Nullable
    public Variable findVariable(CtVariable<?> variable) {
        return this.localVariables.get(variable);
    }

    public ConstraintSolver constraints() {
        return this.constraintSolver;
    }

    public void setCacheAnnotations(Map<String, CtTypeReference<?>> annotationCache) {
        this.cacheAnnotations = annotationCache;
    }
}

