/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.ListVirtualValue;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.core.OptionalStringVirtualValue;
import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Tribool;

public class VirtualValue {
    private final long swigCPtr;
    public static final VirtualValue EMPTY = new VirtualValue(0L);

    protected VirtualValue(long cPtr) {
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(VirtualValue p) {
        return p.swigCPtr;
    }

    public static VirtualValue fromCPtr(long address) {
        return address == 0L ? EMPTY : new VirtualValue(address);
    }

    public boolean isEmpty() {
        return this.swigCPtr == 0L;
    }

    public boolean isIndeterminate() {
        return CoreJNI.VirtualValue_isIndeterminate(this.swigCPtr);
    }

    public Tribool toBool() {
        long cPtr = CoreJNI.VirtualValue_toBool(this.swigCPtr);
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public String toString() {
        return CoreJNI.VirtualValue_toString(this.swigCPtr);
    }

    public OptionalInt toInt() {
        return new OptionalInt(CoreJNI.VirtualValue_toInt(this.swigCPtr), true);
    }

    public OptionalLong toLong() {
        return new OptionalLong(CoreJNI.VirtualValue_toLong(this.swigCPtr), true);
    }

    public OptionalInt128 toNumber() {
        return new OptionalInt128(CoreJNI.VirtualValue_toNumber(this.swigCPtr), true);
    }

    public PointerVirtualValue toPointer() {
        long cPtr = CoreJNI.VirtualValue_toPointer(this.swigCPtr);
        return cPtr == 0L ? null : new PointerVirtualValue(cPtr);
    }

    public IntegerVirtualValue toInteger() {
        long cPtr = CoreJNI.VirtualValue_toInteger(this.swigCPtr);
        return cPtr == 0L ? null : new IntegerVirtualValue(cPtr);
    }

    public ListVirtualValue toContainer() {
        long cPtr = CoreJNI.VirtualValue_toContainer(this.swigCPtr);
        return new ListVirtualValue(cPtr);
    }

    public Tribool equals(VirtualValue other) {
        long cPtr = CoreJNI.VirtualValue_equals(this.swigCPtr, VirtualValue.getCPtr(other));
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public OptionalStringVirtualValue getString() {
        return new OptionalStringVirtualValue(CoreJNI.VirtualValue_getString(this.swigCPtr), true);
    }

    public OptionalStringView getSingletonString() {
        return new OptionalStringView(CoreJNI.VirtualValue_getSingletonString(this.swigCPtr), true);
    }

    public VirtualValue union(Pool pool, VirtualValue other) {
        long cPtr = CoreJNI.VirtualValue_union(this.swigCPtr, Pool.getCPtr(pool), pool, VirtualValue.getCPtr(other));
        return cPtr == 0L ? EMPTY : new VirtualValue(cPtr);
    }

    public VirtualValue intersection(Pool pool, VirtualValue other) {
        long cPtr = CoreJNI.VirtualValue_intersection(this.swigCPtr, Pool.getCPtr(pool), pool, VirtualValue.getCPtr(other));
        return cPtr == 0L ? EMPTY : new VirtualValue(cPtr);
    }

    public VirtualValue clone(Pool pool) {
        long cPtr = CoreJNI.VirtualValue_clone(this.swigCPtr, Pool.getCPtr(pool), pool);
        return cPtr == 0L ? EMPTY : new VirtualValue(cPtr);
    }
}

