/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.VariableModificationTag;
import com.pvsstudio.core.VariableState;
import java.math.BigInteger;

public class Variable {
    private final long swigCPtr;

    protected Variable(long cPtr) {
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Variable p) {
        return p == null ? 0L : p.swigCPtr;
    }

    public boolean equals(Object o) {
        return o instanceof Variable && ((Variable)o).swigCPtr == this.swigCPtr;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public String getName() {
        return CoreJNI.Variable_name_get(this.swigCPtr);
    }

    public void setUserData(long value) {
        CoreJNI.Variable_userData_set(this.swigCPtr, value);
    }

    public long getUserData() {
        return CoreJNI.Variable_userData_get(this.swigCPtr);
    }

    public void setParent(Variable value) {
        CoreJNI.Variable_parent_set(this.swigCPtr, Variable.getCPtr(value));
    }

    public Variable getParent() {
        long cPtr = CoreJNI.Variable_parent_get(this.swigCPtr);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public void setState(VariableState value) {
        CoreJNI.Variable_state_set(this.swigCPtr, VariableState.getCPtr(value));
    }

    public VariableState getState() {
        long cPtr = CoreJNI.Variable_state_get(this.swigCPtr);
        return cPtr == 0L ? null : new VariableState(cPtr);
    }

    public void setGlobal(boolean value) {
        CoreJNI.Variable_Global_set(this.swigCPtr, value);
    }

    public boolean getGlobal() {
        return CoreJNI.Variable_Global_get(this.swigCPtr);
    }

    public void setConst(boolean value) {
        CoreJNI.Variable_Const_set(this.swigCPtr, value);
    }

    public boolean getConst() {
        return CoreJNI.Variable_Const_get(this.swigCPtr);
    }

    public String toString() {
        return CoreJNI.Variable_toString(this.swigCPtr);
    }

    public String getFullName() {
        return CoreJNI.Variable_getFullName(this.swigCPtr);
    }

    public Variable findMember(String arg0) {
        long cPtr = CoreJNI.Variable_findMember(this.swigCPtr, arg0);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public Variable findArrayElement(BigInteger arg0) {
        long cPtr = CoreJNI.Variable_findArrayElement(this.swigCPtr, arg0);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public Variable firstElement() {
        long cPtr = CoreJNI.Variable_firstElement(this.swigCPtr);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public void setMember(Pool pool, String arg1, Variable var) {
        CoreJNI.Variable_setMember(this.swigCPtr, Pool.getCPtr(pool), pool, arg1, Variable.getCPtr(var), var);
    }

    public void setArrayElement(Pool pool, BigInteger arg1, Variable var) {
        CoreJNI.Variable_setArrayElement(this.swigCPtr, Pool.getCPtr(pool), pool, arg1, Variable.getCPtr(var), var);
    }

    public boolean changedSince(VariableState prevState) {
        return CoreJNI.Variable_changedSince(this.swigCPtr, VariableState.getCPtr(prevState));
    }

    public Pool getPool(Pool pool) {
        long cPtr = CoreJNI.Variable_getPool(this.swigCPtr, Pool.getCPtr(pool), pool);
        return new Pool(cPtr);
    }

    public Value getValue() {
        long cPtr = CoreJNI.Variable_getValue(this.swigCPtr);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public VariableModificationTag newStateTag() {
        return new VariableModificationTag(CoreJNI.Variable_newStateTag(this.swigCPtr), true);
    }
}

