/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.Equality;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.SymbolicValue;
import com.pvsstudio.core.Tribool;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.ValueSource;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VirtualValue;

public class Value {
    private final long swigCPtr;
    public static final Value EMPTY = new Value(0L);

    protected Value(long cPtr) {
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Value p) {
        return p.swigCPtr;
    }

    public static Value fromCPtr(long address) {
        return address == 0L ? EMPTY : new Value(address);
    }

    public boolean isEmpty() {
        return this.swigCPtr == 0L;
    }

    public Value union(Pool pool, Value other) {
        long cPtr = CoreJNI.Value_union(this.swigCPtr, Pool.getCPtr(pool), pool, Value.getCPtr(other));
        return cPtr == 0L ? EMPTY : new Value(cPtr);
    }

    public VirtualValue getVirtualValue() {
        long cPtr = CoreJNI.Value_getVirtualValue(this.swigCPtr);
        return cPtr == 0L ? VirtualValue.EMPTY : new VirtualValue(cPtr);
    }

    public SymbolicValue getSymbolicValue() {
        long cPtr = CoreJNI.Value_getSymbolicValue(this.swigCPtr);
        return cPtr == 0L ? SymbolicValue.EMPTY : new SymbolicValue(cPtr);
    }

    public ValueSource getSource() {
        return ValueSource.swigToEnum(CoreJNI.Value_getSource(this.swigCPtr));
    }

    public TypeInformation getType() {
        return new TypeInformation(CoreJNI.Value_getType(this.swigCPtr), true);
    }

    public Variable getVariable() {
        long cPtr = CoreJNI.Value_getVariable(this.swigCPtr);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public long getDefinition() {
        return CoreJNI.Value_getDefinition(this.swigCPtr);
    }

    public OptionalInt toInt() {
        return new OptionalInt(CoreJNI.Value_toInt(this.swigCPtr), true);
    }

    public OptionalLong toLong() {
        return new OptionalLong(CoreJNI.Value_toLong(this.swigCPtr), true);
    }

    public OptionalInt128 toNumber() {
        return new OptionalInt128(CoreJNI.Value_toNumber(this.swigCPtr), true);
    }

    public IntegerVirtualValue toInteger() {
        long cPtr = CoreJNI.Value_toInteger(this.swigCPtr);
        return cPtr == 0L ? null : new IntegerVirtualValue(cPtr);
    }

    public PointerVirtualValue toPointer() {
        long cPtr = CoreJNI.Value_toPointer(this.swigCPtr);
        return cPtr == 0L ? null : new PointerVirtualValue(cPtr);
    }

    public Tribool toBool() {
        long cPtr = CoreJNI.Value_toBool(this.swigCPtr);
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public boolean isIndeterminate() {
        return CoreJNI.Value_isIndeterminate(this.swigCPtr);
    }

    public boolean isTrue() {
        return CoreJNI.Value_isTrue(this.swigCPtr);
    }

    public boolean isFalse() {
        return CoreJNI.Value_isFalse(this.swigCPtr);
    }

    public boolean isUninitialized() {
        return CoreJNI.Value_isUninitialized(this.swigCPtr);
    }

    public boolean isNullPointer() {
        return CoreJNI.Value_isNullPointer(this.swigCPtr);
    }

    public boolean isPotentiallyUninitialized() {
        return CoreJNI.Value_isPotentiallyUninitialized(this.swigCPtr);
    }

    public boolean mayBeUninitialized() {
        return CoreJNI.Value_mayBeUninitialized(this.swigCPtr);
    }

    public boolean isFromLoop() {
        return CoreJNI.Value_isFromLoop(this.swigCPtr);
    }

    public boolean isFromCondition() {
        return CoreJNI.Value_isFromCondition(this.swigCPtr);
    }

    public boolean equals(Value other, Equality equality) {
        return CoreJNI.Value_equals__SWIG_0(this.swigCPtr, Value.getCPtr(other), equality.swigValue());
    }

    public boolean equals(Value other) {
        return CoreJNI.Value_equals__SWIG_1(this.swigCPtr, Value.getCPtr(other));
    }

    public Value clone(Pool pool) {
        long cPtr = CoreJNI.Value_clone(this.swigCPtr, Pool.getCPtr(pool), pool);
        return cPtr == 0L ? EMPTY : new Value(cPtr);
    }

    public String toString() {
        return CoreJNI.Value_toString(this.swigCPtr);
    }
}

