/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.Analyzer;
import com.pvsstudio.core.ArgumentsArray;
import com.pvsstudio.core.BasicAnnotation;
import com.pvsstudio.core.BinaryOperator;
import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.Equality;
import com.pvsstudio.core.ModificationFlags;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.Tribool;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.UnaryOperator;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VariableState;
import com.pvsstudio.core.VirtualValue;

public class SymbolicValue {
    private final long swigCPtr;
    public static final SymbolicValue EMPTY = new SymbolicValue(0L);

    protected SymbolicValue(long cPtr) {
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(SymbolicValue p) {
        return p.swigCPtr;
    }

    public static SymbolicValue fromCPtr(long address) {
        return address == 0L ? EMPTY : new SymbolicValue(address);
    }

    public boolean isEmpty() {
        return this.swigCPtr == 0L;
    }

    public Variable getSymbolicVariable(Analyzer analyzer) {
        long cPtr = CoreJNI.SymbolicValue_getSymbolicVariable(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public Variable findSymbolicVariable(Analyzer analyzer) {
        long cPtr = CoreJNI.SymbolicValue_findSymbolicVariable(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public Variable getVariable() {
        long cPtr = CoreJNI.SymbolicValue_getVariable(this.swigCPtr);
        return cPtr == 0L ? null : new Variable(cPtr);
    }

    public boolean isUnknown() {
        return CoreJNI.SymbolicValue_isUnknown(this.swigCPtr);
    }

    public boolean isConstant() {
        return CoreJNI.SymbolicValue_isConstant(this.swigCPtr);
    }

    public boolean hasVariables() {
        return CoreJNI.SymbolicValue_hasVariables(this.swigCPtr);
    }

    public long getDefinition() {
        return CoreJNI.SymbolicValue_getDefinition(this.swigCPtr);
    }

    public TypeInformation getType() {
        return new TypeInformation(CoreJNI.SymbolicValue_getType(this.swigCPtr), true);
    }

    public void write(Analyzer analyzer, VariableState state) {
        CoreJNI.SymbolicValue_write(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer, VariableState.getCPtr(state), state);
    }

    public void modify(Analyzer analyzer, ModificationFlags flags) {
        CoreJNI.SymbolicValue_modify(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer, ModificationFlags.getCPtr(flags), flags);
    }

    public static SymbolicValue createArrayAccess(Pool pool, TypeInformation type, Variable var, SymbolicValue array, SymbolicValue index) {
        long cPtr = CoreJNI.SymbolicValue_createArrayAccess(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, Variable.getCPtr(var), SymbolicValue.getCPtr(array), SymbolicValue.getCPtr(index));
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createMemberAccess(Pool pool, TypeInformation type, Variable var, SymbolicValue object, String member) {
        long cPtr = CoreJNI.SymbolicValue_createMemberAccess(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, Variable.getCPtr(var), SymbolicValue.getCPtr(object), member);
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createBinaryExpression(Pool pool, TypeInformation type, SymbolicValue left, SymbolicValue right, BinaryOperator op) {
        long cPtr = CoreJNI.SymbolicValue_createBinaryExpression(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, SymbolicValue.getCPtr(left), SymbolicValue.getCPtr(right), op.swigValue());
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createUnaryExpression(Pool pool, TypeInformation type, SymbolicValue operand, UnaryOperator op) {
        long cPtr = CoreJNI.SymbolicValue_createUnaryExpression(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, SymbolicValue.getCPtr(operand), op.swigValue());
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createPostfixExpression(Pool pool, TypeInformation type, SymbolicValue operand, UnaryOperator op) {
        long cPtr = CoreJNI.SymbolicValue_createPostfixExpression(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, SymbolicValue.getCPtr(operand), op.swigValue());
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createVariableReference(Pool pool, TypeInformation type, Variable var) {
        long cPtr = CoreJNI.SymbolicValue_createVariableReference(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(type), type, Variable.getCPtr(var), var);
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createCast(Pool pool, TypeInformation dest, SymbolicValue source, VirtualValue toConv) {
        long cPtr = CoreJNI.SymbolicValue_createCast__SWIG_0(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(dest), dest, SymbolicValue.getCPtr(source), VirtualValue.getCPtr(toConv));
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createCast(Pool pool, TypeInformation dest, SymbolicValue source) {
        long cPtr = CoreJNI.SymbolicValue_createCast__SWIG_1(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(dest), dest, SymbolicValue.getCPtr(source));
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createUnknownValue(Pool pool, TypeInformation dest, VirtualValue source) {
        long cPtr = CoreJNI.SymbolicValue_createUnknownValue(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(dest), dest, VirtualValue.getCPtr(source));
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static SymbolicValue createFunction(Pool pool, TypeInformation res, BasicAnnotation annotation, ArgumentsArray arguments) {
        long cPtr = CoreJNI.SymbolicValue_createFunction(Pool.getCPtr(pool), pool, TypeInformation.getCPtr(res), res, BasicAnnotation.getCPtr(annotation), annotation, ArgumentsArray.getCPtr(arguments), arguments);
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public static Result inBoundsConstraint(Analyzer analyzer, Value exp, Value index) {
        return Result.swigToEnum(CoreJNI.SymbolicValue_inBoundsConstraint(Analyzer.getCPtr(analyzer), analyzer, Value.getCPtr(exp), exp, Value.getCPtr(index), index));
    }

    public boolean equals(SymbolicValue other, Equality eq) {
        return CoreJNI.SymbolicValue_equals__SWIG_0(this.swigCPtr, SymbolicValue.getCPtr(other), eq.swigValue());
    }

    public boolean equals(SymbolicValue other) {
        return CoreJNI.SymbolicValue_equals__SWIG_1(this.swigCPtr, SymbolicValue.getCPtr(other));
    }

    public SymbolicValue reevaluateReferences(Pool pool) {
        long cPtr = CoreJNI.SymbolicValue_reevaluateReferences(this.swigCPtr, Pool.getCPtr(pool), pool);
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public String toString() {
        return CoreJNI.SymbolicValue_toString(this.swigCPtr);
    }

    public static Tribool checkRelation(Analyzer analyzer, SymbolicValue left, BinaryOperator op, SymbolicValue right) {
        long cPtr = CoreJNI.SymbolicValue_checkRelation(Analyzer.getCPtr(analyzer), analyzer, SymbolicValue.getCPtr(left), op.swigValue(), SymbolicValue.getCPtr(right));
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public Tribool canBeEqualTo(Analyzer analyzer, SymbolicValue val) {
        long cPtr = CoreJNI.SymbolicValue_canBeEqualTo(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer, SymbolicValue.getCPtr(val));
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public SymbolicValue clone(Pool pool) {
        long cPtr = CoreJNI.SymbolicValue_clone(this.swigCPtr, Pool.getCPtr(pool), pool);
        return cPtr == 0L ? EMPTY : new SymbolicValue(cPtr);
    }

    public VirtualValue visit(Analyzer analyzer) {
        long cPtr = CoreJNI.SymbolicValue_visit(this.swigCPtr, Analyzer.getCPtr(analyzer), analyzer);
        return cPtr == 0L ? VirtualValue.EMPTY : new VirtualValue(cPtr);
    }
}

