/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.Analyzer;
import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.AnnotationHolder;
import com.pvsstudio.core.Annotations;
import com.pvsstudio.core.AstVisitor;
import com.pvsstudio.core.BinaryOperator;
import com.pvsstudio.core.ConditionTargets;
import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.JavaContext;
import com.pvsstudio.core.TypeCreationHistory;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.UnaryOperator;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.ValueSource;
import com.pvsstudio.core.ValuesContainer;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VirtualValue;

public class JavaDataFlow
extends Analyzer {
    private transient long swigCPtr;

    protected JavaDataFlow(long cPtr, boolean cMemoryOwn) {
        super(CoreJNI.JavaDataFlow_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(JavaDataFlow obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CoreJNI.delete_JavaDataFlow(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        CoreJNI.JavaDataFlow_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        CoreJNI.JavaDataFlow_change_ownership(this, this.swigCPtr, true);
    }

    public JavaDataFlow(Annotations annotations) {
        this(CoreJNI.new_JavaDataFlow(Annotations.getCPtr(annotations), annotations), true);
        CoreJNI.JavaDataFlow_director_connect(this, this.swigCPtr, true, true);
    }

    public long getParentStatement(long arg0) {
        return this.getClass() == JavaDataFlow.class ? CoreJNI.JavaDataFlow_getParentStatement(this.swigCPtr, this, arg0) : CoreJNI.JavaDataFlow_getParentStatementSwigExplicitJavaDataFlow(this.swigCPtr, this, arg0);
    }

    public boolean isRestrict(long arg0, long arg1) {
        return this.getClass() == JavaDataFlow.class ? CoreJNI.JavaDataFlow_isRestrict(this.swigCPtr, this, arg0, arg1) : CoreJNI.JavaDataFlow_isRestrictSwigExplicitJavaDataFlow(this.swigCPtr, this, arg0, arg1);
    }

    public VirtualValue getNewReference(Value baseValue, long idx, int count) {
        long cPtr = CoreJNI.JavaDataFlow_getNewReference__SWIG_0(this.swigCPtr, this, Value.getCPtr(baseValue), idx, count);
        return cPtr == 0L ? VirtualValue.EMPTY : new VirtualValue(cPtr);
    }

    public VirtualValue getNewReference(Value baseValue, long idx) {
        long cPtr = CoreJNI.JavaDataFlow_getNewReference__SWIG_1(this.swigCPtr, this, Value.getCPtr(baseValue), idx);
        return cPtr == 0L ? VirtualValue.EMPTY : new VirtualValue(cPtr);
    }

    public void setValue(Variable var, VirtualValue value, TypeCreationHistory history, ValueSource type) {
        CoreJNI.JavaDataFlow_setValue(this.swigCPtr, this, Variable.getCPtr(var), var, VirtualValue.getCPtr(value), history.swigValue(), type.swigValue());
    }

    public Variable getVariableField(Variable var, String field) {
        long cPtr = CoreJNI.JavaDataFlow_getVariableField__SWIG_0(this.swigCPtr, this, Variable.getCPtr(var), var, field);
        return new Variable(cPtr);
    }

    public Variable getVariableField(Variable var, long index) {
        long cPtr = CoreJNI.JavaDataFlow_getVariableField__SWIG_1(this.swigCPtr, this, Variable.getCPtr(var), var, index);
        return new Variable(cPtr);
    }

    public Variable getBoxedVariable(Variable var) {
        long cPtr = CoreJNI.JavaDataFlow_getBoxedVariable(this.swigCPtr, this, Variable.getCPtr(var), var);
        return new Variable(cPtr);
    }

    public Variable getVariable(String name) {
        long cPtr = CoreJNI.JavaDataFlow_getVariable(this.swigCPtr, this, name);
        return new Variable(cPtr);
    }

    public void visitBinaryCondition(ConditionTargets lhsTargets, Value lhs, String lhsType, boolean lhsIsPrimitive, ConditionTargets rhsTargets, Value rhs, String rhsType, boolean rhsIsPrimitive, BinaryOperator op) {
        CoreJNI.JavaDataFlow_visitBinaryCondition(this.swigCPtr, this, ConditionTargets.getCPtr(lhsTargets), lhsTargets, Value.getCPtr(lhs), lhsType, lhsIsPrimitive, ConditionTargets.getCPtr(rhsTargets), rhsTargets, Value.getCPtr(rhs), rhsType, rhsIsPrimitive, op.swigValue());
    }

    public void visitInstanceOfCondition(ConditionTargets targets) {
        CoreJNI.JavaDataFlow_visitInstanceOfCondition(this.swigCPtr, this, ConditionTargets.getCPtr(targets), targets);
    }

    public void visitContinue(ValuesContainer container) {
        CoreJNI.JavaDataFlow_visitContinue(this.swigCPtr, this, ValuesContainer.getCPtr(container), container);
    }

    public Value cast(Value value, String src, String dest) {
        long cPtr = CoreJNI.JavaDataFlow_cast(this.swigCPtr, this, Value.getCPtr(value), src, dest);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public void visitGoto(String label) {
        CoreJNI.JavaDataFlow_visitGoto(this.swigCPtr, this, label);
    }

    public Value visitBinaryOperation(String resultType, BinaryOperator op, Value lhs, String lhsType, Value rhs, String rhsType) {
        long cPtr = CoreJNI.JavaDataFlow_visitBinaryOperation(this.swigCPtr, this, resultType, op.swigValue(), Value.getCPtr(lhs), lhsType, Value.getCPtr(rhs), rhsType);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value generateIntPreciseValue() {
        long cPtr = CoreJNI.JavaDataFlow_generateIntPreciseValue(this.swigCPtr, this);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitBinaryAssignmentOperation(String resultType, BinaryOperator op, Value lhs, String lhsType, Value rhs, String rhsType, long tree) {
        long cPtr = CoreJNI.JavaDataFlow_visitBinaryAssignmentOperation(this.swigCPtr, this, resultType, op.swigValue(), Value.getCPtr(lhs), lhsType, Value.getCPtr(rhs), rhsType, tree);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitAssign(String lhsType, String rhsType, Value left, boolean isLogicOperator, long tree, AstVisitor visitor) {
        long cPtr = CoreJNI.JavaDataFlow_visitAssign(this.swigCPtr, this, lhsType, rhsType, Value.getCPtr(left), isLogicOperator, tree, AstVisitor.getCPtr(visitor), visitor);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitUnaryOperation(String resultType, String operandType, UnaryOperator op, Value expression, boolean isPostfix) {
        long cPtr = CoreJNI.JavaDataFlow_visitUnaryOperation(this.swigCPtr, this, resultType, operandType, op.swigValue(), Value.getCPtr(expression), isPostfix);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitTernaryCondition(String resultType, String leftType, String rightType, boolean isLogicOperator, long conditionIndex, AstVisitor condition, AstVisitor thenBranch, AstVisitor elseBranch) {
        long cPtr = CoreJNI.JavaDataFlow_visitTernaryCondition(this.swigCPtr, this, resultType, leftType, rightType, isLogicOperator, conditionIndex, AstVisitor.getCPtr(condition), condition, AstVisitor.getCPtr(thenBranch), thenBranch, AstVisitor.getCPtr(elseBranch), elseBranch);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitVariableReference(TypeInformation type, Variable variable) {
        long cPtr = CoreJNI.JavaDataFlow_visitVariableReference__SWIG_0(this.swigCPtr, this, TypeInformation.getCPtr(type), type, Variable.getCPtr(variable), variable);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitVariableReference(String type, Variable variable) {
        long cPtr = CoreJNI.JavaDataFlow_visitVariableReference__SWIG_1(this.swigCPtr, this, type, Variable.getCPtr(variable), variable);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitVariableFieldReference(String type, Value var, String member) {
        long cPtr = CoreJNI.JavaDataFlow_visitVariableFieldReference__SWIG_0(this.swigCPtr, this, type, Value.getCPtr(var), member);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitArrayLengthReference(String type, Value var, String member) {
        long cPtr = CoreJNI.JavaDataFlow_visitArrayLengthReference(this.swigCPtr, this, type, Value.getCPtr(var), member);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitArray(String type, Value var, Value index) {
        long cPtr = CoreJNI.JavaDataFlow_visitArray(this.swigCPtr, this, type, Value.getCPtr(var), Value.getCPtr(index));
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitVariableFieldReference(String type, Variable variable, long index) {
        long cPtr = CoreJNI.JavaDataFlow_visitVariableFieldReference__SWIG_1(this.swigCPtr, this, type, Variable.getCPtr(variable), variable, index);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitVariableFieldReference(String type, Variable variable, String member) {
        long cPtr = CoreJNI.JavaDataFlow_visitVariableFieldReference__SWIG_2(this.swigCPtr, this, type, Variable.getCPtr(variable), variable, member);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitUnknownValue(VirtualValue value) {
        long cPtr = CoreJNI.JavaDataFlow_visitUnknownValue(this.swigCPtr, this, VirtualValue.getCPtr(value));
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public void visitCase(Value value, String type) {
        CoreJNI.JavaDataFlow_visitCase(this.swigCPtr, this, Value.getCPtr(value), type);
    }

    public boolean visitCaseValue(Value value, String type) {
        return CoreJNI.JavaDataFlow_visitCaseValue(this.swigCPtr, this, Value.getCPtr(value), type);
    }

    public ConditionTargets getConditionTargets(Value expression, String typeName, boolean needUnbox) {
        return new ConditionTargets(CoreJNI.JavaDataFlow_getConditionTargets__SWIG_0(this.swigCPtr, this, Value.getCPtr(expression), typeName, needUnbox), true);
    }

    public ConditionTargets getConditionTargets(Annotation annotation, JavaContext context) {
        return new ConditionTargets(CoreJNI.JavaDataFlow_getConditionTargets__SWIG_1(this.swigCPtr, this, Annotation.getCPtr(annotation), annotation, JavaContext.getCPtr(context), context), true);
    }

    public Annotation getAnnotation(String name) {
        long cPtr = CoreJNI.JavaDataFlow_getAnnotation(this.swigCPtr, this, name);
        return new Annotation(cPtr);
    }

    public TypeInformation getType(String name) {
        return new TypeInformation(CoreJNI.JavaDataFlow_getType(this.swigCPtr, this, name), true);
    }

    public void deleteValue(Value expression, boolean onlyState) {
        CoreJNI.JavaDataFlow_deleteValue(this.swigCPtr, this, Value.getCPtr(expression), onlyState);
    }

    public void visitParameter(Variable variable, long tree) {
        CoreJNI.JavaDataFlow_visitParameter(this.swigCPtr, this, Variable.getCPtr(variable), variable, tree);
    }

    public long capacity() {
        return CoreJNI.JavaDataFlow_capacity(this.swigCPtr, this);
    }

    public AnnotationHolder createAnnotationFromInterproceduralInformation(long id) {
        return new AnnotationHolder(CoreJNI.JavaDataFlow_createAnnotationFromInterproceduralInformation(this.swigCPtr, this, id), true);
    }
}

