/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.Int128;
import com.pvsstudio.core.IntegerInterval;
import com.pvsstudio.core.OptionalChar;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Tribool;
import com.pvsstudio.core.VirtualValueOpt;

public class IntegerVirtualValue {
    private final long swigCPtr;

    protected IntegerVirtualValue(long cPtr) {
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IntegerVirtualValue p) {
        return p == null ? 0L : p.swigCPtr;
    }

    public boolean equals(Object o) {
        return o instanceof IntegerVirtualValue && ((IntegerVirtualValue)o).swigCPtr == this.swigCPtr;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public boolean isSizeOfSimplePointer() {
        return CoreJNI.IntegerVirtualValue_isSizeOfSimplePointer(this.swigCPtr);
    }

    public boolean isSizeONotCharArray() {
        return CoreJNI.IntegerVirtualValue_isSizeONotCharArray(this.swigCPtr);
    }

    public boolean isOverflow() {
        return CoreJNI.IntegerVirtualValue_isOverflow(this.swigCPtr);
    }

    public boolean isFromMod() {
        return CoreJNI.IntegerVirtualValue_isFromMod(this.swigCPtr);
    }

    public boolean isFromSignConversion() {
        return CoreJNI.IntegerVirtualValue_isFromSignConversion(this.swigCPtr);
    }

    public boolean isResource() {
        return CoreJNI.IntegerVirtualValue_isResource(this.swigCPtr);
    }

    public boolean contains(Int128 val) {
        return CoreJNI.IntegerVirtualValue_contains__SWIG_0(this.swigCPtr, Int128.getCPtr(val), val);
    }

    public boolean contains(long val) {
        return CoreJNI.IntegerVirtualValue_contains__SWIG_1(this.swigCPtr, val);
    }

    public boolean containsPrecise(Int128 val) {
        return CoreJNI.IntegerVirtualValue_containsPrecise__SWIG_0(this.swigCPtr, Int128.getCPtr(val), val);
    }

    public boolean containsPrecise(long val) {
        return CoreJNI.IntegerVirtualValue_containsPrecise__SWIG_1(this.swigCPtr, val);
    }

    public boolean containsPreciseFromRange(long min, long max) {
        return CoreJNI.IntegerVirtualValue_containsPreciseFromRange__SWIG_0(this.swigCPtr, min, max);
    }

    public boolean containsPreciseFromRange(Int128 min, Int128 max) {
        return CoreJNI.IntegerVirtualValue_containsPreciseFromRange__SWIG_1(this.swigCPtr, Int128.getCPtr(min), min, Int128.getCPtr(max), max);
    }

    public boolean isInInterval(Int128 from, Int128 to) {
        return CoreJNI.IntegerVirtualValue_isInInterval__SWIG_0(this.swigCPtr, Int128.getCPtr(from), from, Int128.getCPtr(to), to);
    }

    public boolean isInInterval(IntegerInterval other) {
        return CoreJNI.IntegerVirtualValue_isInInterval__SWIG_1(this.swigCPtr, IntegerInterval.getCPtr(other), other);
    }

    public boolean isInterval() {
        return CoreJNI.IntegerVirtualValue_isInterval(this.swigCPtr);
    }

    public boolean isPrecise() {
        return CoreJNI.IntegerVirtualValue_isPrecise(this.swigCPtr);
    }

    public boolean isUntrustedData() {
        return CoreJNI.IntegerVirtualValue_isUntrustedData(this.swigCPtr);
    }

    public boolean isVerifiedData() {
        return CoreJNI.IntegerVirtualValue_isVerifiedData(this.swigCPtr);
    }

    public Int128 min() {
        return new Int128(CoreJNI.IntegerVirtualValue_min__SWIG_0(this.swigCPtr), true);
    }

    public Int128 max() {
        return new Int128(CoreJNI.IntegerVirtualValue_max__SWIG_0(this.swigCPtr), true);
    }

    public OptionalInt128 singletonValue() {
        return new OptionalInt128(CoreJNI.IntegerVirtualValue_singletonValue(this.swigCPtr), true);
    }

    public OptionalInt128 minPrecise() {
        return new OptionalInt128(CoreJNI.IntegerVirtualValue_minPrecise(this.swigCPtr), true);
    }

    public OptionalInt128 maxPrecise() {
        return new OptionalInt128(CoreJNI.IntegerVirtualValue_maxPrecise(this.swigCPtr), true);
    }

    public short getLowerBytes() {
        return CoreJNI.IntegerVirtualValue_getLowerBytes(this.swigCPtr);
    }

    public short getUpperBytes() {
        return CoreJNI.IntegerVirtualValue_getUpperBytes(this.swigCPtr);
    }

    public long getCountOfUsedBits() {
        return CoreJNI.IntegerVirtualValue_getCountOfUsedBits(this.swigCPtr);
    }

    public long getOpenResourceTree() {
        return CoreJNI.IntegerVirtualValue_getOpenResourceTree(this.swigCPtr);
    }

    public long getUntrustedDataSourceTree() {
        return CoreJNI.IntegerVirtualValue_getUntrustedDataSourceTree(this.swigCPtr);
    }

    public long getBoundResource() {
        return CoreJNI.IntegerVirtualValue_getBoundResource(this.swigCPtr);
    }

    public Tribool toBool() {
        long cPtr = CoreJNI.IntegerVirtualValue_toBool(this.swigCPtr);
        return cPtr == 0L ? Tribool.False : (cPtr == 1L ? Tribool.True : Tribool.Indeterminate);
    }

    public PointerVirtualValue toPointer() {
        long cPtr = CoreJNI.IntegerVirtualValue_toPointer(this.swigCPtr);
        return new PointerVirtualValue(cPtr);
    }

    public OptionalChar toChar() {
        return new OptionalChar(CoreJNI.IntegerVirtualValue_toChar(this.swigCPtr), true);
    }

    public OptionalLong toLong() {
        return new OptionalLong(CoreJNI.IntegerVirtualValue_toLong(this.swigCPtr), true);
    }

    public IntegerVirtualValue bindResourceArg(long arg) {
        long cPtr = CoreJNI.IntegerVirtualValue_bindResourceArg(this.swigCPtr, arg);
        return new IntegerVirtualValue(cPtr);
    }

    public VirtualValueOpt min(IntegerVirtualValue other) {
        return new VirtualValueOpt(CoreJNI.IntegerVirtualValue_min__SWIG_1(this.swigCPtr, IntegerVirtualValue.getCPtr(other), other), true);
    }

    public VirtualValueOpt max(IntegerVirtualValue other) {
        return new VirtualValueOpt(CoreJNI.IntegerVirtualValue_max__SWIG_1(this.swigCPtr, IntegerVirtualValue.getCPtr(other), other), true);
    }

    public VirtualValueOpt abs(Pool pool, IntegerInterval typeInterval) {
        return new VirtualValueOpt(CoreJNI.IntegerVirtualValue_abs(this.swigCPtr, Pool.getCPtr(pool), pool, IntegerInterval.getCPtr(typeInterval), typeInterval), true);
    }

    public static IntegerVirtualValue fromMinMax(long min, long max) {
        long cPtr = CoreJNI.IntegerVirtualValue_fromMinMax(min, max);
        return new IntegerVirtualValue(cPtr);
    }

    public String toString() {
        return CoreJNI.IntegerVirtualValue_toString(this.swigCPtr);
    }
}

