/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.Int128;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.OptionalInterval;
import com.pvsstudio.core.TypeInformation;

public class IntegerInterval {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntegerInterval(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IntegerInterval obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CoreJNI.delete_IntegerInterval(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setMin(Int128 value) {
        CoreJNI.IntegerInterval_min_set(this.swigCPtr, this, Int128.getCPtr(value), value);
    }

    public Int128 getMin() {
        long cPtr = CoreJNI.IntegerInterval_min_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new Int128(cPtr, false);
    }

    public void setMax(Int128 value) {
        CoreJNI.IntegerInterval_max_set(this.swigCPtr, this, Int128.getCPtr(value), value);
    }

    public Int128 getMax() {
        long cPtr = CoreJNI.IntegerInterval_max_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new Int128(cPtr, false);
    }

    public IntegerInterval() {
        this(CoreJNI.new_IntegerInterval__SWIG_0(), true);
    }

    public IntegerInterval(TypeInformation type) {
        this(CoreJNI.new_IntegerInterval__SWIG_3(TypeInformation.getCPtr(type), type), true);
    }

    public OptionalInt128 singletonValue() {
        return new OptionalInt128(CoreJNI.IntegerInterval_singletonValue(this.swigCPtr, this), true);
    }

    public IntegerInterval union(IntegerInterval other) {
        return new IntegerInterval(CoreJNI.IntegerInterval_union(this.swigCPtr, this, IntegerInterval.getCPtr(other), other), true);
    }

    public OptionalInterval intersection(IntegerInterval other) {
        return new OptionalInterval(CoreJNI.IntegerInterval_intersection(this.swigCPtr, this, IntegerInterval.getCPtr(other), other), true);
    }

    public OptionalInterval relativeComplement(IntegerInterval other) {
        return new OptionalInterval(CoreJNI.IntegerInterval_relativeComplement(this.swigCPtr, this, IntegerInterval.getCPtr(other), other), true);
    }

    public IntegerInterval leftUnbounded(Int128 inf) {
        return new IntegerInterval(CoreJNI.IntegerInterval_leftUnbounded__SWIG_0(this.swigCPtr, this, Int128.getCPtr(inf), inf), true);
    }

    public IntegerInterval leftUnbounded() {
        return new IntegerInterval(CoreJNI.IntegerInterval_leftUnbounded__SWIG_1(this.swigCPtr, this), true);
    }

    public IntegerInterval rightUnbounded(Int128 inf) {
        return new IntegerInterval(CoreJNI.IntegerInterval_rightUnbounded__SWIG_0(this.swigCPtr, this, Int128.getCPtr(inf), inf), true);
    }

    public IntegerInterval rightUnbounded() {
        return new IntegerInterval(CoreJNI.IntegerInterval_rightUnbounded__SWIG_1(this.swigCPtr, this), true);
    }

    public IntegerInterval cast(TypeInformation type) {
        return new IntegerInterval(CoreJNI.IntegerInterval_cast(this.swigCPtr, this, TypeInformation.getCPtr(type), type), true);
    }

    public boolean contains(Int128 val) {
        return CoreJNI.IntegerInterval_contains__SWIG_0(this.swigCPtr, this, Int128.getCPtr(val), val);
    }

    public boolean contains(IntegerInterval val) {
        return CoreJNI.IntegerInterval_contains__SWIG_1(this.swigCPtr, this, IntegerInterval.getCPtr(val), val);
    }

    public IntegerInterval bitwiseNot(TypeInformation type) {
        return new IntegerInterval(CoreJNI.IntegerInterval_bitwiseNot(this.swigCPtr, this, TypeInformation.getCPtr(type), type), true);
    }

    public IntegerInterval clamp(IntegerInterval arg0) {
        return new IntegerInterval(CoreJNI.IntegerInterval_clamp(this.swigCPtr, this, IntegerInterval.getCPtr(arg0), arg0), true);
    }

    public boolean isInInterval(IntegerInterval val) {
        return CoreJNI.IntegerInterval_isInInterval(this.swigCPtr, this, IntegerInterval.getCPtr(val), val);
    }

    public String toString() {
        return CoreJNI.IntegerInterval_toString(this.swigCPtr, this);
    }
}

