/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.Analyzer;
import com.pvsstudio.core.Argument;
import com.pvsstudio.core.ArgumentsArray;
import com.pvsstudio.core.BasicAnnotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.IndexArray;
import com.pvsstudio.core.OptionalConstraint;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.Type;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.VirtualValueOpt;
import java.util.Optional;

public class Context {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Context(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Context obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CoreJNI.delete_Context(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setArgumentsNumber(int size) {
        CoreJNI.Context_setArgumentsNumber__SWIG_0(this.swigCPtr, this, size);
    }

    public void setArgumentsNumber(long size) {
        CoreJNI.Context_setArgumentsNumber__SWIG_1(this.swigCPtr, this, size);
    }

    public void setArgument(int i, Value value, TypeInformation type, long tree, long interproceduralTree, BasicAnnotation annotation) {
        CoreJNI.Context_setArgument(this.swigCPtr, this, i, Value.getCPtr(value), TypeInformation.getCPtr(type), type, tree, interproceduralTree, BasicAnnotation.getCPtr(annotation));
    }

    public void noThisArgument() {
        CoreJNI.Context_noThisArgument(this.swigCPtr, this);
    }

    public void setReturnType(TypeInformation type) {
        CoreJNI.Context_setReturnType__SWIG_0(this.swigCPtr, this, TypeInformation.getCPtr(type), type);
    }

    public void setReturnType(Type type) {
        CoreJNI.Context_setReturnType__SWIG_1(this.swigCPtr, this, type.swigValue());
    }

    public void setReturnValue(VirtualValueOpt val) {
        CoreJNI.Context_setReturnValue(this.swigCPtr, this, VirtualValueOpt.getCPtr(val), val);
    }

    public ArgumentsArray getArguments() {
        return new ArgumentsArray(CoreJNI.Context_getArguments(this.swigCPtr, this), true);
    }

    public Argument getArgument(long idx) {
        long cPtr = CoreJNI.Context_getArgument(this.swigCPtr, this, idx);
        return new Argument(cPtr);
    }

    public long getArgumentsCount() {
        return CoreJNI.Context_getArgumentsCount(this.swigCPtr, this);
    }

    public TypeInformation getReturnType() {
        return new TypeInformation(CoreJNI.Context_getReturnType(this.swigCPtr, this), true);
    }

    public IndexArray getPath() {
        return new IndexArray(CoreJNI.Context_getPath(this.swigCPtr, this), true);
    }

    public Pool getPool() {
        long cPtr = CoreJNI.Context_getPool(this.swigCPtr, this);
        return new Pool(cPtr);
    }

    public VirtualValueOpt getReturnValue() {
        return new VirtualValueOpt(CoreJNI.Context_getReturnValue(this.swigCPtr, this), false);
    }

    public Analyzer getAnalyzer() {
        return new Analyzer(CoreJNI.Context_getAnalyzer(this.swigCPtr, this), false);
    }

    public void setContract(Result result, Constraint type, IndexArray path) {
        CoreJNI.Context_setContract(this.swigCPtr, this, result.swigValue(), type.swigValue(), IndexArray.getCPtr(path), path);
    }

    public Result getContractResult() {
        return Result.swigToEnum(CoreJNI.Context_getContractResult(this.swigCPtr, this));
    }

    public Optional<Constraint> getContractType() {
        OptionalConstraint optvalue = new OptionalConstraint(CoreJNI.Context_getContractType(this.swigCPtr, this), false);
        if (optvalue.isPresent()) {
            return Optional.of(optvalue.get());
        }
        return Optional.empty();
    }

    public IndexArray getContractPath() {
        return new IndexArray(CoreJNI.Context_getContractPath(this.swigCPtr, this), true);
    }

    public void collectArguments(boolean value) {
        CoreJNI.Context_collectArguments(this.swigCPtr, this, value);
    }
}

